/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.cli.enzymes;

import com.compomics.cli.enzymes.EnzymesCLIInputBean;
import com.compomics.cli.enzymes.EnzymesCLIParams;
import com.compomics.cli.paths.PathSettingsCLI;
import com.compomics.util.experiment.biology.enzymes.Enzyme;
import com.compomics.util.experiment.biology.enzymes.EnzymeFactory;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;

public class EnzymesCLI {
    private final EnzymesCLIInputBean enzymesCLIInputBean;

    public EnzymesCLI(EnzymesCLIInputBean enzymesCLIInputBean) {
        this.enzymesCLIInputBean = enzymesCLIInputBean;
    }

    private static String getHeader() {
        return System.getProperty("line.separator") + "The EnzymesCLI command line allows the command line management of enzymes. It can be used to create and edit json files containing enzymes compatible with CompOmics tools." + System.getProperty("line.separator") + System.getProperty("line.separator") + "----------------------" + System.getProperty("line.separator") + "OPTIONS" + System.getProperty("line.separator") + "----------------------" + System.getProperty("line.separator") + System.getProperty("line.separator");
    }

    public static void main(String[] args) {
        try {
            String[] nonPathSettingArgsAsList = PathSettingsCLI.extractAndUpdatePathOptions(args);
            Options nonPathOptions = new Options();
            EnzymesCLIParams.createOptionsCLI(nonPathOptions);
            DefaultParser parser = new DefaultParser();
            CommandLine line = parser.parse(nonPathOptions, nonPathSettingArgsAsList);
            if (!EnzymesCLIInputBean.isValidStartup(line)) {
                PrintWriter lPrintWriter = new PrintWriter(System.out);
                lPrintWriter.print(System.getProperty("line.separator") + "========================================" + System.getProperty("line.separator"));
                lPrintWriter.print("Compomics Enzymes - Command Line" + System.getProperty("line.separator"));
                lPrintWriter.print("========================================" + System.getProperty("line.separator"));
                lPrintWriter.print(EnzymesCLI.getHeader());
                lPrintWriter.print(EnzymesCLIParams.getOptionsAsString());
                lPrintWriter.flush();
                lPrintWriter.close();
                System.exit(0);
            } else {
                EnzymesCLIInputBean inputBean = new EnzymesCLIInputBean(line);
                EnzymesCLI cli = new EnzymesCLI(inputBean);
                cli.call();
            }
        }
        catch (OutOfMemoryError e) {
            System.out.println("<CompomicsError>EnzymesCLI used up all the memory and had to be stopped.</CompomicsError>");
            System.err.println("Ran out of memory!");
            System.err.println("Memory given to the Java virtual machine: " + Runtime.getRuntime().maxMemory() + ".");
            System.err.println("Memory used by the Java virtual machine: " + Runtime.getRuntime().totalMemory() + ".");
            System.err.println("Free memory in the Java virtual machine: " + Runtime.getRuntime().freeMemory() + ".");
            e.printStackTrace();
        }
        catch (Exception e) {
            System.out.print("<CompomicsError>EnzymesCLI processing failed.</CompomicsError>");
            e.printStackTrace();
        }
    }

    public String toString() {
        return "EnzymesCLI{, cliInputBean=" + this.enzymesCLIInputBean + '}';
    }

    public Object call() {
        File outputFile;
        Enzyme enzymeToAdd;
        EnzymeFactory enzymeFactory;
        File inputFile = this.enzymesCLIInputBean.getFileIn();
        if (inputFile != null) {
            try {
                enzymeFactory = EnzymeFactory.loadFromFile(inputFile);
            }
            catch (IOException e) {
                System.out.println("An error occurred while importing the enzymes from " + inputFile + ".");
                return 1;
            }
        } else {
            enzymeFactory = EnzymeFactory.getInstance();
        }
        if (this.enzymesCLIInputBean.isList()) {
            for (Enzyme enzyme : enzymeFactory.getEnzymes()) {
                System.out.println(enzyme.getName() + ":");
                System.out.println(enzyme.getDescription());
                System.out.println();
            }
            return 0;
        }
        String enzymeToRemove = this.enzymesCLIInputBean.getEnzymeToRemove();
        if (enzymeToRemove != null) {
            enzymeFactory.removeEnzyme(enzymeToRemove);
        }
        if ((enzymeToAdd = this.enzymesCLIInputBean.getEnzymeToAdd()) != null) {
            enzymeFactory.addEnzyme(enzymeToAdd);
        }
        if ((outputFile = this.enzymesCLIInputBean.getFileOut()) != null) {
            try {
                EnzymeFactory.saveToFile(enzymeFactory, outputFile);
            }
            catch (IOException e) {
                System.out.println("An error occurred while saving the enzymes to " + outputFile + ".");
                return 1;
            }
        }
        return 0;
    }
}

