/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.cli.fasta;

import org.apache.commons.cli.Options;

public enum FastaParametersCLIParams {
    NAME("name", "The name of the database, FASTA file name by default.", false, true),
    DESCRIPTION("description", "The description of the database, FASTA file name by default.", false, true),
    VERSION("version", "The version of the database, date of creation of the file by default.", false, true),
    DECOY_FLAG("decoy_flag", "The decoy flag, default: -REVERSED.", false, true),
    SUFFIX("suffix", "The location of the decoy flag: (1) prefix, (2) suffix. Inferred if not specified.", false, true);

    public final String id;
    public final String description;
    public final boolean mandatory;
    public final boolean hasArgument;

    private FastaParametersCLIParams(String id, String description, boolean mandatory, boolean hasArgument) {
        this.id = id;
        this.description = description;
        this.mandatory = mandatory;
        this.hasArgument = hasArgument;
    }

    public static void createOptionsCLI(Options aOptions) {
        for (FastaParametersCLIParams identificationParametersCLIParams : FastaParametersCLIParams.values()) {
            aOptions.addOption(identificationParametersCLIParams.id, identificationParametersCLIParams.hasArgument, identificationParametersCLIParams.description);
        }
    }

    public static String getOptionsAsString() {
        String output = "";
        output = output + "\n\nFASTA Parameters:\n\n";
        for (FastaParametersCLIParams value : FastaParametersCLIParams.values()) {
            output = output + "-" + String.format("%-35s", value.id) + " " + value.description + "\n";
        }
        return output;
    }
}

