/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.cli.modifications;

import com.compomics.cli.modifications.ModificationsCLIParams;
import com.compomics.software.cli.CommandParameter;
import com.compomics.util.experiment.biology.aminoacids.sequence.AminoAcidPattern;
import com.compomics.util.experiment.biology.atoms.AtomChain;
import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationCategory;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.biology.modifications.ModificationType;
import java.io.File;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;

public class ModificationsCLIInputBean {
    private File fileIn = null;
    private File fileOut = null;
    private boolean list = false;
    private String modificationToRemove = null;
    private Modification modificationToAdd = null;

    public ModificationsCLIInputBean(CommandLine aLine) throws IOException {
        String arg;
        if (aLine.hasOption(ModificationsCLIParams.IN.id)) {
            arg = aLine.getOptionValue(ModificationsCLIParams.IN.id);
            this.fileIn = new File(arg);
        }
        if (aLine.hasOption(ModificationsCLIParams.LIST.id)) {
            this.list = true;
            return;
        }
        if (aLine.hasOption(ModificationsCLIParams.OUT.id)) {
            arg = aLine.getOptionValue(ModificationsCLIParams.OUT.id);
            this.fileOut = new File(arg);
        }
        if (aLine.hasOption(ModificationsCLIParams.RM.id)) {
            this.modificationToRemove = aLine.getOptionValue(ModificationsCLIParams.RM.id);
        }
        if (aLine.hasOption(ModificationsCLIParams.NAME.id)) {
            String modName = aLine.getOptionValue(ModificationsCLIParams.NAME.id);
            int modType = Integer.valueOf(aLine.getOptionValue(ModificationsCLIParams.TYPE.id));
            int modCategory = Integer.valueOf(aLine.getOptionValue(ModificationsCLIParams.CATEGORY.id));
            AtomChain atomChainAdded = null;
            if (aLine.hasOption(ModificationsCLIParams.COMPOSITION_ADDED.id)) {
                String arg2 = aLine.getOptionValue(ModificationsCLIParams.COMPOSITION_ADDED.id);
                atomChainAdded = AtomChain.getAtomChain(arg2);
            }
            AtomChain atomChainRemoved = null;
            if (aLine.hasOption(ModificationsCLIParams.COMPOSITION_REMOVED.id)) {
                String arg3 = aLine.getOptionValue(ModificationsCLIParams.COMPOSITION_REMOVED.id);
                atomChainRemoved = AtomChain.getAtomChain(arg3);
            }
            AminoAcidPattern aminoAcidPattern = null;
            if (aLine.hasOption(ModificationsCLIParams.PATTERN.id)) {
                String arg4 = aLine.getOptionValue(ModificationsCLIParams.PATTERN.id);
                aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString(arg4);
                Integer target = 0;
                if (aLine.hasOption(ModificationsCLIParams.PATTERN_INDEX.id)) {
                    arg4 = aLine.getOptionValue(ModificationsCLIParams.PATTERN_INDEX.id);
                    target = Integer.valueOf(arg4);
                }
                aminoAcidPattern.setTarget(target);
            }
            ModificationType modificationType = ModificationType.values()[modType];
            ModificationCategory modificationCategory = ModificationCategory.values()[modCategory];
            this.modificationToAdd = new Modification(modificationType, modName, modName, atomChainAdded, atomChainRemoved, aminoAcidPattern, modificationCategory);
            if (aLine.hasOption(ModificationsCLIParams.SHORT_NAME.id)) {
                String arg5 = aLine.getOptionValue(ModificationsCLIParams.SHORT_NAME.id);
                this.modificationToAdd.setShortName(arg5);
            }
        }
    }

    public static boolean isValidStartup(CommandLine aLine) {
        String arg;
        Modification ptm;
        String arg2;
        if (aLine.getOptions().length == 0) {
            return false;
        }
        ModificationFactory ptmFactory = null;
        if (aLine.hasOption(ModificationsCLIParams.IN.id)) {
            arg2 = aLine.getOptionValue(ModificationsCLIParams.IN.id);
            if (arg2.equals("")) {
                System.out.println(System.getProperty("line.separator") + "No input file specified!" + System.getProperty("line.separator"));
                return false;
            }
            File fileIn = new File(arg2);
            if (!fileIn.exists()) {
                System.out.println(System.getProperty("line.separator") + "File " + fileIn + " not found." + System.getProperty("line.separator"));
                return false;
            }
            try {
                ptmFactory = ModificationFactory.loadFromFile(fileIn);
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing " + fileIn + "." + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(ModificationsCLIParams.LIST.id)) {
            return true;
        }
        if (aLine.hasOption(ModificationsCLIParams.RM.id) && (ptm = ptmFactory.getModification(arg2 = aLine.getOptionValue(ModificationsCLIParams.RM.id))) == null) {
            String file = aLine.getOptionValue(ModificationsCLIParams.IN.id);
            System.out.println(System.getProperty("line.separator") + "Enzyme " + arg2 + " not found in " + file + "." + System.getProperty("line.separator"));
            return false;
        }
        boolean name = aLine.hasOption(ModificationsCLIParams.NAME.id);
        boolean composition = false;
        boolean pattern = false;
        if (aLine.hasOption(ModificationsCLIParams.COMPOSITION_ADDED.id)) {
            if (!name) {
                System.out.println(System.getProperty("line.separator") + "No name provided for the PTM to add." + System.getProperty("line.separator"));
                return false;
            }
            arg = aLine.getOptionValue(ModificationsCLIParams.COMPOSITION_ADDED.id);
            try {
                AtomChain.getAtomChain(arg);
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the added atomic composition of the PTM." + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
            composition = true;
        }
        if (aLine.hasOption(ModificationsCLIParams.COMPOSITION_REMOVED.id)) {
            if (!name) {
                System.out.println(System.getProperty("line.separator") + "No name provided for the PTM to add." + System.getProperty("line.separator"));
                return false;
            }
            arg = aLine.getOptionValue(ModificationsCLIParams.COMPOSITION_REMOVED.id);
            try {
                AtomChain.getAtomChain(arg);
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the removed atomic composition of the PTM." + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
            composition = true;
        }
        if (name && !composition) {
            System.out.println(System.getProperty("line.separator") + "No atomic composition found for the PTM to add." + System.getProperty("line.separator"));
            return false;
        }
        if (aLine.hasOption(ModificationsCLIParams.PATTERN.id)) {
            if (!name) {
                System.out.println(System.getProperty("line.separator") + "No name provided for the PTM to add." + System.getProperty("line.separator"));
                return false;
            }
            arg = aLine.getOptionValue(ModificationsCLIParams.PATTERN.id);
            try {
                AminoAcidPattern.getAminoAcidPatternFromString(arg);
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the amino acid pattern of the PTM." + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
            pattern = true;
        }
        if (aLine.hasOption(ModificationsCLIParams.TYPE.id)) {
            arg = aLine.getOptionValue(ModificationsCLIParams.TYPE.id);
            if (!CommandParameter.isPositiveInteger(ModificationsCLIParams.TYPE.id, arg, true)) {
                return false;
            }
            Integer type = Integer.valueOf(arg);
            if (type >= ModificationType.values().length || type < 0) {
                System.out.println(System.getProperty("line.separator") + "No modification type found for index " + type + "." + System.getProperty("line.separator"));
                return false;
            }
            if (!(pattern || type != ModificationType.modaa.index && type != ModificationType.modcaa_peptide.index && type != ModificationType.modcaa_protein.index && type != ModificationType.modnaa_peptide.index && type != ModificationType.modnaa_protein.index)) {
                System.out.println(System.getProperty("line.separator") + "No amino acid pattern found for PTM targetting specific amino acids." + System.getProperty("line.separator"));
                return false;
            }
            if (pattern) {
                System.out.println(System.getProperty("line.separator") + "Amino acid pattern found for PTM targetting a terminus." + System.getProperty("line.separator"));
                return false;
            }
        } else if (name) {
            System.out.println(System.getProperty("line.separator") + "No PTM type found for the PTM to add." + System.getProperty("line.separator"));
            return false;
        }
        if (aLine.hasOption(ModificationsCLIParams.CATEGORY.id) && !CommandParameter.isPositiveInteger(ModificationsCLIParams.CATEGORY.id, arg = aLine.getOptionValue(ModificationsCLIParams.CATEGORY.id), true)) {
            return false;
        }
        if (aLine.hasOption(ModificationsCLIParams.PATTERN_INDEX.id)) {
            if (!name) {
                System.out.println(System.getProperty("line.separator") + "No name provided for the enzyme to add." + System.getProperty("line.separator"));
                return false;
            }
            arg = aLine.getOptionValue(ModificationsCLIParams.PATTERN_INDEX.id);
            if (!CommandParameter.isInteger(ModificationsCLIParams.PATTERN_INDEX.id, arg)) {
                return false;
            }
        }
        return true;
    }

    public File getFileIn() {
        return this.fileIn;
    }

    public File getFileOut() {
        return this.fileOut;
    }

    public boolean isList() {
        return this.list;
    }

    public String getModificationToRemove() {
        return this.modificationToRemove;
    }

    public Modification getModificationToAdd() {
        return this.modificationToAdd;
    }
}

