/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.software;

import com.compomics.software.autoupdater.DownloadLatestZipFromRepo;
import com.compomics.software.autoupdater.GUIFileDAO;
import com.compomics.software.autoupdater.MavenJarFile;
import com.compomics.software.autoupdater.WebDAO;
import com.compomics.software.cli.CommandLineUtils;
import com.compomics.util.Util;
import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.gui.JOptionEditorPane;
import com.compomics.util.gui.UtilitiesGUIDefaults;
import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import com.compomics.util.io.StreamGobbler;
import com.compomics.util.parameters.UtilitiesUserParameters;
import java.awt.Frame;
import java.awt.Image;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.xml.stream.XMLStreamException;

public class CompomicsWrapper {
    private final boolean useStartUpLog = true;
    private boolean firstTry = true;
    private boolean proxySettingsFound = false;
    private UtilitiesUserParameters userParameters;
    private static ProgressDialogX progressDialog;

    public void launchTool(String toolName, File jarFile, String splashName, String mainClass) {
        this.launchTool(toolName, jarFile, splashName, mainClass, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void launchTool(String toolName, File jarFile, String splashName, String mainClass, String[] args) {
        Writer bw = null;
        try {
            try {
                this.userParameters = UtilitiesUserParameters.loadUserParameters();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            File folder = new File(jarFile.getParentFile(), "resources/conf");
            if (!folder.exists()) {
                String path = URLDecoder.decode(jarFile.getParentFile().getAbsolutePath(), "UTF-8");
                folder = new File(path, "resources/conf");
            }
            if (!folder.exists()) {
                if (!folder.mkdirs()) throw new FileNotFoundException(folder.getAbsolutePath() + " not found!");
                this.copyDefaultJavaOptionsFile(folder);
            } else if (!new File(folder.getAbsolutePath(), "JavaOptions.txt").exists()) {
                this.copyDefaultJavaOptionsFile(folder);
            }
            File debugOutput = new File(folder, "startup.log");
            FileWriter fw = new FileWriter(debugOutput);
            bw = new BufferedWriter(fw);
            bw.write("Memory settings read from the user preferences: " + this.userParameters.getMemoryParameter() + System.getProperty("line.separator"));
            bw.write("args: ");
            if (args != null) {
                bw.write(String.join((CharSequence)" ", args));
            }
            ((BufferedWriter)bw).newLine();
            CompomicsWrapper.checkJavaVersion(toolName);
            try {
                UtilitiesGUIDefaults.setLookAndFeel();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, "Seems like you are trying to start " + toolName + " from within a zip file!", toolName + " - Startup Failed", 0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.launch(jarFile, splashName, mainClass, args, (BufferedWriter)bw);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                if (bw != null) {
                    bw.write(e.getMessage());
                    ((BufferedWriter)bw).close();
                }
                JOptionPane.showMessageDialog(null, "Failed to start " + toolName + ":" + System.getProperty("line.separator") + e.getMessage(), toolName + " - Startup Failed", 0);
                return;
            }
            catch (IOException ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(null, "Failed to start " + toolName + ":" + System.getProperty("line.separator") + e.getMessage() + "\nCould not write to statup.log file", toolName + " - Startup Failed", 0);
            }
        }
    }

    private void launch(File jarFile, String splashName, String mainClass, String[] args, BufferedWriter bw) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        String jarFilePath;
        File confFolder = new File(jarFile.getParentFile(), "resources/conf");
        String javaHome = this.getJavaHome(confFolder, bw);
        String splashPath = null;
        if (splashName != null) {
            splashPath = "resources/conf" + File.separator + splashName;
            if (System.getProperty("os.name").lastIndexOf("Windows") != -1 && (splashPath = splashPath.replace("/", "\\")).startsWith("\\") && !splashPath.startsWith("\\\\")) {
                splashPath = splashPath.substring(1);
            }
        }
        String uniprotProxyClassPath = "";
        String quote = CommandLineUtils.getQuoteType();
        if (this.proxySettingsFound) {
            uniprotProxyClassPath = confFolder.getAbsolutePath() + File.separator + "proxy";
            if (System.getProperty("os.name").lastIndexOf("Windows") != -1 && (uniprotProxyClassPath = uniprotProxyClassPath.replace("/", "\\")).startsWith("\\") && !uniprotProxyClassPath.startsWith("\\\\")) {
                uniprotProxyClassPath = uniprotProxyClassPath.substring(1);
            }
            uniprotProxyClassPath = ";" + quote + uniprotProxyClassPath + quote;
        }
        if (!new File(jarFilePath = jarFile.getAbsolutePath()).exists()) {
            jarFilePath = URLDecoder.decode(jarFile.getAbsolutePath(), "UTF-8");
        }
        ArrayList<String> process_name_array = new ArrayList<String>();
        process_name_array.add(javaHome);
        if (splashName != null) {
            process_name_array.add("-splash:" + splashPath);
        }
        ArrayList<String> optionsAsList = this.getJavaOptions(confFolder, bw);
        for (String string : optionsAsList) {
            process_name_array.add(string);
        }
        process_name_array.add("-cp");
        String classPath = quote + jarFilePath;
        if (uniprotProxyClassPath.trim().length() > 0) {
            classPath = classPath + uniprotProxyClassPath;
        }
        classPath = classPath + quote;
        process_name_array.add(classPath);
        process_name_array.add(mainClass);
        if (args != null) {
            process_name_array.addAll(Arrays.asList(args));
        }
        process_name_array.trimToSize();
        bw.write("Java runtime version: " + System.getProperty("java.runtime.version") + System.getProperty("line.separator"));
        System.out.println(System.getProperty("line.separator") + System.getProperty("line.separator") + "Command line: ");
        bw.write(System.getProperty("line.separator") + "Command line: " + System.getProperty("line.separator"));
        for (String processEntry : process_name_array) {
            System.out.print(processEntry + " ");
            bw.write(processEntry + " ");
        }
        bw.write(System.getProperty("line.separator"));
        System.out.println(System.getProperty("line.separator"));
        bw.flush();
        ProcessBuilder processBuilder = new ProcessBuilder(process_name_array);
        try {
            Process p = processBuilder.start();
            StreamGobbler errorGobbler = new StreamGobbler(p.getErrorStream());
            Thread errorThread = new Thread(errorGobbler);
            StreamGobbler inputGobbler = new StreamGobbler(p.getInputStream());
            Thread inputThread = new Thread(inputGobbler);
            errorThread.start();
            inputThread.start();
            int exitValue = p.waitFor();
            errorGobbler.setContinueReading(true);
            inputGobbler.setContinueReading(true);
            System.out.println("Process exitValue: " + exitValue + System.getProperty("line.separator"));
            bw.write("Process exitValue: " + exitValue + System.getProperty("line.separator"));
            if (exitValue != 0) {
                this.firstTry = false;
                String errorMessage = errorGobbler.getMessages().toLowerCase();
                String inputMessage = inputGobbler.getMessages().toLowerCase();
                if (errorMessage.contains("could not create the java virtual machine") || inputMessage.contains("could not reserve enough space")) {
                    if (this.userParameters.getMemoryParameter() > 4096) {
                        this.userParameters.setMemoryParameter(this.userParameters.getMemoryParameter() / 2);
                        UtilitiesUserParameters.saveUserParameters(this.userParameters);
                        this.launch(jarFile, splashName, mainClass, args, bw);
                    } else if (this.userParameters.getMemoryParameter() > 2048) {
                        this.userParameters.setMemoryParameter(this.userParameters.getMemoryParameter() - 1024);
                        UtilitiesUserParameters.saveUserParameters(this.userParameters);
                        this.launch(jarFile, splashName, mainClass, args, bw);
                    } else if (this.userParameters.getMemoryParameter() > 1024) {
                        this.userParameters.setMemoryParameter(this.userParameters.getMemoryParameter() - 512);
                        UtilitiesUserParameters.saveUserParameters(this.userParameters);
                        this.launch(jarFile, splashName, mainClass, args, bw);
                    } else if (this.userParameters.getMemoryParameter() <= 1024) {
                        this.userParameters.setMemoryParameter(800);
                        UtilitiesUserParameters.saveUserParameters(this.userParameters);
                        this.launch(jarFile, splashName, mainClass, args, bw);
                    } else {
                        bw.write("Memory Limit: " + this.userParameters.getMemoryParameter() + System.getProperty("line.separator"));
                        bw.close();
                        JOptionPane.showMessageDialog(null, JOptionEditorPane.getJOptionEditorPane("Failed to create the Java virtual machine.<br><br>Inspect the log file for details: resources/conf/startup.log.<br><br>Then go to <a href=\"https://compomics.github.io/projects/compomics-utilities/wiki/JavaTroubleShooting.html\">Java TroubleShooting</a>."), "Startup Failed", 0);
                        System.exit(0);
                    }
                } else if (errorMessage.toLowerCase().contains("cgcontextgetctm: invalid context") || errorMessage.toLowerCase().contains("cgcontextsetbasectm: invalid context")) {
                    System.out.println("Mac OS/Java error (can be ignored): " + errorMessage);
                } else {
                    if (errorMessage.lastIndexOf("noclassdeffound") != -1) {
                        JOptionPane.showMessageDialog(null, "It seems like you are trying to start the tool from within a zip file!", "Startup Failed", 0);
                    } else {
                        System.out.println("Unknown error: " + errorMessage);
                        JOptionPane.showMessageDialog(null, JOptionEditorPane.getJOptionEditorPane("An error occurred when starting the tool.<br><br>Inspect the log file for details: resources/conf/startup.log.<br><br>Then go to <a href=\"https://compomics.github.io/projects/compomics-utilities/wiki/JavaTroubleShooting.html\">Java TroubleShooting</a>."), "Startup Error", 0);
                    }
                    bw.write(errorMessage);
                    bw.write(inputMessage);
                    bw.close();
                    System.exit(0);
                }
            } else {
                if (bw != null) {
                    bw.close();
                }
                System.exit(0);
            }
        }
        catch (Throwable t) {
            if (bw != null) {
                bw.write(t.getMessage());
                bw.close();
            }
            t.printStackTrace();
            System.exit(0);
        }
    }

    public static String getJarFilePath(String classPath, String toolName) {
        String path = classPath;
        toolName = toolName + "-";
        if (path.lastIndexOf("/" + toolName) != -1) {
            path = path.startsWith("file:") ? path.substring("file:".length(), path.lastIndexOf("/" + toolName)) : path.substring(0, path.lastIndexOf("/" + toolName));
            path = path.replace("%20", " ");
            path = path.replace("%5b", "[");
            path = path.replace("%5d", "]");
            if (System.getProperty("os.name").lastIndexOf("Windows") != -1) {
                path = path.replace("/", "\\");
            }
        } else {
            path = ".";
        }
        try {
            if (!new File(path).exists()) {
                path = URLDecoder.decode(path, "UTF-8");
            }
            if (!new File(path).exists()) {
                System.out.println(path + " not found!");
                FileNotFoundException ex = new FileNotFoundException(path + " not found!");
                ex.printStackTrace();
            }
        }
        catch (UnsupportedEncodingException ex) {
            System.out.println("Error reading file " + path + "!");
            ex.printStackTrace();
        }
        return path;
    }

    public static boolean is64BitJava() {
        String arch = System.getProperty("os.arch");
        return !arch.endsWith("x86");
    }

    public static void checkJavaVersion(String toolName) {
        String arch;
        JEditorPane ep;
        JLabel label;
        String javaVersion = System.getProperty("java.runtime.version");
        int javaVersionNumber = javaVersion.contains(".") ? Integer.parseInt(javaVersion.substring(0, javaVersion.indexOf("."))) : (javaVersion.contains("+") ? Integer.parseInt(javaVersion.substring(0, javaVersion.indexOf("+"))) : Integer.parseInt(javaVersion));
        if (javaVersionNumber < 11) {
            label = new JLabel();
            ep = new JEditorPane("text/html", "<html><body bgcolor=\"#" + Util.color2Hex(label.getBackground()) + "\">Running with Java version " + javaVersion + ", " + toolName + " works best with Java >= 11.<br><br>See <a href=\"https://compomics.github.io/projects/compomics-utilities/wiki/JavaTroubleShooting.html\">Java Troubleshooting</a> for more details.</body></html>");
            ep.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                        BareBonesBrowserLaunch.openURL(e.getURL().toString());
                    }
                }
            });
            ep.setBorder(null);
            ep.setEditable(false);
            JOptionPane.showMessageDialog(null, ep, "Update Java?", 1);
        }
        if (javaVersionNumber == 17) {
            label = new JLabel();
            ep = new JEditorPane("text/html", "<html><body bgcolor=\"#" + Util.color2Hex(label.getBackground()) + "\">Running with Java version " + javaVersion + ", issues with Java 17 have been reported when using " + toolName + ", we recommend updating to Java 18.<br><br>See <a href=\"https://compomics.github.io/projects/compomics-utilities/wiki/JavaTroubleShooting.html\">Java Troubleshooting</a> for more details.</body></html>");
            ep.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                        BareBonesBrowserLaunch.openURL(e.getURL().toString());
                    }
                }
            });
            ep.setBorder(null);
            ep.setEditable(false);
            JOptionPane.showMessageDialog(null, ep, "Update Java?", 1);
        }
        if ((arch = System.getProperty("os.arch")).endsWith("x86")) {
            JLabel label2 = new JLabel();
            JEditorPane ep2 = new JEditorPane("text/html", "<html><body bgcolor=\"#" + Util.color2Hex(label2.getBackground()) + "\">" + toolName + " works best with Java 64 bit.<br><br>See <a href=\"https://compomics.github.io/projects/compomics-utilities/wiki/JavaTroubleShooting.html\">Java Troubleshooting</a> for more details.</body></html>");
            ep2.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                        BareBonesBrowserLaunch.openURL(e.getURL().toString());
                    }
                }
            });
            ep2.setBorder(null);
            ep2.setEditable(false);
            JOptionPane.showMessageDialog(null, ep2, "Java 64 Bit?", 1);
        }
    }

    public static boolean checkForNewDeployedVersion(final String toolName, final MavenJarFile oldMavenJarFile, final URL jarRepository, final String iconName, final boolean deleteOldFiles, final boolean startDownloadedVersion, final boolean addDesktopIcon, Image normalIcon, Image waitingIcon, final boolean exitJavaOnCancel) {
        boolean update = false;
        try {
            if (WebDAO.newVersionReleased(oldMavenJarFile, jarRepository)) {
                int option = JOptionPane.showConfirmDialog(null, "A newer version of " + toolName + " is available.\nDo you want to update?", "Update Available", 1);
                if (option == 0) {
                    update = true;
                } else if ((option == 2 || option == -1) && exitJavaOnCancel) {
                    System.exit(0);
                }
            }
            if (update) {
                progressDialog = new ProgressDialogX((Frame)new JFrame(), normalIcon, waitingIcon, true);
                progressDialog.setPrimaryProgressCounterIndeterminate(true);
                progressDialog.setTitle("Updating " + toolName + ". Please Wait...");
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            progressDialog.setVisible(true);
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            // empty catch block
                        }
                    }
                }, "ProgressDialog").start();
                new Thread("DisplayThread"){

                    @Override
                    public void run() {
                        try {
                            DownloadLatestZipFromRepo.downloadLatestZipFromRepo(oldMavenJarFile.getJarPath().toURL(), toolName, deleteOldFiles, iconName, null, jarRepository, startDownloadedVersion, addDesktopIcon, progressDialog);
                            if (!progressDialog.isRunFinished()) {
                                progressDialog.setRunFinished();
                            }
                            if (toolName.equals("PeptideShaker")) {
                                Util.sendGAUpdate("UA-36198780-1", "update", "peptide-shaker");
                            } else if (toolName.equals("SearchGUI")) {
                                Util.sendGAUpdate("UA-36198780-2", "update", "searchgui");
                            }
                            if (exitJavaOnCancel) {
                                System.exit(0);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            if (!progressDialog.isRunFinished()) {
                                progressDialog.setRunFinished();
                            }
                            JOptionPane.showMessageDialog(null, "An error occured when trying to update " + toolName + ":\n" + e.getMessage(), "Update Failed", 2);
                            System.exit(0);
                        }
                    }
                }.start();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        return update;
    }

    public static boolean downloadLatestVersion(final String toolName, final String groupId, final String artifactId, final File downloadFolder, final URL jarRepository, final String iconName, final boolean startDownloadedVersion, final boolean addDesktopIcon, Image normalIcon, Image waitingIcon, final boolean exitJavaOnCancel) {
        boolean update = false;
        progressDialog = new ProgressDialogX((Frame)new JFrame(), normalIcon, waitingIcon, true);
        progressDialog.setPrimaryProgressCounterIndeterminate(true);
        progressDialog.setTitle("Downloading " + toolName + ". Please Wait...");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    progressDialog.setVisible(true);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }, "ProgressDialog").start();
        new Thread("DisplayThread"){

            @Override
            public void run() {
                try {
                    DownloadLatestZipFromRepo.downloadLatestZipFromRepo(downloadFolder, toolName, groupId, artifactId, iconName, null, jarRepository, startDownloadedVersion, addDesktopIcon, new GUIFileDAO(), progressDialog);
                    if (!progressDialog.isRunFinished()) {
                        progressDialog.setRunFinished();
                    }
                    if (exitJavaOnCancel) {
                        System.exit(0);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
                catch (XMLStreamException e) {
                    e.printStackTrace();
                }
            }
        }.start();
        return update;
    }

    public static boolean appRunningIntoConda(String condaAppName) {
        String someCondaEnvironmentActivated = System.getenv().get("CONDA_DEFAULT_ENV");
        boolean running = false;
        if (someCondaEnvironmentActivated != null) {
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            processBuilder.command("bash", "-c", "which " + condaAppName);
            try {
                Process process = processBuilder.start();
                int exitVal = process.waitFor();
                if (exitVal == 0) {
                    running = true;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return running;
    }

    private ArrayList<String> getJavaOptions(File confFolder, BufferedWriter bw) throws IOException {
        ArrayList<String> options;
        block28: {
            try {
                this.userParameters = UtilitiesUserParameters.loadUserParameters();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            options = new ArrayList<String>();
            File javaOptions = new File(confFolder, "JavaOptions.txt");
            File uniprotApiPropertiesFile = new File(confFolder, "proxy/uniprotjapi.properties");
            String uniprotApiProperties = "";
            if (javaOptions.exists()) {
                try {
                    FileReader f = new FileReader(javaOptions);
                    BufferedReader b = new BufferedReader(f);
                    String currentOption = b.readLine();
                    while (currentOption != null) {
                        if (currentOption.startsWith("-Xmx")) {
                            if (this.firstTry) {
                                currentOption = currentOption.substring(4, currentOption.length() - 1);
                                boolean input = false;
                                for (char c : currentOption.toCharArray()) {
                                    if (c == '*') continue;
                                    input = true;
                                    break;
                                }
                                if (input) {
                                    try {
                                        this.userParameters.setMemoryParameter(Integer.valueOf(currentOption));
                                        UtilitiesUserParameters.saveUserParameters(this.userParameters);
                                        if (bw != null) {
                                            bw.write("New memory setting saved: " + this.userParameters.getMemoryParameter() + System.getProperty("line.separator"));
                                        }
                                    }
                                    catch (Exception e) {
                                        JOptionPane.showMessageDialog(null, "Could not parse the memory setting: " + currentOption + ". The value was reset to" + this.userParameters.getMemoryParameter() + ".", "Wrong memory settings", 2);
                                    }
                                }
                            }
                        } else if (!currentOption.startsWith("#")) {
                            if (currentOption.startsWith("-Dhttp")) {
                                this.proxySettingsFound = true;
                                String[] tempProxySetting = currentOption.split("=");
                                if (tempProxySetting[0].equalsIgnoreCase("-Dhttp.proxyHost")) {
                                    uniprotApiProperties = uniprotApiProperties + "proxy.host=" + tempProxySetting[1] + System.getProperty("line.separator");
                                } else if (tempProxySetting[0].equalsIgnoreCase("-Dhttp.proxyPort")) {
                                    uniprotApiProperties = uniprotApiProperties + "proxy.port=" + tempProxySetting[1] + System.getProperty("line.separator");
                                } else if (tempProxySetting[0].equalsIgnoreCase("-Dhttp.proxyUser")) {
                                    uniprotApiProperties = uniprotApiProperties + "username=" + tempProxySetting[1] + System.getProperty("line.separator");
                                } else if (tempProxySetting[0].equalsIgnoreCase("-Dhttp.proxyPassword")) {
                                    uniprotApiProperties = uniprotApiProperties + "password=" + tempProxySetting[1] + System.getProperty("line.separator");
                                }
                            }
                            options.add(currentOption.trim());
                        }
                        currentOption = b.readLine();
                    }
                    if (this.proxySettingsFound) {
                        FileWriter uniprotProxyWriter = new FileWriter(uniprotApiPropertiesFile);
                        BufferedWriter uniprotProxyBufferedWriter = new BufferedWriter(uniprotProxyWriter);
                        uniprotProxyBufferedWriter.write(uniprotApiProperties);
                        uniprotProxyBufferedWriter.close();
                        uniprotProxyWriter.close();
                    }
                    b.close();
                    f.close();
                    options.add("-Xmx" + this.userParameters.getMemoryParameter() + "M");
                }
                catch (FileNotFoundException ex) {
                    ex.printStackTrace();
                    if (bw != null) {
                        bw.write(ex.getMessage());
                    }
                    break block28;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    if (bw != null) {
                        bw.write(ex.getMessage());
                    }
                    break block28;
                }
            }
            options.add("-Xms128M");
            options.add("-Xmx1024M");
        }
        return options;
    }

    private String getJavaHome(File confFolder, BufferedWriter bw) throws IOException {
        String javaHome;
        boolean usingStandardJavaHome;
        block18: {
            usingStandardJavaHome = true;
            javaHome = System.getProperty("java.home") + File.separator + "bin" + File.separator;
            File nonStandardJavaHome = new File(confFolder, "JavaHome.txt");
            if (nonStandardJavaHome.exists()) {
                try {
                    FileReader f = new FileReader(nonStandardJavaHome);
                    BufferedReader b = new BufferedReader(f);
                    String tempLocation = b.readLine();
                    if (!tempLocation.endsWith(File.separator)) {
                        tempLocation = tempLocation + File.separator;
                    }
                    if (new File(tempLocation).exists() && (new File(tempLocation, "java.exe").exists() || new File(tempLocation, "java").exists())) {
                        javaHome = tempLocation;
                        usingStandardJavaHome = false;
                    } else if (this.firstTry) {
                        JOptionPane.showMessageDialog(null, "Non-standard Java home location not found.\nUsing default Java home.", "Java Home Not Found!", 2);
                    }
                    b.close();
                    f.close();
                }
                catch (FileNotFoundException ex) {
                    if (this.firstTry) {
                        ex.printStackTrace();
                        JOptionPane.showMessageDialog(null, "Non-standard Java home location not found.\nUsing default Java home", "Java Home Not Found!", 2);
                    }
                    break block18;
                }
                catch (IOException ex) {
                    if (this.firstTry) {
                        ex.printStackTrace();
                        JOptionPane.showMessageDialog(null, "Error when reading non-standard Java home location.\nUsing default Java home.", "Java Home Error", 2);
                    }
                    break block18;
                }
            }
            try {
                this.userParameters = UtilitiesUserParameters.loadUserParameters();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.userParameters.getJavaHome() != null && new File(this.userParameters.getJavaHome()).exists() && (new File(this.userParameters.getJavaHome(), "java.exe").exists() || new File(this.userParameters.getJavaHome(), "java").exists())) {
                javaHome = this.userParameters.getJavaHome();
                usingStandardJavaHome = false;
            }
        }
        if (bw != null) {
            bw.write("original java.home: " + javaHome + System.getProperty("line.separator"));
        }
        if (usingStandardJavaHome && javaHome.lastIndexOf(" (x86)") != -1 && System.getProperty("os.name").lastIndexOf("Windows") != -1) {
            String tempJavaHome = javaHome.replaceAll(" \\(x86\\)", "");
            if (bw != null) {
                bw.write("temp java.home: " + tempJavaHome + System.getProperty("line.separator"));
            }
            if (new File(tempJavaHome).exists()) {
                javaHome = tempJavaHome;
            }
        }
        if (bw != null) {
            bw.write("new java.home: " + javaHome + System.getProperty("line.separator"));
        }
        String quote = CommandLineUtils.getQuoteType();
        javaHome = quote + javaHome + "java" + quote;
        return javaHome;
    }

    public ArrayList<String> getJavaHomeAndOptions(String toolPath) throws FileNotFoundException, IOException, ClassNotFoundException {
        ArrayList<String> javaHomeAndOptions = new ArrayList<String>();
        CompomicsWrapper wrapper = new CompomicsWrapper();
        File confFolder = new File(new File(toolPath).getParentFile(), "resources/conf");
        if (!confFolder.exists()) {
            String path = URLDecoder.decode(new File(toolPath).getParentFile().getAbsolutePath(), "UTF-8");
            confFolder = new File(path, "resources/conf");
        }
        String javaHome = wrapper.getJavaHome(confFolder, null);
        javaHomeAndOptions.add(javaHome);
        ArrayList<String> optionsAsList = wrapper.getJavaOptions(confFolder, null);
        for (String tempOption : optionsAsList) {
            javaHomeAndOptions.add(tempOption);
        }
        return javaHomeAndOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyDefaultJavaOptionsFile(File folder) throws IOException {
        File destination = new File(folder.getAbsolutePath() + "/JavaOptions.txt");
        InputStream resStreamIn = this.getClass().getClassLoader().getResourceAsStream("DefaultJavaOptions.txt");
        FileOutputStream resStreamOut = new FileOutputStream(destination);
        try {
            int readBytes;
            byte[] buffer = new byte[1024];
            while ((readBytes = resStreamIn.read(buffer)) > 0) {
                ((OutputStream)resStreamOut).write(buffer, 0, readBytes);
            }
        }
        finally {
            resStreamIn.close();
            ((OutputStream)resStreamOut).close();
        }
    }
}

