/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.software;

import com.compomics.software.cli.CommandLineUtils;
import com.compomics.software.dialogs.PeptideShakerSetupDialog;
import com.compomics.software.dialogs.ReporterSetupDialog;
import com.compomics.software.dialogs.SearchGuiSetupDialog;
import com.compomics.util.parameters.UtilitiesUserParameters;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class ToolFactory {
    public static final String PEPTIDE_SHAKER_FILE_OPTION = "-psdb";
    public static final String PEPTIDE_SHAKER_URL_OPTION = "-zipUrl";
    public static final String PEPTIDE_SHAKER_URL_DOWNLOAD_FOLDER_OPTION = "-zipUrlFolder";
    public static final String PEPTIDE_SHAKER_PX_ACCESSION_OPTION = "-pxAccession";
    public static final String PEPTIDE_SHAKER_PX_ACCESSION_PRIVATE_OPTION = "-pxAccessionPrivate";
    public static final String SEARCHGUI_SPECTRUM_FILE_OPTION = "-mgf";
    public static final String SEARCHGUI_FASTA_FILE_OPTION = "-fasta";
    public static final String SEARCHGUI_RAW_FILE_OPTION = "-raw";
    public static final String SEARCHGUI_PARAMETERS_FILE_OPTION = "-identification_parameters";
    public static final String OUTPUT_FOLDER_OPTION = "-output_folder";
    public static final String SPECIES_OPTION = "-species";
    public static final String SPECIES_TYPE_OPTION = "-species_type";
    public static final String PROJECT_NAME_OPTION = "-project_name";
    public static final String CONFIG_FOLDER = "-config_folder";

    public static void startPeptideShaker(JFrame parent) throws IOException, ClassNotFoundException, InterruptedException {
        ToolFactory.startPeptideShaker(parent, null);
    }

    public static void startPeptideShaker(JFrame parent, File psdbFile) throws IOException, ClassNotFoundException, InterruptedException {
        UtilitiesUserParameters utilitiesUserPreferences = UtilitiesUserParameters.loadUserParameters();
        boolean openPeptideShaker = true;
        if (utilitiesUserPreferences.getPeptideShakerPath() == null || !new File(utilitiesUserPreferences.getPeptideShakerPath()).exists()) {
            PeptideShakerSetupDialog peptideShakerSetupDialog = new PeptideShakerSetupDialog(parent, true);
            utilitiesUserPreferences = UtilitiesUserParameters.loadUserParameters();
            boolean bl = openPeptideShaker = !peptideShakerSetupDialog.isDialogCanceled();
        }
        if (openPeptideShaker) {
            if (utilitiesUserPreferences.getPeptideShakerPath() != null && new File(utilitiesUserPreferences.getPeptideShakerPath()).exists()) {
                if (psdbFile != null) {
                    ArrayList<String> args = new ArrayList<String>();
                    args.add(PEPTIDE_SHAKER_FILE_OPTION);
                    args.add(CommandLineUtils.getCommandLineArgument(psdbFile));
                    ToolFactory.launch(utilitiesUserPreferences.getPeptideShakerPath(), "PeptideShaker", args);
                } else {
                    ToolFactory.launch(utilitiesUserPreferences.getPeptideShakerPath(), "PeptideShaker");
                }
            } else {
                throw new IllegalArgumentException("PeptideShaker not found in " + utilitiesUserPreferences.getPeptideShakerPath());
            }
        }
    }

    public static void startReshake(JFrame parent, String pxAccession) throws IOException, ClassNotFoundException, InterruptedException {
        UtilitiesUserParameters utilitiesUserPreferences = UtilitiesUserParameters.loadUserParameters();
        boolean openPeptideShaker = true;
        if (utilitiesUserPreferences.getPeptideShakerPath() == null || !new File(utilitiesUserPreferences.getPeptideShakerPath()).exists()) {
            PeptideShakerSetupDialog peptideShakerSetupDialog = new PeptideShakerSetupDialog(parent, true);
            utilitiesUserPreferences = UtilitiesUserParameters.loadUserParameters();
            boolean bl = openPeptideShaker = !peptideShakerSetupDialog.isDialogCanceled();
        }
        if (openPeptideShaker) {
            if (utilitiesUserPreferences.getPeptideShakerPath() != null && new File(utilitiesUserPreferences.getPeptideShakerPath()).exists()) {
                if (pxAccession != null) {
                    ArrayList<String> args = new ArrayList<String>();
                    args.add(PEPTIDE_SHAKER_PX_ACCESSION_OPTION);
                    args.add(pxAccession);
                    ToolFactory.launch(utilitiesUserPreferences.getPeptideShakerPath(), "PeptideShaker", args);
                } else {
                    ToolFactory.launch(utilitiesUserPreferences.getPeptideShakerPath(), "PeptideShaker");
                }
            } else {
                throw new IllegalArgumentException("PeptideShaker not found in " + utilitiesUserPreferences.getPeptideShakerPath());
            }
        }
    }

    public static void startPeptideShakerFromURL(JFrame parent, String zipUrl, String downloadUrlFolder) throws IOException, ClassNotFoundException, InterruptedException {
        UtilitiesUserParameters utilitiesUserPreferences = UtilitiesUserParameters.loadUserParameters();
        boolean openPeptideShaker = true;
        if (utilitiesUserPreferences.getPeptideShakerPath() == null || !new File(utilitiesUserPreferences.getPeptideShakerPath()).exists()) {
            PeptideShakerSetupDialog peptideShakerSetupDialog = new PeptideShakerSetupDialog(parent, true);
            utilitiesUserPreferences = UtilitiesUserParameters.loadUserParameters();
            boolean bl = openPeptideShaker = !peptideShakerSetupDialog.isDialogCanceled();
        }
        if (openPeptideShaker) {
            if (utilitiesUserPreferences.getPeptideShakerPath() != null && new File(utilitiesUserPreferences.getPeptideShakerPath()).exists()) {
                if (zipUrl != null) {
                    ArrayList<String> args = new ArrayList<String>();
                    args.add(PEPTIDE_SHAKER_URL_OPTION);
                    args.add(CommandLineUtils.getQuoteType() + zipUrl + CommandLineUtils.getQuoteType());
                    args.add(PEPTIDE_SHAKER_URL_DOWNLOAD_FOLDER_OPTION);
                    args.add(CommandLineUtils.getQuoteType() + downloadUrlFolder + CommandLineUtils.getQuoteType());
                    ToolFactory.launch(utilitiesUserPreferences.getPeptideShakerPath(), "PeptideShaker", args);
                } else {
                    ToolFactory.launch(utilitiesUserPreferences.getPeptideShakerPath(), "PeptideShaker");
                }
            } else {
                throw new IllegalArgumentException("PeptideShaker not found in " + utilitiesUserPreferences.getPeptideShakerPath());
            }
        }
    }

    public static void startReporter(JFrame parent) throws IOException, ClassNotFoundException, InterruptedException {
        UtilitiesUserParameters utilitiesUserPreferences = UtilitiesUserParameters.loadUserParameters();
        boolean openReporter = true;
        if (utilitiesUserPreferences.getReporterPath() == null || !new File(utilitiesUserPreferences.getReporterPath()).exists()) {
            ReporterSetupDialog reporterSetupDialog = new ReporterSetupDialog(parent, true);
            utilitiesUserPreferences = UtilitiesUserParameters.loadUserParameters();
            boolean bl = openReporter = !reporterSetupDialog.isDialogCanceled();
        }
        if (openReporter) {
            if (utilitiesUserPreferences.getReporterPath() != null && new File(utilitiesUserPreferences.getReporterPath()).exists()) {
                ToolFactory.launch(utilitiesUserPreferences.getReporterPath(), "Reporter");
            } else {
                throw new IllegalArgumentException("Reporter not found in " + utilitiesUserPreferences.getReporterPath());
            }
        }
    }

    public static void startSearchGUI(JFrame parent) throws IOException, ClassNotFoundException, InterruptedException {
        ToolFactory.startSearchGUI(parent, null, null, null, null, null, null, null, null, null);
    }

    public static void startSearchGUI(JFrame parent, ArrayList<File> spectrumFiles, ArrayList<File> rawFiles, File fastaFile, File searchParameters, File outputFolder, File configFolder, String species, String speciesType, String projectName) throws IOException, ClassNotFoundException, InterruptedException {
        UtilitiesUserParameters utilitiesUserPreferences = UtilitiesUserParameters.loadUserParameters();
        boolean openSearchGUI = true;
        if (utilitiesUserPreferences.getSearchGuiPath() == null || !new File(utilitiesUserPreferences.getSearchGuiPath()).exists()) {
            SearchGuiSetupDialog searchGuiSetupDialog = new SearchGuiSetupDialog(parent, true);
            utilitiesUserPreferences = UtilitiesUserParameters.loadUserParameters();
            boolean bl = openSearchGUI = !searchGuiSetupDialog.isDialogCanceled();
        }
        if (openSearchGUI) {
            if (utilitiesUserPreferences.getSearchGuiPath() != null && new File(utilitiesUserPreferences.getSearchGuiPath()).exists()) {
                if (spectrumFiles == null && rawFiles == null && searchParameters == null && species == null) {
                    ToolFactory.launch(utilitiesUserPreferences.getSearchGuiPath(), "SearchGUI");
                } else {
                    ArrayList<String> args = new ArrayList<String>();
                    if (spectrumFiles != null && !spectrumFiles.isEmpty()) {
                        args.add(SEARCHGUI_SPECTRUM_FILE_OPTION);
                        args.add(CommandLineUtils.getCommandLineArgument(spectrumFiles));
                    }
                    if (rawFiles != null && !rawFiles.isEmpty()) {
                        args.add(SEARCHGUI_RAW_FILE_OPTION);
                        args.add(CommandLineUtils.getCommandLineArgument(rawFiles));
                    }
                    if (fastaFile != null) {
                        args.add(SEARCHGUI_FASTA_FILE_OPTION);
                        args.add(CommandLineUtils.getCommandLineArgument(fastaFile));
                    }
                    if (searchParameters != null) {
                        args.add(SEARCHGUI_PARAMETERS_FILE_OPTION);
                        args.add(CommandLineUtils.getCommandLineArgument(searchParameters));
                    }
                    if (outputFolder != null) {
                        args.add(OUTPUT_FOLDER_OPTION);
                        args.add(CommandLineUtils.getCommandLineArgument(outputFolder));
                    }
                    if (species != null) {
                        args.add(SPECIES_OPTION);
                        args.add(species);
                    }
                    if (speciesType != null) {
                        args.add(SPECIES_TYPE_OPTION);
                        args.add(speciesType);
                    }
                    if (projectName != null) {
                        args.add(PROJECT_NAME_OPTION);
                        args.add(projectName);
                    }
                    if (configFolder != null) {
                        args.add(CONFIG_FOLDER);
                        args.add(CommandLineUtils.getCommandLineArgument(configFolder));
                    }
                    ToolFactory.launch(utilitiesUserPreferences.getSearchGuiPath(), "SearchGUI", args);
                }
            } else {
                throw new IllegalArgumentException("SearchGUI not found in " + utilitiesUserPreferences.getSearchGuiPath());
            }
        }
    }

    private static void launch(String toolPath, String toolName) throws IOException, InterruptedException {
        ToolFactory.launch(toolPath, toolName, null);
    }

    private static void launch(String toolPath, String toolName, ArrayList<String> args) throws IOException, InterruptedException {
        String arguments = "";
        if (args != null) {
            arguments = CommandLineUtils.concatenate(args);
        }
        boolean debug = false;
        String quote = CommandLineUtils.getQuoteType();
        String cmdLine = "java -jar " + quote + toolPath + quote + " " + arguments;
        if (debug) {
            System.out.println(cmdLine);
        }
        Process p = Runtime.getRuntime().exec(cmdLine);
        InputStream stderr = p.getErrorStream();
        InputStreamReader isr = new InputStreamReader(stderr);
        BufferedReader br = new BufferedReader(isr);
        String temp = "<ERROR>" + System.getProperty("line.separator") + System.getProperty("line.separator");
        if (debug) {
            System.out.println("<ERROR>");
        }
        String line = br.readLine();
        boolean error = false;
        while (line != null) {
            if (debug) {
                System.out.println(line);
            }
            temp = temp + line + System.getProperty("line.separator");
            line = br.readLine();
            error = true;
        }
        br.close();
        isr.close();
        stderr.close();
        if (debug) {
            System.out.println("</ERROR>");
        }
        temp = temp + System.getProperty("line.separator") + "The command line executed:" + System.getProperty("line.separator");
        temp = temp + cmdLine + System.getProperty("line.separator");
        temp = temp + System.getProperty("line.separator") + "</ERROR>" + System.getProperty("line.separator");
        int exitVal = p.waitFor();
        if (debug) {
            System.out.println("Process exitValue: " + exitVal);
        }
        if (error) {
            File logFile = new File(new File(toolPath).getParentFile().getAbsolutePath() + "/resources/", toolName + ".log");
            FileWriter f = new FileWriter(logFile, true);
            f.write(System.getProperty("line.separator") + System.getProperty("line.separator") + temp + System.getProperty("line.separator") + System.getProperty("line.separator"));
            f.close();
            JOptionPane.showMessageDialog(null, "Failed to start " + toolName + ".\n\nInspect the log file for details: resources/" + toolName + ".log.\n\nThen go to Troubleshooting at https://compomics.github.io/projects/peptide-shaker.html.", toolName + " - Startup Failed", 0);
        }
    }
}

