/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.software.log;

import com.compomics.util.Util;
import com.compomics.util.io.flat.SimpleFileWriter;
import java.io.File;
import java.time.Instant;

public class CliLogger
implements AutoCloseable {
    private final SimpleFileWriter logWriter;

    public CliLogger(File logFile) {
        this(logFile, null, null);
    }

    public CliLogger(File logFile, String cliName, String version) {
        this.logWriter = new SimpleFileWriter(logFile, false);
        if (cliName != null) {
            this.logWriter.writeLine("# " + cliName + " version: " + version);
        }
        this.logWriter.writeLine("time", "type", "log");
    }

    public void writeComment(String key, String value) {
        String line = String.join((CharSequence)"", "# ", key, ": ", value);
        this.logWriter.writeLine(line);
    }

    public void writeHeaders() {
        this.logWriter.writeLine("time", "type", "log");
    }

    public void logMessage(String message) {
        String now = Instant.now().toString();
        this.logWriter.writeLine(now, "Message", "\"" + message.replace(Util.LINE_SEPARATOR, " ") + "\"");
        System.out.println(now + " - " + message);
    }

    public void logError(String message) {
        String now = Instant.now().toString();
        this.logWriter.writeLine(now, "Error", "\"" + message.replace(Util.LINE_SEPARATOR, " ") + "\"");
    }

    @Override
    public void close() {
        this.logWriter.close();
    }
}

