/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.software.settings;

import com.compomics.software.settings.PathKey;
import com.compomics.util.experiment.biology.enzymes.EnzymeFactory;
import com.compomics.util.experiment.biology.genes.ProteinGeneDetailsProvider;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.identification.identification_parameters.IdentificationParametersFactory;
import com.compomics.util.parameters.UtilitiesUserParameters;
import com.compomics.util.pride.PrideObjectsFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public class UtilitiesPathParameters {
    public static final String configurationFileName = "resources/conf/paths.txt";
    public static final String separator = "=";
    public static final String defaultPath = "default";

    public static void loadPathParametersFromFile(File inputFile) throws FileNotFoundException, IOException {
        try (BufferedReader br = new BufferedReader(new FileReader(inputFile));){
            String line;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).equals("") || line.startsWith("#")) continue;
            }
        }
    }

    public static void loadPathParameterFromLine(String line) throws FileNotFoundException {
        String id = UtilitiesPathParameters.getPathID(line);
        if (id.equals("")) {
            throw new IllegalArgumentException("Impossible to parse path in " + line + ".");
        }
        UtilitiesPathKey utilitiesPathKey = UtilitiesPathKey.getKeyFromId(id);
        if (utilitiesPathKey == null) {
            throw new IllegalArgumentException("Path " + id + " not recognized");
        }
        String path = UtilitiesPathParameters.getPath(line);
        if (!path.equals(defaultPath)) {
            File file = new File(path);
            if (!file.exists()) {
                throw new FileNotFoundException("File " + path + " not found.");
            }
            if (utilitiesPathKey.isDirectory && !file.isDirectory()) {
                throw new FileNotFoundException("Found a file when expecting a directory for " + utilitiesPathKey.id + ".");
            }
            UtilitiesPathParameters.setPathParameter(utilitiesPathKey, path);
        }
    }

    public static void setPathParameter(UtilitiesPathKey utilitiesPathKey, String path) {
        switch (utilitiesPathKey.ordinal()) {
            case 3: {
                ProteinGeneDetailsProvider.setGeneMappingFolder(path);
                return;
            }
            case 4: {
                PrideObjectsFactory.setPrideFolder(path);
                return;
            }
            case 1: {
                ModificationFactory.setSerializationFolder(path);
                return;
            }
            case 2: {
                EnzymeFactory.setSerializationFolder(path);
                return;
            }
            case 0: {
                UtilitiesUserParameters.setUserParametersFolder(path);
                return;
            }
            case 5: {
                IdentificationParametersFactory.setParentFolder(new File(path).getParent());
                return;
            }
        }
        throw new UnsupportedOperationException("Path " + utilitiesPathKey.id + " not implemented.");
    }

    public static String getPathParameter(UtilitiesPathKey utilitiesPathKey) {
        switch (utilitiesPathKey.ordinal()) {
            case 3: {
                return ProteinGeneDetailsProvider.getGeneMappingFolder().getAbsolutePath();
            }
            case 4: {
                return PrideObjectsFactory.getPrideFolder();
            }
            case 1: {
                return ModificationFactory.getSerializationFolder();
            }
            case 2: {
                return EnzymeFactory.getSerializationFolder();
            }
            case 0: {
                return UtilitiesUserParameters.getUserParametersFolder();
            }
            case 5: {
                return IdentificationParametersFactory.getParentFolder();
            }
        }
        throw new UnsupportedOperationException("Path " + utilitiesPathKey.id + " not implemented.");
    }

    public static String getPathID(String line) {
        int separatorIndex = line.indexOf(separator);
        if (separatorIndex > 0) {
            return line.substring(0, separatorIndex);
        }
        return "";
    }

    public static String getPath(String line) {
        int separatorIndex = line.indexOf(separator);
        if (separatorIndex > 0 && separatorIndex < line.length()) {
            return line.substring(separatorIndex + 1);
        }
        return "";
    }

    public static void setAllPathsIn(String path) throws FileNotFoundException {
        for (UtilitiesPathKey utilitiesPathKey : UtilitiesPathKey.values()) {
            String subDirectory = utilitiesPathKey.defaultSubDirectory;
            File newFile = new File(path, subDirectory);
            if (!newFile.exists()) {
                newFile.mkdirs();
            }
            if (!newFile.exists()) {
                throw new FileNotFoundException(newFile.getAbsolutePath() + " could not be created.");
            }
            UtilitiesPathParameters.setPathParameter(utilitiesPathKey, newFile.getAbsolutePath());
        }
    }

    public static void writeConfigurationToFile(File file) throws IOException {
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(file));){
            UtilitiesPathParameters.writeConfigurationToFile(bw);
        }
    }

    public static void writeConfigurationToFile(BufferedWriter bw) throws IOException {
        for (UtilitiesPathKey pathKey : UtilitiesPathKey.values()) {
            UtilitiesPathParameters.writePathToFile(bw, pathKey);
        }
    }

    public static void writePathToFile(BufferedWriter bw, UtilitiesPathKey pathKey) throws IOException {
        bw.write(pathKey.id + separator);
        switch (pathKey.ordinal()) {
            case 3: {
                String toWrite = ProteinGeneDetailsProvider.getGeneMappingFolder().getAbsolutePath();
                if (toWrite == null) {
                    toWrite = defaultPath;
                }
                bw.write(toWrite);
                break;
            }
            case 4: {
                String toWrite = PrideObjectsFactory.getPrideFolder();
                if (toWrite == null) {
                    toWrite = defaultPath;
                }
                bw.write(toWrite);
                break;
            }
            case 1: {
                String toWrite = ModificationFactory.getSerializationFolder();
                if (toWrite == null) {
                    toWrite = defaultPath;
                }
                bw.write(toWrite);
                break;
            }
            case 2: {
                String toWrite = EnzymeFactory.getSerializationFolder();
                if (toWrite == null) {
                    toWrite = defaultPath;
                }
                bw.write(toWrite);
                break;
            }
            case 0: {
                String toWrite = UtilitiesUserParameters.getUserParametersFolder();
                if (toWrite == null) {
                    toWrite = defaultPath;
                }
                bw.write(toWrite);
                break;
            }
            case 5: {
                String toWrite = IdentificationParametersFactory.getParentFolder();
                if (toWrite == null) {
                    toWrite = "identification_parameters_4";
                }
                bw.write(toWrite);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Path " + pathKey.id + " not implemented.");
            }
        }
        bw.newLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean testPath(String destinationPath) {
        try {
            File destinationFile = new File(destinationPath);
            if (!destinationFile.exists()) {
                try {
                    if (!destinationFile.mkdirs()) {
                        return false;
                    }
                }
                catch (Exception e) {
                    return false;
                }
            }
            File testFile = new File(destinationPath, "test_path_configuration.tmp");
            BufferedWriter bw = new BufferedWriter(new FileWriter(testFile));
            try {
                bw.write("test");
            }
            finally {
                try {
                    bw.close();
                }
                finally {
                    if (testFile.exists()) {
                        testFile.delete();
                    }
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static ArrayList<PathKey> getErrorKeys() throws IOException {
        ArrayList<PathKey> result = new ArrayList<PathKey>();
        for (UtilitiesPathKey utilitiesPathKey : UtilitiesPathKey.values()) {
            String folder = UtilitiesPathParameters.getPathParameter(utilitiesPathKey);
            if (folder == null || UtilitiesPathParameters.testPath(folder)) continue;
            result.add(utilitiesPathKey);
        }
        return result;
    }

    public static enum UtilitiesPathKey implements PathKey
    {
        utilitiesPreferencesKey("utilities_user_preferences", "Folder containing the compomics utilities user preferences file.", "", true),
        ptmFactoryKey("ptm_configuration", "Folder containing the supported PTMs.", "", true),
        enzymeFactoryKey("enzyme_configuration", "File containing the supported enzymes.", "", true),
        geneMappingKey("gene_mapping", "Folder containing the gene mapping files.", "gene_mapping", true),
        prideAnnotationKey("pride_annotation", "Folder containing the PRIDE annotation preferences.", "pride", true),
        identificationParametersKey("identification_parameters", "Folder containing the identification parameters.", "identification_parameters_4", true);

        private final String id;
        private final String description;
        private final String defaultSubDirectory;
        private final boolean isDirectory;

        private UtilitiesPathKey(String id, String description, String defaultSubDirectory, boolean isDirectory) {
            this.id = id;
            this.description = description;
            this.defaultSubDirectory = defaultSubDirectory;
            this.isDirectory = isDirectory;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public static UtilitiesPathKey getKeyFromId(String id) {
            for (UtilitiesPathKey pathKey : UtilitiesPathKey.values()) {
                if (!pathKey.id.equals(id)) continue;
                return pathKey;
            }
            return null;
        }
    }
}

