/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.exceptions;

import java.util.HashSet;

public abstract class ExceptionHandler {
    protected HashSet<String> exceptionCaught = new HashSet();
    protected boolean ignoreExceptions = false;

    public synchronized void catchException(Exception e) {
        if (!this.ignoreExceptions && !this.exceptionCaught.contains(ExceptionHandler.getExceptionType(e))) {
            e.printStackTrace();
            this.exceptionCaught.add(ExceptionHandler.getExceptionType(e));
            this.notifyUser(e);
        }
    }

    protected abstract void notifyUser(Exception var1);

    public static String getExceptionType(Exception e) {
        if (e.getLocalizedMessage() == null) {
            return "null pointer";
        }
        if (e.getLocalizedMessage().startsWith("Protein not found")) {
            return "Protein not found";
        }
        if (e.getLocalizedMessage().startsWith("Error while loading") || e.getLocalizedMessage().startsWith("Error while writing")) {
            return "Serialization";
        }
        if (e.getLocalizedMessage().startsWith("Two modifications found")) {
            return "Two modifications on same site";
        }
        return e.getLocalizedMessage();
    }

    public void setIgnoreExceptions(boolean ignoreExceptions) {
        this.ignoreExceptions = ignoreExceptions;
    }
}

