/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology.aminoacids.impl;

import com.compomics.util.experiment.biology.aminoacids.AminoAcid;
import com.compomics.util.experiment.biology.atoms.Atom;
import com.compomics.util.experiment.biology.atoms.AtomChain;
import com.compomics.util.experiment.biology.atoms.AtomImpl;

public class AsparticAcid
extends AminoAcid {
    static final long serialVersionUID = -8410332876209882538L;

    public AsparticAcid() {
        this.singleLetterCode = "D";
        this.threeLetterCode = "Asp";
        this.name = "Aspartic Acid";
        this.monoisotopicAtomChain = new AtomChain();
        this.monoisotopicAtomChain.append(new AtomImpl(Atom.C, (Integer)0), 4);
        this.monoisotopicAtomChain.append(new AtomImpl(Atom.H, (Integer)0), 5);
        this.monoisotopicAtomChain.append(new AtomImpl(Atom.N, (Integer)0), 1);
        this.monoisotopicAtomChain.append(new AtomImpl(Atom.O, (Integer)0), 3);
        this.subAminoAcidsWithoutCombination = new char[]{'D'};
        this.subAminoAcidsWithCombination = this.subAminoAcidsWithoutCombination;
        this.aminoAcidCombinations = new char[]{'B', 'X'};
        this.standardGeneticCode = new String[]{"GAT", "GAC"};
    }

    @Override
    public boolean iscombination() {
        return false;
    }

    @Override
    public double getHydrophobicity() {
        return -2.49;
    }

    @Override
    public double getHelicity() {
        return 0.89;
    }

    @Override
    public double getBasicity() {
        return 208.6;
    }

    @Override
    public double getPI() {
        return 2.85;
    }

    @Override
    public double getPK1() {
        return 1.99;
    }

    @Override
    public double getPK2() {
        return 9.9;
    }

    @Override
    public double getPKa() {
        return 3.67;
    }

    @Override
    public int getVanDerWaalsVolume() {
        return 91;
    }
}

