/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology.aminoacids.sequence;

import com.compomics.util.experiment.biology.aminoacids.AminoAcid;
import com.compomics.util.experiment.biology.aminoacids.sequence.AminoAcidPattern;
import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.identification.amino_acid_tags.TagComponent;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.utils.ModificationUtils;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class AminoAcidSequence
extends ExperimentObject
implements TagComponent {
    private String sequence;
    private StringBuilder sequenceStringBuilder = null;
    private ModificationMatch[] variableModifications = null;
    private static final ModificationMatch[] noMod = new ModificationMatch[0];

    public AminoAcidSequence() {
    }

    public AminoAcidSequence(String sequence) {
        this.sequence = sequence;
    }

    public AminoAcidSequence(String sequence, ModificationMatch[] variableModifications) {
        this.sequence = sequence;
        this.variableModifications = variableModifications;
    }

    public AminoAcidSequence(AminoAcidSequence sequence) {
        this.sequence = sequence.getSequence();
        ModificationMatch[] modificationMatches = sequence.getVariableModifications();
        if (modificationMatches.length > 0) {
            this.variableModifications = (ModificationMatch[])Arrays.stream(modificationMatches).map(ModificationMatch::clone).toArray(ModificationMatch[]::new);
        }
    }

    public String getSequence() {
        this.setSequenceStringBuilder(false);
        return this.sequence == null ? "" : this.sequence;
    }

    public char charAt(int aa) {
        this.setSequenceStringBuilder(false);
        return this.sequence.charAt(aa);
    }

    public AminoAcid getAminoAcidAt(int aa) {
        return AminoAcid.getAminoAcid(this.charAt(aa));
    }

    public void setSequence(String aminoAcidSequence) {
        this.sequenceStringBuilder = null;
        this.sequence = aminoAcidSequence;
    }

    public void setAaAtIndex(int index, char aa) {
        this.setSequenceStringBuilder(true);
        this.sequenceStringBuilder.setCharAt(index, aa);
    }

    private void setSequenceStringBuilder(boolean stringbuilder) {
        if (stringbuilder && this.sequenceStringBuilder == null) {
            if (this.sequence != null) {
                this.sequenceStringBuilder = new StringBuilder(this.sequence);
                this.sequence = null;
            } else {
                this.sequenceStringBuilder = new StringBuilder(1);
            }
        } else if (this.sequence == null && this.sequenceStringBuilder != null) {
            this.sequence = this.sequenceStringBuilder.toString();
        }
    }

    public void emptyInternalCaches() {
        this.sequenceStringBuilder = null;
    }

    public boolean matchesIn(String aminoAcidSequence, SequenceMatchingParameters sequenceMatchingPreferences) {
        return this.firstIndex(aminoAcidSequence, sequenceMatchingPreferences) >= 0;
    }

    public boolean matchesIn(AminoAcidSequence aminoAcidSequence, SequenceMatchingParameters sequenceMatchingPreferences) {
        return this.matchesIn(aminoAcidSequence.getSequence(), sequenceMatchingPreferences);
    }

    public boolean matches(String aminoAcidSequence, SequenceMatchingParameters sequenceMatchingPreferences) {
        return this.length() == aminoAcidSequence.length() && this.firstIndex(aminoAcidSequence, sequenceMatchingPreferences) >= 0;
    }

    public boolean matches(AminoAcidSequence aminoAcidSequence, SequenceMatchingParameters sequenceMatchingPreferences) {
        return this.matches(aminoAcidSequence.getSequence(), sequenceMatchingPreferences);
    }

    public int firstIndex(String aminoAcidSequence, SequenceMatchingParameters sequenceMatchingPreferences) {
        return AminoAcidPattern.getAminoAcidPatternFromString(this.sequence).firstIndex(aminoAcidSequence, sequenceMatchingPreferences, 0);
    }

    public int length() {
        if (this.sequence != null) {
            return this.sequence.length();
        }
        if (this.sequenceStringBuilder != null) {
            return this.sequenceStringBuilder.length();
        }
        return 0;
    }

    public void appendCTerm(AminoAcidSequence otherSequence) {
        this.setSequenceStringBuilder(true);
        int previousLength = this.length();
        this.sequenceStringBuilder.append(otherSequence.getSequence());
        ModificationMatch[] otherModifications = otherSequence.getVariableModifications();
        if (otherModifications.length > 0) {
            otherModifications = (ModificationMatch[])Arrays.stream(otherModifications).map(ModificationMatch::clone).peek(modificationMatch -> modificationMatch.setSite(modificationMatch.getSite() + previousLength)).toArray(ModificationMatch[]::new);
            if (this.variableModifications == null) {
                this.variableModifications = otherModifications;
            } else {
                ModificationMatch[] mergedModifications = new ModificationMatch[this.variableModifications.length + otherModifications.length];
                System.arraycopy(this.variableModifications, 0, mergedModifications, 0, this.variableModifications.length);
                System.arraycopy(otherModifications, 0, mergedModifications, this.variableModifications.length, otherModifications.length);
                this.variableModifications = mergedModifications;
            }
        }
    }

    public void appendCTerm(String otherSequence) {
        this.setSequenceStringBuilder(true);
        this.sequenceStringBuilder.append(otherSequence);
    }

    public void insert(int offset, AminoAcidSequence otherSequence) {
        this.setSequenceStringBuilder(true);
        this.sequenceStringBuilder.insert(0, otherSequence.getSequence());
        int otherSequenceLength = otherSequence.length();
        ModificationMatch[] otherModifications = otherSequence.getVariableModifications();
        if (otherModifications.length > 0) {
            otherModifications = (ModificationMatch[])Arrays.stream(otherModifications).map(ModificationMatch::clone).peek(modificationMatch -> modificationMatch.setSite(modificationMatch.getSite() + offset)).toArray(ModificationMatch[]::new);
            if (this.variableModifications == null) {
                this.variableModifications = otherModifications;
            } else {
                for (ModificationMatch modificationMatch2 : this.variableModifications) {
                    int oldSite = modificationMatch2.getSite();
                    if (oldSite <= offset + 1) continue;
                    int newSite = oldSite + otherSequenceLength;
                    modificationMatch2.setSite(newSite);
                }
                this.variableModifications = Arrays.copyOf(this.variableModifications, this.variableModifications.length + otherModifications.length);
                System.arraycopy(otherModifications, 0, this.variableModifications, this.variableModifications.length, otherModifications.length);
            }
        }
    }

    public void insert(int offset, String otherSequence) {
        this.setSequenceStringBuilder(true);
        this.sequenceStringBuilder.insert(offset, otherSequence);
    }

    public void appendNTerm(AminoAcidSequence otherSequence) {
        this.insert(0, otherSequence);
    }

    public void appendNTerm(String otherSequence) {
        this.insert(0, otherSequence);
    }

    public ModificationMatch[] getVariableModifications() {
        return this.variableModifications == null ? noMod : this.variableModifications;
    }

    public String[] getIndexedVariableModifications() {
        String[] result = new String[this.length() + 2];
        if (this.variableModifications != null) {
            for (ModificationMatch modificationMatch : this.variableModifications) {
                String modName = modificationMatch.getModification();
                int site = modificationMatch.getSite();
                if (result[site] != null) {
                    throw new IllegalArgumentException("Two modifications (" + result[site] + " and " + modName + ") found on sequence " + this.getSequence() + " at site " + site + ".");
                }
                result[site] = modName;
            }
        }
        return result;
    }

    public void addVariableModification(ModificationMatch modificationMatch) {
        this.variableModifications = this.variableModifications == null ? new ModificationMatch[1] : Arrays.copyOf(this.variableModifications, this.variableModifications.length + 1);
        this.variableModifications[this.variableModifications.length - 1] = modificationMatch;
    }

    public void setVariableModifications(ModificationMatch[] variableModifications) {
        this.variableModifications = variableModifications;
    }

    public String[] getFixedModifications(boolean nTerm, boolean cTerm, ModificationParameters modificationParameters, SequenceMatchingParameters modificationsSequenceMatchingParameters) {
        ModificationFactory modificationFactory = ModificationFactory.getInstance();
        String[] result = new String[this.sequence.length() + 2];
        for (String modName : modificationParameters.getFixedModifications()) {
            int[] sites;
            Modification modification = modificationFactory.getModification(modName);
            for (int site : sites = ModificationUtils.getPossibleModificationSites(this, nTerm, cTerm, modification, modificationsSequenceMatchingParameters)) {
                if (result[site] != null) {
                    throw new IllegalArgumentException("Attempting to put two fixed modifications (" + result[site] + " and " + modification.getName() + " on amino acid " + site + " of peptide " + this.getSequence() + ".");
                }
                result[site] = modification.getName();
            }
        }
        return result;
    }

    public boolean isSameAs(AminoAcidSequence anotherSequence, SequenceMatchingParameters sequenceMatchingPreferences) {
        if (!this.isSameSequenceAndModificationStatusAs(anotherSequence, sequenceMatchingPreferences)) {
            return false;
        }
        ModificationFactory modificationFactory = ModificationFactory.getInstance();
        ModificationMatch[] modificationMatches1 = this.getVariableModifications();
        ModificationMatch[] modificationMatches2 = anotherSequence.getVariableModifications();
        Map<Double, HashSet> mods1 = Arrays.stream(modificationMatches1).collect(Collectors.groupingBy(modificationMatch -> modificationFactory.getModification(modificationMatch.getModification()).getMass(), Collectors.toCollection(HashSet::new)));
        Map<Double, HashSet> mods2 = Arrays.stream(modificationMatches2).collect(Collectors.groupingBy(modificationMatch -> modificationFactory.getModification(modificationMatch.getModification()).getMass(), Collectors.toCollection(HashSet::new)));
        for (Map.Entry<Double, HashSet> entry1 : mods1.entrySet()) {
            HashSet sites2;
            HashSet sites1 = entry1.getValue().stream().map(ModificationMatch::getSite).collect(Collectors.toCollection(HashSet::new));
            if (sites1.equals(sites2 = mods2.get(entry1.getKey()).stream().map(ModificationMatch::getSite).collect(Collectors.toCollection(HashSet::new)))) continue;
            return false;
        }
        return true;
    }

    public boolean isSameSequenceAndModificationStatusAs(AminoAcidSequence anotherSequence, SequenceMatchingParameters sequenceMatchingPreferences) {
        ModificationMatch[] modificationMatches2;
        if (!this.matches(anotherSequence, sequenceMatchingPreferences)) {
            return false;
        }
        ModificationMatch[] modificationMatches1 = this.getVariableModifications();
        if (modificationMatches1.length != (modificationMatches2 = anotherSequence.getVariableModifications()).length) {
            return false;
        }
        ModificationFactory modificationFactory = ModificationFactory.getInstance();
        Map<Double, Long> masses1 = Arrays.stream(modificationMatches1).collect(Collectors.groupingBy(modificationMatch -> modificationFactory.getModification(modificationMatch.getModification()).getMass(), Collectors.counting()));
        Map<Double, Long> masses2 = Arrays.stream(modificationMatches2).collect(Collectors.groupingBy(modificationMatch -> modificationFactory.getModification(modificationMatch.getModification()).getMass(), Collectors.counting()));
        if (masses1.size() != masses2.size()) {
            return false;
        }
        return !masses1.entrySet().stream().anyMatch(entry -> masses2.get(entry.getKey()) == null || !((Long)entry.getValue()).equals(masses2.get(entry.getKey())));
    }

    public AminoAcidSequence reverse() {
        this.setSequenceStringBuilder(false);
        AminoAcidSequence newSequence = new AminoAcidSequence(new StringBuilder(this.sequence).reverse().toString());
        ModificationMatch[] newModifications = (ModificationMatch[])Arrays.stream(this.variableModifications).map(ModificationMatch::clone).peek(modificationMatch -> modificationMatch.setSite(this.sequence.length() - modificationMatch.getSite())).toArray(ModificationMatch[]::new);
        newSequence.setVariableModifications(this.variableModifications);
        return newSequence;
    }

    public static boolean hasCombination(String sequence) {
        return AminoAcidSequence.hasCombination(sequence.chars());
    }

    public static boolean hasCombination(IntStream sequence) {
        return sequence.anyMatch(aa -> AminoAcid.getAminoAcid((char)aa).iscombination());
    }

    public static boolean hasCombination(char[] sequence) {
        for (int i = 0; i < sequence.length; ++i) {
            char aa = sequence[i];
            AminoAcid aminoAcid = AminoAcid.getAminoAcid(aa);
            if (!aminoAcid.iscombination()) continue;
            return true;
        }
        return false;
    }

    public static double getMinMass(char[] sequence) {
        double minMass = 0.0;
        for (char aa : sequence) {
            AminoAcid aminoAcid = AminoAcid.getAminoAcid(aa);
            if (aminoAcid.iscombination()) {
                char[] subAa = aminoAcid.getSubAminoAcids(false);
                aminoAcid = AminoAcid.getAminoAcid(subAa[0]);
                double minMassTemp = aminoAcid.getMonoisotopicMass();
                for (int i = 1; i < subAa.length; ++i) {
                    aminoAcid = AminoAcid.getAminoAcid(subAa[i]);
                    double massTemp = aminoAcid.getMonoisotopicMass();
                    if (!(massTemp < minMassTemp)) continue;
                    minMassTemp = massTemp;
                }
                minMass += minMassTemp;
                continue;
            }
            minMass += aminoAcid.getMonoisotopicMass();
        }
        return minMass;
    }

    public static ArrayList<StringBuilder> getCombinations(String sequence) {
        ArrayList<StringBuilder> combination = new ArrayList<StringBuilder>(1);
        for (int i = 0; i < sequence.length(); ++i) {
            ArrayList<StringBuilder> newCombination = new ArrayList<StringBuilder>(1);
            char aa = sequence.charAt(i);
            AminoAcid aminoAcid = AminoAcid.getAminoAcid(aa);
            for (char newAa : aminoAcid.getSubAminoAcids(false)) {
                if (combination.isEmpty()) {
                    StringBuilder stringBuilder = new StringBuilder(sequence.length());
                    stringBuilder.append(newAa);
                    newCombination.add(stringBuilder);
                    continue;
                }
                for (StringBuilder stringBuilder : combination) {
                    StringBuilder newStringBuilder = new StringBuilder(sequence.length());
                    newStringBuilder.append((CharSequence)stringBuilder);
                    newStringBuilder.append(newAa);
                    newCombination.add(newStringBuilder);
                }
            }
            combination = newCombination;
        }
        return combination;
    }

    public String toString() {
        this.setSequenceStringBuilder(false);
        return this.sequence;
    }

    @Override
    public String asSequence() {
        this.setSequenceStringBuilder(false);
        return this.sequence;
    }

    @Override
    public double getMass() {
        this.setSequenceStringBuilder(false);
        double mass = CharBuffer.wrap(this.sequence.toCharArray()).chars().mapToObj(aa -> AminoAcid.getAminoAcid((char)aa)).mapToDouble(AminoAcid::getMonoisotopicMass).sum();
        if (this.variableModifications != null) {
            ModificationFactory modificationFactory = ModificationFactory.getInstance();
            mass += Arrays.stream(this.variableModifications).mapToDouble(modificationMatch -> modificationFactory.getModification(modificationMatch.getModification()).getMass()).sum();
        }
        return mass;
    }

    @Override
    public boolean isSameAs(TagComponent anotherCompontent, SequenceMatchingParameters sequenceMatchingPreferences) {
        if (!(anotherCompontent instanceof AminoAcidSequence)) {
            return false;
        }
        AminoAcidSequence aminoAcidSequence = (AminoAcidSequence)anotherCompontent;
        return this.isSameAs(aminoAcidSequence, sequenceMatchingPreferences);
    }

    @Override
    public boolean isSameSequenceAndModificationStatusAs(TagComponent anotherCompontent, SequenceMatchingParameters sequenceMatchingPreferences) {
        if (!(anotherCompontent instanceof AminoAcidSequence)) {
            return false;
        }
        AminoAcidSequence aminoAcidSequence = (AminoAcidSequence)anotherCompontent;
        return this.isSameSequenceAndModificationStatusAs(aminoAcidSequence, sequenceMatchingPreferences);
    }
}

