/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology.enzymes;

import com.compomics.util.experiment.biology.enzymes.Enzyme;
import com.compomics.util.io.json.JsonMarshaller;
import com.compomics.util.pride.CvTerm;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class EnzymeFactory {
    private HashMap<String, Enzyme> enzymes = new HashMap();
    private static EnzymeFactory instance = null;
    private static ArrayList<String> sortedEnzymeNames = null;
    private static String SERIALIZATION_FILE_FOLDER = System.getProperty("user.home") + "/.compomics";
    private static final String SERIALIZATION_FILE_NAME = "enzymeFactory-5.0.0.json";

    private EnzymeFactory() {
    }

    public static EnzymeFactory getInstance() {
        if (instance == null) {
            try {
                File savedFile = new File(SERIALIZATION_FILE_FOLDER, SERIALIZATION_FILE_NAME);
                instance = EnzymeFactory.loadFromFile(savedFile);
                sortedEnzymeNames = null;
            }
            catch (Exception e) {
                EnzymeFactory.setDefaultEnzymes();
                sortedEnzymeNames = null;
            }
        }
        return instance;
    }

    public void saveFactory() throws IOException {
        File factoryFile = new File(SERIALIZATION_FILE_FOLDER, SERIALIZATION_FILE_NAME);
        if (!factoryFile.getParentFile().exists()) {
            factoryFile.getParentFile().mkdir();
        }
        EnzymeFactory.saveToFile(instance, factoryFile);
    }

    public static void setDefaultEnzymes() {
        instance = new EnzymeFactory();
        for (Enzyme enzyme : EnzymeFactory.getDefaultEnzymes()) {
            instance.addEnzyme(enzyme);
        }
        sortedEnzymeNames = null;
    }

    public static EnzymeFactory loadFromFile(File file) throws IOException {
        JsonMarshaller jsonMarshaller = new JsonMarshaller();
        EnzymeFactory result = (EnzymeFactory)jsonMarshaller.fromJson(EnzymeFactory.class, file);
        sortedEnzymeNames = null;
        return result;
    }

    public static void saveToFile(EnzymeFactory enzymeFactory, File file) throws IOException {
        JsonMarshaller jsonMarshaller = new JsonMarshaller();
        jsonMarshaller.saveObjectToJson(enzymeFactory, file);
    }

    public static String getSerializationFolder() {
        return SERIALIZATION_FILE_FOLDER;
    }

    public static void setSerializationFolder(String serializationFilePath) {
        SERIALIZATION_FILE_FOLDER = serializationFilePath;
    }

    public ArrayList<Enzyme> getEnzymes() {
        return new ArrayList<Enzyme>(this.enzymes.values());
    }

    public ArrayList<String> getSortedEnzymeNames() {
        if (sortedEnzymeNames != null) {
            return sortedEnzymeNames;
        }
        sortedEnzymeNames = new ArrayList();
        for (Enzyme tempEnzyme : this.enzymes.values()) {
            sortedEnzymeNames.add(tempEnzyme.getName());
        }
        Collections.sort(sortedEnzymeNames);
        return sortedEnzymeNames;
    }

    public Enzyme getEnzyme(String enzymeName) {
        return this.enzymes.get(enzymeName);
    }

    public void addEnzyme(Enzyme enzyme) {
        this.enzymes.put(enzyme.getName(), enzyme);
        sortedEnzymeNames = null;
    }

    public void removeEnzyme(String enzymeName) {
        this.enzymes.remove(enzymeName);
        sortedEnzymeNames = null;
    }

    public boolean enzymeLoaded(String enzyme) {
        return this.enzymes.containsKey(enzyme);
    }

    public Enzyme getUtilitiesEnzyme(String cvTermAccession) {
        for (Enzyme enzyme : this.enzymes.values()) {
            if (enzyme.getCvTerm() == null || !enzyme.getCvTerm().getAccession().equals(cvTermAccession)) continue;
            return enzyme;
        }
        return null;
    }

    private static ArrayList<Enzyme> getDefaultEnzymes() {
        ArrayList<Enzyme> enzymes = new ArrayList<Enzyme>();
        Enzyme enzyme = new Enzyme("Trypsin");
        enzyme.addAminoAcidBefore(Character.valueOf('R'));
        enzyme.addAminoAcidBefore(Character.valueOf('K'));
        enzyme.addRestrictionAfter(Character.valueOf('P'));
        enzyme.setCvTerm(new CvTerm("PSI-MS", "MS:1001251", "Trypsin", null));
        enzymes.add(enzyme);
        enzyme = new Enzyme("Trypsin (no P rule)");
        enzyme.addAminoAcidBefore(Character.valueOf('R'));
        enzyme.addAminoAcidBefore(Character.valueOf('K'));
        enzyme.setCvTerm(new CvTerm("PSI-MS", "MS:1001313", "Trypsin/P", null));
        enzymes.add(enzyme);
        enzyme = new Enzyme("Arg-C");
        enzyme.addAminoAcidBefore(Character.valueOf('R'));
        enzyme.addRestrictionAfter(Character.valueOf('P'));
        enzyme.setCvTerm(new CvTerm("PSI-MS", "MS:1001303", "Arg-C", null));
        enzymes.add(enzyme);
        enzyme = new Enzyme("Arg-C (no P rule)");
        enzyme.addAminoAcidBefore(Character.valueOf('R'));
        enzymes.add(enzyme);
        enzyme = new Enzyme("Arg-N");
        enzyme.addAminoAcidAfter(Character.valueOf('R'));
        enzymes.add(enzyme);
        enzyme = new Enzyme("Glu-C");
        enzyme.addAminoAcidBefore(Character.valueOf('E'));
        enzyme.setCvTerm(new CvTerm("PSI-MS", "MS:1001917", "glutamyl endopeptidase", null));
        enzymes.add(enzyme);
        enzyme = new Enzyme("Lys-C");
        enzyme.addAminoAcidBefore(Character.valueOf('K'));
        enzyme.addRestrictionAfter(Character.valueOf('P'));
        enzyme.setCvTerm(new CvTerm("PSI-MS", "MS:1001309", "Lys-C", null));
        enzymes.add(enzyme);
        enzyme = new Enzyme("Lys-C (no P rule)");
        enzyme.addAminoAcidBefore(Character.valueOf('K'));
        enzyme.setCvTerm(new CvTerm("PSI-MS", "MS:1001310", "Lys-C/P", null));
        enzymes.add(enzyme);
        enzyme = new Enzyme("Lys-N");
        enzyme.addAminoAcidAfter(Character.valueOf('K'));
        enzymes.add(enzyme);
        enzyme = new Enzyme("Asp-N");
        enzyme.addAminoAcidAfter(Character.valueOf('D'));
        enzyme.setCvTerm(new CvTerm("PSI-MS", "MS:1001304", "Asp-N", null));
        enzymes.add(enzyme);
        enzyme = new Enzyme("Asp-N (ambic)");
        enzyme.addAminoAcidAfter(Character.valueOf('D'));
        enzyme.addAminoAcidAfter(Character.valueOf('E'));
        enzyme.setCvTerm(new CvTerm("PSI-MS", "MS:1001305", "Asp-N_ambic", null));
        enzymes.add(enzyme);
        enzyme = new Enzyme("Chymotrypsin");
        enzyme.addAminoAcidBefore(Character.valueOf('F'));
        enzyme.addAminoAcidBefore(Character.valueOf('Y'));
        enzyme.addAminoAcidBefore(Character.valueOf('W'));
        enzyme.addAminoAcidBefore(Character.valueOf('L'));
        enzyme.addRestrictionAfter(Character.valueOf('P'));
        enzyme.setCvTerm(new CvTerm("PSI-MS", "MS:1001306", "Chymotrypsin", null));
        enzymes.add(enzyme);
        enzyme = new Enzyme("Chymotrypsin (no P rule)");
        enzyme.addAminoAcidBefore(Character.valueOf('F'));
        enzyme.addAminoAcidBefore(Character.valueOf('Y'));
        enzyme.addAminoAcidBefore(Character.valueOf('W'));
        enzyme.addAminoAcidBefore(Character.valueOf('L'));
        enzymes.add(enzyme);
        enzyme = new Enzyme("Pepsin A");
        enzyme.addAminoAcidBefore(Character.valueOf('F'));
        enzyme.addAminoAcidBefore(Character.valueOf('L'));
        enzyme.setCvTerm(new CvTerm("PSI-MS", "MS:1001311", "Pepsin A", null));
        enzymes.add(enzyme);
        enzyme = new Enzyme("CNBr");
        enzyme.addAminoAcidBefore(Character.valueOf('M'));
        enzyme.setCvTerm(new CvTerm("PSI-MS", "MS:1001307", "CNBr", null));
        enzymes.add(enzyme);
        enzyme = new Enzyme("Thermolysin");
        enzyme.addAminoAcidAfter(Character.valueOf('A'));
        enzyme.addAminoAcidAfter(Character.valueOf('F'));
        enzyme.addAminoAcidAfter(Character.valueOf('I'));
        enzyme.addAminoAcidAfter(Character.valueOf('L'));
        enzyme.addAminoAcidAfter(Character.valueOf('M'));
        enzyme.addAminoAcidAfter(Character.valueOf('V'));
        enzymes.add(enzyme);
        enzyme = new Enzyme("LysargiNase");
        enzyme.addAminoAcidAfter(Character.valueOf('R'));
        enzyme.addAminoAcidAfter(Character.valueOf('K'));
        enzymes.add(enzyme);
        return enzymes;
    }
}

