/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology.ions;

import com.compomics.util.experiment.biology.aminoacids.AminoAcid;
import com.compomics.util.experiment.biology.atoms.AtomChain;
import com.compomics.util.experiment.biology.ions.NeutralLoss;
import com.compomics.util.experiment.biology.ions.impl.ElementaryIon;
import com.compomics.util.experiment.biology.ions.impl.Glycan;
import com.compomics.util.experiment.biology.ions.impl.ImmoniumIon;
import com.compomics.util.experiment.biology.ions.impl.PeptideFragmentIon;
import com.compomics.util.experiment.biology.ions.impl.PrecursorIon;
import com.compomics.util.experiment.biology.ions.impl.RelatedIon;
import com.compomics.util.experiment.biology.ions.impl.ReporterIon;
import com.compomics.util.experiment.biology.ions.impl.TagFragmentIon;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.pride.CvTerm;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.stream.Collectors;

public abstract class Ion
extends ExperimentObject {
    static final long serialVersionUID = -1505719074403886934L;
    private String neutralLossesAsString = null;
    protected IonType type = IonType.UNKNOWN;
    protected double theoreticMass1;
    protected AtomChain atomChain;

    public abstract String getName();

    public abstract CvTerm getPrideCvTerm();

    public abstract CvTerm getPsiMsCvTerm();

    public abstract int getSubType();

    public abstract String getSubTypeAsString();

    public static int[] getPossibleSubtypes(IonType ionType) {
        switch (ionType.ordinal()) {
            case 6: {
                return ElementaryIon.getPossibleSubtypes();
            }
            case 5: {
                return Glycan.getPossibleSubtypes();
            }
            case 3: {
                return ImmoniumIon.getPossibleSubtypes();
            }
            case 0: {
                return PeptideFragmentIon.getPossibleSubtypes();
            }
            case 1: {
                return TagFragmentIon.getPossibleSubtypes();
            }
            case 2: {
                return PrecursorIon.getPossibleSubtypes();
            }
            case 4: {
                return ReporterIon.getPossibleSubtypes();
            }
            case 8: {
                return RelatedIon.getPossibleSubtypes();
            }
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static HashSet<Integer> getPossibleSubtypesAsSet(IonType ionType) {
        int[] possibleSubtypes = Ion.getPossibleSubtypes(ionType);
        return Arrays.stream(possibleSubtypes).boxed().collect(Collectors.toCollection(HashSet::new));
    }

    public abstract NeutralLoss[] getNeutralLosses();

    public boolean hasNeutralLosses() {
        switch (this.type.ordinal()) {
            case 0: 
            case 1: 
            case 2: {
                NeutralLoss[] neutralLosses = this.getNeutralLosses();
                return neutralLosses != null && neutralLosses.length > 0;
            }
        }
        return false;
    }

    public abstract boolean isSameAs(Ion var1);

    public String getNeutralLossesAsString() {
        if (this.neutralLossesAsString == null) {
            this.neutralLossesAsString = Ion.getNeutralLossesAsString(this.getNeutralLosses());
        }
        return this.neutralLossesAsString;
    }

    public static String getNeutralLossesAsString(NeutralLoss[] neutralLosses) {
        if (neutralLosses == null || neutralLosses.length == 0) {
            return "";
        }
        return Arrays.stream(neutralLosses).map(neutralLoss -> neutralLoss.name).sorted().collect(Collectors.joining("-", "-", ""));
    }

    public double getTheoreticMass() {
        if (this.atomChain != null) {
            return this.atomChain.getMass();
        }
        return this.theoreticMass1;
    }

    public double getTheoreticMz(Integer charge) {
        double protonMass = ElementaryIon.proton.getTheoreticMass();
        double mz = this.getTheoreticMass() + protonMass;
        if (charge > 1) {
            mz = (mz + (double)(charge - 1) * protonMass) / (double)charge.intValue();
        }
        return mz;
    }

    public AtomChain getAtomicComposition() {
        return this.atomChain;
    }

    public void setAtomicComposition(AtomChain atomChain) {
        this.atomChain = atomChain;
    }

    public void setTheoreticMass(double theoreticMass) {
        this.theoreticMass1 = theoreticMass;
    }

    public IonType getType() {
        return this.type;
    }

    public static ArrayList<IonType> getImplementedIonTypes() {
        ArrayList<IonType> result = new ArrayList<IonType>();
        result.add(IonType.ELEMENTARY_ION);
        result.add(IonType.GLYCAN);
        result.add(IonType.IMMONIUM_ION);
        result.add(IonType.PEPTIDE_FRAGMENT_ION);
        result.add(IonType.TAG_FRAGMENT_ION);
        result.add(IonType.PRECURSOR_ION);
        result.add(IonType.REPORTER_ION);
        result.add(IonType.RELATED_ION);
        return result;
    }

    public String getTypeAsString() {
        return Ion.getTypeAsString(this.type);
    }

    public static String getTypeAsString(IonType type) {
        switch (type.ordinal()) {
            case 0: {
                return "Peptide fragment ion";
            }
            case 1: {
                return "Tag fragment ion";
            }
            case 2: {
                return "Precursor ion";
            }
            case 3: {
                return "Immonium ion";
            }
            case 4: {
                return "Reporter ion";
            }
            case 5: {
                return "Glycan";
            }
            case 6: {
                return "Elementary ion";
            }
            case 8: {
                return "Related ion";
            }
            case 7: {
                return "Unknown ion type";
            }
        }
        throw new UnsupportedOperationException("No name for ion type " + (Object)((Object)type) + ".");
    }

    public static Ion getGenericIon(IonType ionType, int subType, NeutralLoss[] neutralLosses) {
        switch (ionType.ordinal()) {
            case 6: {
                return new ElementaryIon("new ElementaryIon", 0.0, subType);
            }
            case 5: {
                return new Glycan("new Glycan", "new Glycan");
            }
            case 3: {
                return ImmoniumIon.getImmoniumIon(subType);
            }
            case 0: {
                return new PeptideFragmentIon(subType, neutralLosses);
            }
            case 1: {
                return new TagFragmentIon(subType, neutralLosses);
            }
            case 2: {
                return new PrecursorIon(neutralLosses);
            }
            case 4: {
                return ReporterIon.getReporterIon(subType);
            }
            case 8: {
                return new RelatedIon(AminoAcid.A, AtomChain.getAtomChain("H"), -1, false);
            }
        }
        throw new UnsupportedOperationException("No generic constructor for " + Ion.getTypeAsString(ionType) + ".");
    }

    public static Ion getGenericIon(IonType ionType, int subType) {
        switch (ionType.ordinal()) {
            case 6: {
                return new ElementaryIon("new ElementaryIon", 0.0, subType);
            }
            case 5: {
                return new Glycan("new Glycon", "new Glycon");
            }
            case 3: {
                return ImmoniumIon.getImmoniumIon(subType);
            }
            case 0: {
                return new PeptideFragmentIon(subType);
            }
            case 1: {
                return new TagFragmentIon(subType);
            }
            case 2: {
                return new PrecursorIon();
            }
            case 4: {
                return ReporterIon.getReporterIon(subType);
            }
            case 8: {
                return new RelatedIon(AminoAcid.A, AtomChain.getAtomChain("H"), -1, false);
            }
        }
        throw new UnsupportedOperationException("No generic constructor for " + Ion.getTypeAsString(ionType) + ".");
    }

    public static enum IonType {
        PEPTIDE_FRAGMENT_ION(0),
        TAG_FRAGMENT_ION(1),
        PRECURSOR_ION(2),
        IMMONIUM_ION(3),
        REPORTER_ION(4),
        GLYCAN(5),
        ELEMENTARY_ION(6),
        UNKNOWN(7),
        RELATED_ION(8);

        public final int index;

        private IonType(int index) {
            this.index = index;
        }
    }
}

