/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology.modifications;

public enum ModificationCategory {
    Common,
    Common_Biological,
    Common_Artifact,
    Metal,
    Glyco,
    Less_Common,
    Labeling,
    Nucleotide_Substitution_One,
    Nucleotide_Substitution_TwoPlus,
    Other;


    public String toString() {
        switch (this.ordinal()) {
            case 0: {
                return "Common Fixed and Variable";
            }
            case 1: {
                return "Common Biological";
            }
            case 2: {
                return "Common Artifact";
            }
            case 3: {
                return "Metal";
            }
            case 4: {
                return "Glycosylation";
            }
            case 5: {
                return "Less Common";
            }
            case 6: {
                return "Labeling";
            }
            case 7: {
                return "Substitution (1 Nucleotide)";
            }
            case 8: {
                return "Substitution (2+ Nucleotides)";
            }
            case 9: {
                return "Other";
            }
        }
        throw new UnsupportedOperationException("Modification category " + this.name() + " not implemented.");
    }

    public static String getCategoriesAsString() {
        StringBuilder modCategoriesAsString = new StringBuilder();
        for (ModificationCategory modCategory : ModificationCategory.values()) {
            if (modCategoriesAsString.length() > 0) {
                modCategoriesAsString.append(", ");
            }
            modCategoriesAsString.append((Object)modCategory);
        }
        modCategoriesAsString.append(".");
        return modCategoriesAsString.toString();
    }
}

