/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology.modifications;

public enum ModificationType {
    modaa(0, "Modification at specific amino acids.", "Particular Amino Acid"),
    modn_protein(1, "Modification at the N-terminus of a protein", "Protein N-term"),
    modnaa_protein(2, "Modification at the N-terminus of a protein at specific amino acids.", "Protein N-term - Particular Amino Acid(s)"),
    modc_protein(3, "Modification at the C-terminus of a protein.", "Protein C-term"),
    modcaa_protein(4, "Modification at the C-terminus of a protein at specific amino acids.", "Protein C-term - Particular Amino Acid(s)"),
    modn_peptide(5, "Modification at the N-terminus of a peptide", "Peptide N-term"),
    modnaa_peptide(6, "Modification at the N-terminus of a peptide at specific amino acids.", "Peptide N-term - Particular Amino Acid(s)"),
    modc_peptide(7, "Modification at the C-terminus of a peptide.", "Peptide C-term"),
    modcaa_peptide(8, "Modification at the C-terminus of a peptide at specific amino acids.", "Peptide C-term - Particular Amino Acid(s)");

    public final int index;
    public final String description;
    public final String shortName;

    private ModificationType() {
        this.index = 0;
        this.description = "";
        this.shortName = "";
    }

    private ModificationType(int index, String description, String shortName) {
        this.index = index;
        this.description = description;
        this.shortName = shortName;
    }

    public boolean isNTerm() {
        return this == modn_peptide || this == modn_protein || this == modnaa_peptide || this == modnaa_protein;
    }

    public boolean isCTerm() {
        return this == modc_peptide || this == modc_protein || this == modcaa_peptide || this == modcaa_protein;
    }

    public String toString() {
        return this.shortName;
    }

    public static String getTypesAsString() {
        StringBuilder modTypesAsString = new StringBuilder();
        for (ModificationType modType : ModificationType.values()) {
            if (modTypesAsString.length() > 0) {
                modTypesAsString.append("; ");
            }
            modTypesAsString.append(modType.description).append(": ").append(modType.description);
        }
        modTypesAsString.append(".");
        return modTypesAsString.toString();
    }
}

