/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology.taxonomy;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.taxonomy.mappings.BiomartMapping;
import com.compomics.util.experiment.biology.taxonomy.mappings.EnsemblSpecies;
import com.compomics.util.experiment.biology.taxonomy.mappings.UniprotTaxonomy;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class SpeciesFactory {
    private static SpeciesFactory instance = null;
    public static final String UNKNOWN = "Unknown";
    private static final String TOOL_SPECIES_MAPPING_SUBFOLDER = "resources/conf/taxonomy/";
    public static final String UNIPROT_TAXONOMY_FILENAME = "uniprot_species";
    public static final String ENSEMBL_SPECIES = "ensembl_all_species";
    public static final String BIOMART_ENSEMBL_FILENAME = "ensembl_biomart_databases";
    private EnsemblSpecies ensemblSpecies;
    private UniprotTaxonomy uniprotTaxonomy;
    private BiomartMapping biomartMapping;

    public static SpeciesFactory getInstance() {
        if (instance == null) {
            instance = new SpeciesFactory();
        }
        return instance;
    }

    private SpeciesFactory() {
    }

    public void initiate(File configFolder) throws IOException {
        this.ensemblSpecies = new EnsemblSpecies();
        this.ensemblSpecies.loadMapping(SpeciesFactory.getEnsemblSpeciesFile(configFolder));
        this.uniprotTaxonomy = new UniprotTaxonomy();
        this.uniprotTaxonomy.loadMapping(SpeciesFactory.getUniprotTaxonomyFile(configFolder));
        this.biomartMapping = new BiomartMapping();
        this.biomartMapping.loadMapping(SpeciesFactory.getBiomartEnsemblMappingFile(configFolder));
    }

    public static String getSpeciesDescription(TreeMap<String, Integer> speciesOccurrence) {
        TreeSet<String> species;
        TreeMap<Integer, TreeSet<String>> occurrenceToSpecies = new TreeMap<Integer, TreeSet<String>>();
        double total = 0.0;
        for (Map.Entry<String, Integer> entry : speciesOccurrence.entrySet()) {
            String taxonomy = entry.getKey();
            Integer occurrence = entry.getValue();
            total += (double)occurrence.intValue();
            species = (TreeSet<String>)occurrenceToSpecies.get(occurrence);
            if (species == null) {
                species = new TreeSet<String>();
                occurrenceToSpecies.put(occurrence, species);
            }
            species.add(taxonomy);
        }
        StringBuilder description = new StringBuilder();
        for (Map.Entry entry : occurrenceToSpecies.descendingMap().entrySet()) {
            int occurrence = (Integer)entry.getKey();
            species = (TreeSet)entry.getValue();
            for (String taxonomy : species) {
                String occurrencePercentage;
                double percentage = 100.0 * (double)occurrence / total;
                if (description.length() > 0) {
                    description.append(", ");
                }
                description.append(taxonomy);
                if (speciesOccurrence.size() <= 1) continue;
                if (percentage > 99.9) {
                    occurrencePercentage = ">99.9";
                } else if (percentage < 0.1) {
                    occurrencePercentage = "<0.1";
                } else {
                    double roundedDouble = Util.roundDouble(percentage, 1);
                    occurrencePercentage = Double.toString(roundedDouble);
                }
                description.append(" (").append(occurrence).append(", ").append(occurrencePercentage).append("%)");
            }
        }
        return description.toString();
    }

    public static File getEnsemblSpeciesFile(File configFolder) {
        return new File(configFolder, "resources/conf/taxonomy/ensembl_all_species");
    }

    public static File getUniprotTaxonomyFile(File configFolder) {
        return new File(configFolder, "resources/conf/taxonomy/uniprot_species");
    }

    public static File getBiomartEnsemblMappingFile(File configFolder) {
        return new File(configFolder, "resources/conf/taxonomy/ensembl_biomart_databases");
    }

    public String getLatinName(Integer taxon) {
        return this.uniprotTaxonomy.getLatinName(taxon);
    }

    public String getEnsemblAssembly(String latinName) {
        return this.ensemblSpecies.getAssembly(latinName);
    }

    public String getEnsemblDataset(String latinName) {
        String assembly = this.getEnsemblAssembly(latinName);
        if (assembly == null) {
            return null;
        }
        return this.biomartMapping.getDataset(assembly);
    }

    public String getEnsemblDatasetName(String latinName, EnsemblSpecies.EnsemblDivision ensemblDivision) {
        String ensemblDatasetName = "";
        String[] ensemblDatasetNameElements = latinName.split("_");
        for (int i = 0; i < ensemblDatasetNameElements.length - 1; ++i) {
            ensemblDatasetName = ensemblDatasetName + ensemblDatasetNameElements[i].substring(0, 1);
        }
        ensemblDatasetName = ensemblDatasetName + ensemblDatasetNameElements[ensemblDatasetNameElements.length - 1];
        ensemblDatasetName = ensemblDivision == EnsemblSpecies.EnsemblDivision.vertebrates ? ensemblDatasetName + "_gene_ensembl" : ensemblDatasetName + "_eg_gene";
        return ensemblDatasetName;
    }

    public EnsemblSpecies getEnsemblSpecies() {
        return this.ensemblSpecies;
    }

    public UniprotTaxonomy getUniprotTaxonomy() {
        return this.uniprotTaxonomy;
    }

    public BiomartMapping getBiomartMapping() {
        return this.biomartMapping;
    }

    public HashMap<String, HashSet<String>> getEnsembleSpecies() {
        HashMap<String, HashSet<String>> speciesMap = new HashMap<String, HashSet<String>>(EnsemblSpecies.EnsemblDivision.values().length + 1);
        for (String tempLatinName : this.ensemblSpecies.getLatinNames()) {
            String divisionName = this.ensemblSpecies.getDivision((String)tempLatinName).ensemblType;
            HashSet<String> latinNames = speciesMap.get(divisionName);
            if (latinNames == null) {
                latinNames = new HashSet();
                speciesMap.put(divisionName, latinNames);
            }
            latinNames.add(tempLatinName);
        }
        return speciesMap;
    }
}

