/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification;

import com.compomics.util.experiment.personalization.ExperimentObject;
import java.awt.Color;
import java.util.HashMap;

public class Advocate
extends ExperimentObject {
    public static final Advocate mascot = new Advocate(0, "Mascot", AdvocateType.search_engine, new Color(255, 153, 255));
    public static final Advocate omssa = new Advocate(1, "OMSSA", AdvocateType.search_engine, new Color(153, 153, 255));
    public static final Advocate xtandem = new Advocate(2, "X!Tandem", AdvocateType.search_engine, new Color(153, 255, 255));
    public static final Advocate pepnovo = new Advocate(3, "PepNovo+", AdvocateType.sequencing_algorithm, new Color(224, 130, 20));
    public static final Advocate andromeda = new Advocate(4, "Andromeda", AdvocateType.search_engine, new Color(230, 230, 250));
    public static final Advocate msAmanda = new Advocate(5, "MS Amanda", AdvocateType.search_engine, new Color(216, 191, 216));
    public static final Advocate peptideShaker = new Advocate(6, "PeptideShaker", AdvocateType.multiple_algorithm_software, new Color(110, 196, 97));
    public static final Advocate msgf = new Advocate(7, "MS-GF+", AdvocateType.search_engine, new Color(205, 92, 92));
    public static final Advocate direcTag = new Advocate(8, "DirecTag", AdvocateType.sequencing_algorithm, new Color(189, 183, 107));
    public static final Advocate byonic = new Advocate(9, "Byonic", AdvocateType.search_engine);
    public static final Advocate comet = new Advocate(10, "Comet", AdvocateType.search_engine, new Color(255, 160, 122));
    public static final Advocate proteinLynx = new Advocate(11, "ProteinLynx", AdvocateType.search_engine);
    public static final Advocate msFit = new Advocate(12, "MS-Fit", AdvocateType.search_engine);
    public static final Advocate myriMatch = new Advocate(13, "MyriMatch", AdvocateType.search_engine, new Color(241, 226, 204));
    public static final Advocate peaks = new Advocate(14, "PEAKS Studio", AdvocateType.sequencing_algorithm, new Color(173, 255, 47));
    public static final Advocate phenyx = new Advocate(15, "Phenyx", AdvocateType.search_engine);
    public static final Advocate proFound = new Advocate(16, "ProFound", AdvocateType.search_engine);
    public static final Advocate proteinProspector = new Advocate(17, "ProteinProspector", AdvocateType.search_engine);
    public static final Advocate proteinScape = new Advocate(18, "ProteinScape", AdvocateType.search_engine);
    public static final Advocate sequest = new Advocate(19, "SEQUEST", AdvocateType.search_engine);
    public static final Advocate sqid = new Advocate(20, "SQID", AdvocateType.search_engine);
    public static final Advocate scaffold = new Advocate(21, "Scaffold", AdvocateType.multiple_algorithm_software);
    public static final Advocate sonar = new Advocate(22, "Sonar", AdvocateType.search_engine);
    public static final Advocate spectraST = new Advocate(23, "SpectraST", AdvocateType.spectral_library);
    public static final Advocate spectrumMill = new Advocate(24, "SpectrumMill", AdvocateType.search_engine);
    public static final Advocate zCore = new Advocate(25, "ZCore", AdvocateType.search_engine);
    public static final Advocate percolator = new Advocate(26, "Percolator", AdvocateType.rescoring_algorithm);
    public static final Advocate pNovo = new Advocate(27, "pNovo+", AdvocateType.sequencing_algorithm, new Color(253, 192, 134));
    public static final Advocate tide = new Advocate(28, "Tide", AdvocateType.search_engine, new Color(210, 105, 30));
    public static final Advocate novor = new Advocate(29, "Novor", AdvocateType.sequencing_algorithm, new Color(135, 206, 235));
    public static final Advocate morpheus = new Advocate(30, "Morpheus", AdvocateType.search_engine, new Color(255, 248, 220));
    public static final Advocate proteinPilot = new Advocate(31, "ProteinPilot Software", AdvocateType.search_engine, new Color(75, 0, 130));
    public static final Advocate onyaseEngine = new Advocate(32, "Onyase Engine", AdvocateType.search_engine);
    public static final Advocate metaMorpheus = new Advocate(33, "MetaMorpheus", AdvocateType.search_engine, new Color(218, 165, 32));
    public static final Advocate identiPy = new Advocate(34, "IdentiPy", AdvocateType.search_engine, new Color(128, 128, 0));
    public static final Advocate coss = new Advocate(35, "COSS", AdvocateType.spectral_library, new Color(108, 108, 0));
    public static final Advocate sage = new Advocate(36, "Sage", AdvocateType.search_engine, new Color(108, 108, 0));
    public static final Advocate genericMzId = new Advocate(100, "mzid", AdvocateType.unknown);
    private static HashMap<Integer, Advocate> userAdvocates = new HashMap();
    private final int index;
    private final String name;
    private final AdvocateType type;
    private Color color = Color.lightGray;
    private static HashMap<Integer, Color> advocateColorMap;
    private static HashMap<Integer, String> advocateToolTipMap;

    public Advocate() {
        this.index = 0;
        this.name = "";
        this.type = null;
    }

    private Advocate(int index, String name, AdvocateType type, Color color) {
        this.index = index;
        this.name = name;
        this.type = type;
        this.color = color;
    }

    private Advocate(int index, String name, AdvocateType type) {
        this.index = index;
        this.name = name;
        this.type = type;
    }

    private Advocate(int index, String name) {
        this.index = index;
        this.name = name;
        this.type = AdvocateType.unknown;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public AdvocateType getType() {
        return this.type;
    }

    public Color getColor() {
        return this.color;
    }

    public String toString() {
        return this.name;
    }

    public static Advocate[] values() {
        Advocate[] result = new Advocate[39 + userAdvocates.size()];
        int i = 0;
        result[i] = peptideShaker;
        result[++i] = onyaseEngine;
        result[++i] = xtandem;
        result[++i] = myriMatch;
        result[++i] = comet;
        result[++i] = msAmanda;
        result[++i] = andromeda;
        result[++i] = omssa;
        result[++i] = msgf;
        result[++i] = mascot;
        result[++i] = direcTag;
        result[++i] = novor;
        result[++i] = genericMzId;
        result[++i] = pepnovo;
        result[++i] = byonic;
        result[++i] = tide;
        result[++i] = proteinLynx;
        result[++i] = msFit;
        result[++i] = peaks;
        result[++i] = phenyx;
        result[++i] = proFound;
        result[++i] = proteinProspector;
        result[++i] = proteinScape;
        result[++i] = sequest;
        result[++i] = sqid;
        result[++i] = scaffold;
        result[++i] = sonar;
        result[++i] = spectraST;
        result[++i] = spectrumMill;
        result[++i] = zCore;
        result[++i] = percolator;
        result[++i] = pNovo;
        result[++i] = morpheus;
        result[++i] = proteinPilot;
        result[++i] = onyaseEngine;
        result[++i] = metaMorpheus;
        result[++i] = identiPy;
        result[++i] = coss;
        result[++i] = sage;
        for (Advocate advocate : userAdvocates.values()) {
            result[++i] = advocate;
        }
        return result;
    }

    public static Advocate getAdvocate(int index) {
        for (Advocate advocate : Advocate.values()) {
            if (advocate.getIndex() != index) continue;
            return advocate;
        }
        return null;
    }

    public static Advocate getAdvocate(String advocateName) {
        for (Advocate advocate : Advocate.values()) {
            if (!advocate.getName().equals(advocateName)) continue;
            return advocate;
        }
        for (Integer key : userAdvocates.keySet()) {
            Advocate advocate = userAdvocates.get(key);
            if (!advocate.getName().equals(advocateName)) continue;
            return advocate;
        }
        return null;
    }

    public static Advocate addUserAdvocate(String advocateName) {
        int maxIndex = 0;
        for (Advocate advocate : Advocate.values()) {
            int advocateIndex = advocate.getIndex();
            if (advocateIndex < maxIndex) continue;
            maxIndex = advocateIndex + 1;
        }
        Advocate newAdvocate = new Advocate(maxIndex, advocateName);
        userAdvocates.put(maxIndex, newAdvocate);
        return newAdvocate;
    }

    public static HashMap<Integer, Advocate> getUserAdvocates() {
        return userAdvocates;
    }

    public static void setUserAdvocates(HashMap<Integer, Advocate> userAdvocates) {
        Advocate.userAdvocates = userAdvocates;
    }

    public String getPmid() {
        if (this == mascot) {
            return "10612281";
        }
        if (this == omssa) {
            return "15473683";
        }
        if (this == xtandem) {
            return "14976030";
        }
        if (this == pepnovo) {
            return "15858974";
        }
        if (this == pNovo) {
            return "23272783";
        }
        if (this == novor) {
            return "26122521";
        }
        if (this == andromeda) {
            return "21254760";
        }
        if (this == direcTag) {
            return "18630943";
        }
        if (this == msAmanda) {
            return "33759252";
        }
        if (this == msgf) {
            return "25358478";
        }
        if (this == myriMatch) {
            return "17269722";
        }
        if (this == comet) {
            return "23148064";
        }
        if (this == peptideShaker) {
            return "25574629";
        }
        if (this == tide) {
            return "21761931";
        }
        if (this == morpheus) {
            return "23323968";
        }
        if (this == identiPy) {
            return "29682971";
        }
        if (this == sage) {
            return "37819886";
        }
        return null;
    }

    public static HashMap<Integer, Color> getAdvocateColorMap() {
        if (advocateColorMap == null) {
            advocateColorMap = new HashMap();
            for (Advocate advocate : Advocate.values()) {
                advocateColorMap.put(advocate.getIndex(), advocate.getColor());
            }
        }
        return advocateColorMap;
    }

    public static HashMap<Integer, String> getAdvocateToolTipMap() {
        if (advocateToolTipMap == null) {
            advocateToolTipMap = new HashMap();
            for (Advocate tempAdvoate : Advocate.values()) {
                advocateToolTipMap.put(tempAdvoate.getIndex(), tempAdvoate.getName());
            }
        }
        return advocateToolTipMap;
    }

    public static Advocate getAdvocateFromFile(String idFileName) {
        if (idFileName.toLowerCase().endsWith("dat")) {
            return mascot;
        }
        if (idFileName.toLowerCase().endsWith("omx")) {
            return omssa;
        }
        if (idFileName.toLowerCase().endsWith("xml")) {
            return xtandem;
        }
        if (idFileName.toLowerCase().endsWith("mzid")) {
            return msgf;
        }
        if (idFileName.toLowerCase().endsWith("csv")) {
            return msAmanda;
        }
        if (idFileName.toLowerCase().endsWith("txt")) {
            return comet;
        }
        if (idFileName.toLowerCase().endsWith("txt")) {
            return tide;
        }
        return null;
    }

    public static enum AdvocateType {
        search_engine,
        sequencing_algorithm,
        spectral_library,
        rescoring_algorithm,
        multiple_algorithm_software,
        unknown;

    }
}

