/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification;

import com.compomics.util.experiment.biology.ions.impl.ElementaryIon;
import com.compomics.util.experiment.biology.ions.impl.PrecursorIon;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.personalization.ExperimentObject;
import java.util.ArrayList;

public abstract class SpectrumIdentificationAssumption
extends ExperimentObject {
    protected int rank;
    protected int advocate;
    protected int identificationCharge;
    protected double score;
    protected String identificationFile;
    protected double rawScore;
    protected ArrayList<double[]> aminoAcidScores = null;

    public int getRank() {
        return this.rank;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    public int getAdvocate() {
        return this.advocate;
    }

    public void setAdvocate(int advocate) {
        this.advocate = advocate;
    }

    public double getScore() {
        return this.score;
    }

    public void setScore(double score) {
        this.score = score;
    }

    public String getIdentificationFile() {
        return this.identificationFile;
    }

    public void setIdentificationFile(String identificationFile) {
        this.identificationFile = identificationFile;
    }

    public int getIdentificationCharge() {
        return this.identificationCharge;
    }

    public void setIdentificationCharge(int identificationCharge) {
        this.identificationCharge = identificationCharge;
    }

    public abstract double getTheoreticMass();

    public double getTheoreticMz() {
        return (this.getTheoreticMass() + ElementaryIon.proton.getTheoreticMass() * (double)this.identificationCharge) / (double)this.identificationCharge;
    }

    public double getDeltaMz(double measuredMZ, boolean ppm, int minIsotope, int maxIsotope) {
        IonMatch ionMatch = this.getPrecursorMatch(measuredMZ, 0.0);
        return ionMatch.getError(ppm, minIsotope, maxIsotope);
    }

    public int getIsotopeNumber(double measuredMZ, int minIsotope, int maxIsotope) {
        IonMatch ionMatch = this.getPrecursorMatch(measuredMZ, 0.0);
        return ionMatch.getIsotopeNumber(minIsotope, maxIsotope);
    }

    public IonMatch getPrecursorMatch(double precursorMz, double precursorIntensity) {
        return new IonMatch(precursorMz, precursorIntensity, new PrecursorIon(this.getTheoreticMass()), this.getIdentificationCharge());
    }

    public double getRawScore() {
        return this.rawScore;
    }

    public void setRawScore(double rawScore) {
        this.rawScore = rawScore;
    }

    public ArrayList<double[]> getAminoAcidScores() {
        return this.aminoAcidScores;
    }

    public void setAminoAcidScores(ArrayList<double[]> aminoAcidScores) {
        this.aminoAcidScores = aminoAcidScores;
    }
}

