/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.features;

import com.compomics.util.experiment.identification.features.MutexMap;
import com.compomics.util.experiment.personalization.ExperimentObject;
import java.util.HashMap;
import java.util.concurrent.Semaphore;

public class IdentificationFeaturesCache
extends ExperimentObject {
    private static final int smallObjectsCacheSize = 1000000;
    private static final int largeObjectsCacheSize = 1000;
    private int smallObjectsInCache = 0;
    private int largeObjectsInCache = 0;
    private final HashMap<ObjectType, HashMap<Long, Object>> largeObjectsCache = new HashMap();
    private final HashMap<ObjectType, HashMap<Long, Object>> smallObjectsCache = new HashMap();
    private long[] proteinListAfterHiding = null;
    private long[] proteinList = null;
    private long[] validatedProteinList = null;
    private long[] peptideList;
    private long[] psmList;
    private boolean filtered = false;
    private int maxSpectrumCount;
    private int nValidatedPsms;
    private long currentProteinKey;
    private long currentPeptideKey;
    private boolean readOnly = false;

    public IdentificationFeaturesCache() {
        for (ObjectType type : ObjectType.values()) {
            if (!type.large) {
                this.smallObjectsCache.put(type, new HashMap());
            } else {
                this.largeObjectsCache.put(type, new HashMap());
            }
            MutexMap.mutexMap.put(type, new Semaphore(1));
        }
    }

    public void removeObjects(ObjectType type) {
        if (!type.large) {
            HashMap<Long, Object> subMap = this.smallObjectsCache.get((Object)type);
            this.smallObjectsCache.put(type, new HashMap());
            this.smallObjectsInCache -= subMap.size();
        } else {
            HashMap<Long, Object> subMap = this.largeObjectsCache.get((Object)type);
            this.largeObjectsCache.put(type, new HashMap());
            this.largeObjectsInCache -= subMap.size();
        }
    }

    public void addObject(ObjectType type, long objectKey, Object object) {
        if (!this.readOnly) {
            try {
                if (!type.large) {
                    Semaphore mutex = MutexMap.mutexMap.get((Object)type);
                    mutex.acquire();
                    HashMap<Long, Object> subMap = this.smallObjectsCache.get((Object)type);
                    if (subMap.containsKey(objectKey)) {
                        mutex.release();
                    } else {
                        this.smallObjectsCache.get((Object)type).put(objectKey, object);
                        ++this.smallObjectsInCache;
                        mutex.release();
                        int i = 0;
                        ObjectType[] types = ObjectType.values();
                        while (this.smallObjectsInCache > 1000000 && i++ < types.length) {
                            ObjectType cacheType = types[i];
                            if (cacheType.large || cacheType == type) continue;
                            mutex = MutexMap.mutexMap.get((Object)cacheType);
                            mutex.acquire();
                            this.removeObjects(type);
                            mutex.release();
                        }
                    }
                } else {
                    Semaphore mutex = MutexMap.mutexMap.get((Object)type);
                    mutex.acquire();
                    HashMap<Long, Object> subMap = this.largeObjectsCache.get((Object)type);
                    if (subMap.containsKey(objectKey)) {
                        mutex.release();
                    } else {
                        this.largeObjectsCache.get((Object)type).put(objectKey, object);
                        ++this.largeObjectsInCache;
                        mutex.release();
                        int i = 0;
                        ObjectType[] types = ObjectType.values();
                        while (this.largeObjectsInCache > 1000 && i++ < types.length) {
                            ObjectType cacheType = types[i];
                            if (!cacheType.large || cacheType == type) continue;
                            mutex = MutexMap.mutexMap.get((Object)cacheType);
                            mutex.acquire();
                            this.removeObjects(type);
                            mutex.release();
                        }
                    }
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException();
            }
        }
    }

    public Object getObject(ObjectType type, long objectKey) {
        return type.large ? this.largeObjectsCache.get((Object)type).get(objectKey) : this.smallObjectsCache.get((Object)type).get(objectKey);
    }

    public long getCurrentPeptideKey() {
        return this.currentPeptideKey;
    }

    public void setCurrentPeptideKey(long currentPeptideKey) {
        this.currentPeptideKey = currentPeptideKey;
    }

    public long getCurrentProteinKey() {
        return this.currentProteinKey;
    }

    public void setCurrentProteinKey(long currentProteinKey) {
        this.currentProteinKey = currentProteinKey;
    }

    public boolean isFiltered() {
        return this.filtered;
    }

    public void setFiltered(boolean filtered) {
        this.filtered = filtered;
    }

    public int getMaxSpectrumCount() {
        return this.maxSpectrumCount;
    }

    public void setMaxSpectrumCount(int maxSpectrumCount) {
        this.maxSpectrumCount = maxSpectrumCount;
    }

    public int getnValidatedPsms() {
        return this.nValidatedPsms;
    }

    public void setnValidatedPsms(int nValidatedPsms) {
        this.nValidatedPsms = nValidatedPsms;
    }

    public long[] getPeptideList() {
        return this.peptideList;
    }

    public void setPeptideList(long[] peptideList) {
        this.peptideList = peptideList;
    }

    public long[] getProteinList() {
        return this.proteinList;
    }

    public void setProteinList(long[] proteinList) {
        this.proteinList = proteinList;
    }

    public long[] getProteinListAfterHiding() {
        return this.proteinListAfterHiding;
    }

    public void setProteinListAfterHiding(long[] proteinListAfterHiding) {
        this.proteinListAfterHiding = proteinListAfterHiding;
    }

    public long[] getPsmList() {
        return this.psmList;
    }

    public void setPsmList(long[] psmList) {
        this.psmList = psmList;
    }

    public long[] getValidatedProteinList() {
        return this.validatedProteinList;
    }

    public void setValidatedProteinList(long[] validatedProteinList) {
        this.validatedProteinList = validatedProteinList;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public static enum ObjectType {
        tryptic_protein(true),
        coverable_AA_p(true),
        AA_coverage(true),
        number_of_validated_peptides(false),
        number_of_confident_peptides(false),
        number_of_spectra(false),
        number_of_validated_spectra(false),
        number_of_confident_spectra(false),
        unique_peptides(false),
        unique_validated_peptides(false),
        protein_groups_for_peptide(false),
        containsEnzymaticPeptides(false),
        max_psm_mz_for_peptides(false),
        sequence_coverage(false),
        sequence_validation_coverage(false),
        expected_coverage(false),
        spectrum_counting(false);

        public final boolean large;

        private ObjectType(boolean large) {
            this.large = large;
        }
    }
}

