/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.filtering;

import com.compomics.util.experiment.biology.genes.GeneMaps;
import com.compomics.util.experiment.filtering.Filter;
import com.compomics.util.experiment.filtering.FilterItem;
import com.compomics.util.experiment.filtering.FilterItemComparator;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.features.IdentificationFeaturesGenerator;
import com.compomics.util.experiment.io.biology.protein.ProteinDetailsProvider;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.parameters.identification.IdentificationParameters;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public abstract class MatchFilter
extends ExperimentObject
implements Filter {
    protected String name = "";
    protected String description = "";
    protected String condition = "";
    protected String reportPassed = "";
    protected String reportFailed = "";
    private boolean active = true;
    protected HashSet<Long> manualValidation = new HashSet(0);
    protected HashSet<Long> exceptions = new HashSet(0);
    public static final String MANUAL_SELECTION = "manual selection";
    protected HashMap<String, FilterItemComparator> comparatorsMap = new HashMap(0);
    protected HashMap<String, Object> valuesMap = new HashMap(0);
    protected FilterType filterType;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getCondition() {
        return this.condition;
    }

    @Override
    public String getReport(boolean filterPassed) {
        return filterPassed ? this.reportPassed : this.reportFailed;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public void setReportPassed(String reportPassed) {
        this.reportPassed = reportPassed;
    }

    public void setReportFailed(String reportFailed) {
        this.reportFailed = reportFailed;
    }

    public FilterType getType() {
        return this.filterType;
    }

    public void setType(FilterType filterType) {
        this.filterType = filterType;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public HashSet<Long> getExceptions() {
        return this.exceptions;
    }

    public HashSet<Long> getManualValidation() {
        return this.manualValidation;
    }

    public void addManualValidation(long matchKey) {
        this.manualValidation.add(matchKey);
    }

    public void setManualValidation(HashSet<Long> manualValidation) {
        this.manualValidation = manualValidation;
    }

    public void addException(long matchKey) {
        this.exceptions.add(matchKey);
    }

    public void setExceptions(HashSet<Long> exceptions) {
        this.exceptions = exceptions;
    }

    public void removeManualValidation(long matchKey) {
        this.manualValidation.remove(matchKey);
    }

    public void removeException(long matchKey) {
        this.exceptions.remove(matchKey);
    }

    protected abstract MatchFilter getNew();

    @Override
    public MatchFilter clone() {
        MatchFilter newFilter = this.getNew();
        newFilter.setName(this.name);
        newFilter.setDescription(this.description);
        newFilter.setCondition(this.condition);
        newFilter.setReportPassed(this.reportPassed);
        newFilter.setReportFailed(this.reportFailed);
        newFilter.setType(this.filterType);
        newFilter.setManualValidation(new HashSet<Long>(this.manualValidation));
        newFilter.setExceptions(new HashSet<Long>(this.exceptions));
        for (String itemName : this.getItemsNames()) {
            FilterItemComparator filterItemComparator = this.getComparatorForItem(itemName);
            Object value = this.getValue(itemName);
            newFilter.setFilterItem(itemName, filterItemComparator, value);
        }
        return newFilter;
    }

    public void removeFilterItem(String itemName) {
        this.comparatorsMap.remove(itemName);
        this.valuesMap.remove(itemName);
    }

    public void setFilterItem(String itemName, FilterItemComparator filterItemComparator, Object value) {
        this.setComparatorForItem(itemName, filterItemComparator);
        this.setValueForItem(itemName, value);
    }

    public void setComparatorForItem(String itemName, FilterItemComparator filterItemComparator) {
        this.comparatorsMap.put(itemName, filterItemComparator);
    }

    public void setValueForItem(String itemName, Object value) {
        this.valuesMap.put(itemName, value);
    }

    public HashSet<String> getItemsNames() {
        return new HashSet<String>(this.valuesMap.keySet());
    }

    public FilterItemComparator getComparatorForItem(String itemName) {
        return this.comparatorsMap.get(itemName);
    }

    public Object getValue(String itemName) {
        return this.valuesMap.get(itemName);
    }

    public void clear() {
        this.valuesMap.clear();
        this.comparatorsMap.clear();
    }

    public boolean isValidated(long matchKey, Identification identification, GeneMaps geneMaps, IdentificationFeaturesGenerator identificationFeaturesGenerator, IdentificationParameters identificationParameters, SequenceProvider sequenceProvider, ProteinDetailsProvider proteinDetailsProvider, SpectrumProvider spectrumProvider) {
        if (this.exceptions.contains(matchKey)) {
            return false;
        }
        if (this.manualValidation.contains(matchKey)) {
            return true;
        }
        for (Map.Entry<String, Object> entry : this.valuesMap.entrySet()) {
            String itemName = entry.getKey();
            Object value = entry.getValue();
            FilterItemComparator filterItemComparator = this.comparatorsMap.get(itemName);
            boolean validated = this.isValidated(itemName, filterItemComparator, value, matchKey, identification, geneMaps, identificationFeaturesGenerator, identificationParameters, sequenceProvider, proteinDetailsProvider, spectrumProvider);
            if (validated) continue;
            return false;
        }
        return true;
    }

    public abstract boolean isValidated(String var1, FilterItemComparator var2, Object var3, long var4, Identification var6, GeneMaps var7, IdentificationFeaturesGenerator var8, IdentificationParameters var9, SequenceProvider var10, ProteinDetailsProvider var11, SpectrumProvider var12);

    @Override
    public boolean isSameAs(Filter anotherFilter) {
        if (anotherFilter instanceof MatchFilter) {
            MatchFilter otherFilter = (MatchFilter)anotherFilter;
            if (!this.name.equals(otherFilter.getName())) {
                return false;
            }
            if (!this.description.equals(otherFilter.getDescription())) {
                return false;
            }
            if (!this.condition.equals(otherFilter.getCondition())) {
                return false;
            }
            if (!this.reportPassed.equals(otherFilter.getReport(true))) {
                return false;
            }
            if (!this.reportFailed.equals(otherFilter.getReport(false))) {
                return false;
            }
            if (this.isActive() != otherFilter.isActive()) {
                return false;
            }
            if (!this.exceptions.equals(otherFilter.getExceptions())) {
                return false;
            }
            if (!this.manualValidation.equals(otherFilter.getManualValidation())) {
                return false;
            }
            if (!this.getItemsNames().equals(otherFilter.getItemsNames())) {
                return false;
            }
            for (String itemName : this.getItemsNames()) {
                Object otherValue;
                FilterItemComparator otherComparator;
                FilterItemComparator thisComparator = this.getComparatorForItem(itemName);
                if (thisComparator != (otherComparator = otherFilter.getComparatorForItem(itemName))) {
                    return false;
                }
                Object thisValue = this.getValue(itemName);
                if (thisValue.equals(otherValue = otherFilter.getValue(itemName))) continue;
                return false;
            }
        }
        return true;
    }

    public abstract FilterItem[] getPossibleFilterItems();

    public String[] getPossibleFilterItemsNames() {
        return (String[])Arrays.stream(this.getPossibleFilterItems()).map(item -> item.getName()).toArray(String[]::new);
    }

    public abstract FilterItem getFilterItem(String var1);

    public static enum FilterType {
        PROTEIN,
        PEPTIDE,
        PSM,
        ASSUMPTION;

    }
}

