/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.filtering;

import com.compomics.util.experiment.biology.genes.GeneMaps;
import com.compomics.util.experiment.filtering.FilterItem;
import com.compomics.util.experiment.filtering.FilterItemComparator;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.features.IdentificationFeaturesGenerator;
import com.compomics.util.experiment.identification.filtering.MatchFilter;
import com.compomics.util.experiment.identification.filtering.items.ProteinFilterItem;
import com.compomics.util.experiment.identification.matches.ProteinMatch;
import com.compomics.util.experiment.identification.peptide_shaker.PSModificationScores;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.identification.validation.MatchValidationLevel;
import com.compomics.util.experiment.io.biology.protein.ProteinDetailsProvider;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.parameters.identification.IdentificationParameters;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

public class ProteinFilter
extends MatchFilter {
    static final long serialVersionUID = 5753850468907866679L;

    public ProteinFilter() {
    }

    public ProteinFilter(String name) {
        this.name = name;
        this.filterType = MatchFilter.FilterType.PROTEIN;
    }

    public ProteinFilter(String name, String description) {
        this.name = name;
        this.description = description;
        this.filterType = MatchFilter.FilterType.PROTEIN;
    }

    public ProteinFilter(String name, String description, String condition, String reportPassed, String reportFailed) {
        this.name = name;
        this.description = description;
        this.condition = condition;
        this.reportPassed = reportPassed;
        this.reportFailed = reportFailed;
        this.filterType = MatchFilter.FilterType.PROTEIN;
    }

    @Override
    protected MatchFilter getNew() {
        return new ProteinFilter();
    }

    @Override
    public boolean isValidated(String itemName, FilterItemComparator filterItemComparator, Object value, long matchKey, Identification identification, GeneMaps geneMaps, IdentificationFeaturesGenerator identificationFeaturesGenerator, IdentificationParameters identificationParameters, SequenceProvider sequenceProvider, ProteinDetailsProvider proteinDetailsProvider, SpectrumProvider spectrumProvider) {
        ProteinFilterItem filterItem = ProteinFilterItem.getItem(itemName);
        if (filterItem == null) {
            throw new IllegalArgumentException("Filter item " + itemName + "not recognized as protein filter item.");
        }
        String input = value.toString();
        switch (filterItem) {
            case proteinAccession: {
                ProteinMatch proteinMatch = identification.getProteinMatch(matchKey);
                return filterItemComparator.passes(input, proteinMatch.getAccessions());
            }
            case proteinDescription: {
                ProteinMatch proteinMatch = identification.getProteinMatch(matchKey);
                return filterItemComparator.passes(input, (String[])Arrays.stream(proteinMatch.getAccessions()).map(accession -> proteinDetailsProvider.getDescription((String)accession)).toArray(String[]::new));
            }
            case sequence: {
                ProteinMatch proteinMatch = identification.getProteinMatch(matchKey);
                return filterItemComparator.passes(input, (String[])Arrays.stream(proteinMatch.getAccessions()).map(accession -> sequenceProvider.getSequence((String)accession)).toArray(String[]::new));
            }
            case chromosome: {
                ProteinMatch proteinMatch = identification.getProteinMatch(matchKey);
                return filterItemComparator.passes(input, (String[])Arrays.stream(proteinMatch.getAccessions()).map(accession -> geneMaps.getChromosome(proteinDetailsProvider.getGeneName((String)accession))).toArray(String[]::new));
            }
            case gene: {
                ProteinMatch proteinMatch = identification.getProteinMatch(matchKey);
                return filterItemComparator.passes(input, (String[])Arrays.stream(proteinMatch.getAccessions()).map(accession -> proteinDetailsProvider.getGeneName((String)accession)).toArray(String[]::new));
            }
            case GO: {
                ProteinMatch proteinMatch = identification.getProteinMatch(matchKey);
                return filterItemComparator.passes(input, (String[])Arrays.stream(proteinMatch.getAccessions()).flatMap(accession -> geneMaps.getGoNamesForProtein((String)accession).stream()).toArray(String[]::new));
            }
            case expectedCoverage: {
                double coverage = 100.0 * identificationFeaturesGenerator.getObservableCoverage(matchKey);
                return filterItemComparator.passes(input, coverage);
            }
            case validatedCoverage: {
                double coverage = 100.0 * identificationFeaturesGenerator.getValidatedSequenceCoverage(matchKey);
                return filterItemComparator.passes(input, coverage);
            }
            case confidentCoverage: {
                HashMap<Integer, Double> sequenceCoverage = identificationFeaturesGenerator.getSequenceCoverage(matchKey);
                double coverage = 100.0 * sequenceCoverage.get(MatchValidationLevel.confident.getIndex());
                return filterItemComparator.passes(input, coverage);
            }
            case spectrumCounting: {
                double spectrumCounting = identificationFeaturesGenerator.getSpectrumCounting(matchKey);
                return filterItemComparator.passes(input, spectrumCounting);
            }
            case modification: {
                ProteinMatch proteinMatch = identification.getProteinMatch(matchKey);
                PSModificationScores modificationScores = (PSModificationScores)proteinMatch.getUrParam(PSModificationScores.dummy);
                HashSet<String> modifications = modificationScores == null ? new HashSet(0) : modificationScores.getScoredModifications();
                return filterItemComparator.passes(input, modifications);
            }
            case nPeptides: {
                ProteinMatch proteinMatch = identification.getProteinMatch(matchKey);
                int nPeptides = proteinMatch.getPeptideCount();
                return filterItemComparator.passes(input, nPeptides);
            }
            case nValidatedPeptides: {
                int nPeptides = identificationFeaturesGenerator.getNValidatedPeptides(matchKey);
                return filterItemComparator.passes(input, nPeptides);
            }
            case nConfidentPeptides: {
                int nPeptides = identificationFeaturesGenerator.getNConfidentPeptides(matchKey);
                return filterItemComparator.passes(input, nPeptides);
            }
            case nPSMs: {
                int nPsms = identificationFeaturesGenerator.getNSpectra(matchKey);
                return filterItemComparator.passes(input, nPsms);
            }
            case nValidatedPSMs: {
                int nPsms = identificationFeaturesGenerator.getNValidatedSpectra(matchKey);
                return filterItemComparator.passes(input, nPsms);
            }
            case nConfidentPSMs: {
                int nPsms = identificationFeaturesGenerator.getNConfidentSpectra(matchKey);
                return filterItemComparator.passes(input, nPsms);
            }
            case confidence: {
                ProteinMatch proteinMatch = identification.getProteinMatch(matchKey);
                PSParameter psParameter = (PSParameter)proteinMatch.getUrParam(PSParameter.dummy);
                double confidence = psParameter.getConfidence();
                return filterItemComparator.passes(input, confidence);
            }
            case proteinInference: {
                ProteinMatch proteinMatch = identification.getProteinMatch(matchKey);
                PSParameter psParameter = (PSParameter)proteinMatch.getUrParam(PSParameter.dummy);
                int pi = psParameter.getProteinInferenceGroupClass();
                return filterItemComparator.passes(input, pi);
            }
            case validationStatus: {
                ProteinMatch proteinMatch = identification.getProteinMatch(matchKey);
                PSParameter psParameter = (PSParameter)proteinMatch.getUrParam(PSParameter.dummy);
                int validation = psParameter.getMatchValidationLevel().getIndex();
                return filterItemComparator.passes(Double.toString(MatchValidationLevel.getMatchValidationLevel(input).getIndex()), validation);
            }
            case stared: {
                ProteinMatch proteinMatch = identification.getProteinMatch(matchKey);
                PSParameter psParameter = (PSParameter)proteinMatch.getUrParam(PSParameter.dummy);
                String starred = psParameter.getStarred() ? FilterItemComparator.trueFalse[0] : FilterItemComparator.trueFalse[1];
                return filterItemComparator.passes(input, starred);
            }
        }
        throw new IllegalArgumentException("Protein filter not implemented for item " + filterItem.name + ".");
    }

    @Override
    public FilterItem[] getPossibleFilterItems() {
        return ProteinFilterItem.values();
    }

    @Override
    public FilterItem getFilterItem(String itemName) {
        return ProteinFilterItem.getItem(itemName);
    }
}

