/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.matches;

import com.compomics.util.experiment.biology.atoms.Atom;
import com.compomics.util.experiment.biology.ions.Charge;
import com.compomics.util.experiment.biology.ions.Ion;
import com.compomics.util.experiment.biology.ions.impl.ElementaryIon;
import com.compomics.util.experiment.biology.ions.impl.PeptideFragmentIon;
import com.compomics.util.experiment.biology.ions.impl.TagFragmentIon;
import com.compomics.util.experiment.identification.spectrum_annotation.IonMatchKeysCache;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.pride.CvTerm;

public class IonMatch
extends ExperimentObject {
    public double peakMz;
    public double peakIntensity;
    public Ion ion;
    public int charge;

    public IonMatch() {
    }

    public IonMatch(double peakMz, double peakIntensity, Ion ion, int charge) {
        this.peakMz = peakMz;
        this.peakIntensity = peakIntensity;
        this.ion = ion;
        this.charge = charge;
    }

    public double getAbsoluteError() {
        double theoreticMz = this.ion.getTheoreticMz(this.charge);
        return this.peakMz - theoreticMz;
    }

    public double getAbsoluteError(int minIsotope, int maxIsotope) {
        double theoreticMz = this.ion.getTheoreticMz(this.charge);
        double measuredMz = this.peakMz;
        return (measuredMz -= (double)this.getIsotopeNumber(minIsotope, maxIsotope) * Atom.C.getDifferenceToMonoisotopic(1) / (double)this.charge) - theoreticMz;
    }

    public double getRelativeError() {
        double theoreticMz = this.ion.getTheoreticMz(this.charge);
        return (this.peakMz - theoreticMz) * 1000000.0 / theoreticMz;
    }

    public double getRelativeError(int minIsotope, int maxIsotope) {
        double theoreticMz = this.ion.getTheoreticMz(this.charge);
        double measuredMz = this.peakMz;
        return ((measuredMz -= (double)this.getIsotopeNumber(minIsotope, maxIsotope) * Atom.C.getDifferenceToMonoisotopic(1) / (double)this.charge) - theoreticMz) * 1000000.0 / theoreticMz;
    }

    public int getIsotopeNumber(int minIsotope, int maxIsotope) {
        double experimentalMass = this.peakMz * (double)this.charge - (double)this.charge * ElementaryIon.proton.getTheoreticMass();
        double result = (experimentalMass - this.ion.getTheoreticMass()) / Atom.C.getDifferenceToMonoisotopic(1);
        return Math.min(Math.max((int)Math.round(result), minIsotope), maxIsotope);
    }

    public double getError(boolean isPpm, int minIsotope, int maxIsotope) {
        return isPpm ? this.getRelativeError(minIsotope, maxIsotope) : this.getAbsoluteError(minIsotope, maxIsotope);
    }

    public double getError(boolean isPpm) {
        return isPpm ? this.getRelativeError() : this.getAbsoluteError();
    }

    public String getPeakAnnotation() {
        return IonMatch.getPeakAnnotation(false, this.ion, this.charge);
    }

    public static String getPeakAnnotation(Ion ion, int charge) {
        return IonMatch.getPeakAnnotation(false, ion, charge);
    }

    public static String getMatchKey(Ion ion, int charge) {
        return IonMatch.getMatchKey(ion, charge, null);
    }

    public static String getMatchKey(Ion ion, int charge, IonMatchKeysCache ionMatchKeysCache) {
        int fragmentIonNumber;
        if (ionMatchKeysCache != null) {
            return ionMatchKeysCache.getMatchKey(ion, charge);
        }
        Ion.IonType ionType = ion.getType();
        int ionTypeIndex = ionType.index;
        int ionSubType = ion.getSubType();
        switch (ionType) {
            case PEPTIDE_FRAGMENT_ION: {
                PeptideFragmentIon fragmentIon = (PeptideFragmentIon)ion;
                fragmentIonNumber = fragmentIon.getNumber();
                break;
            }
            case TAG_FRAGMENT_ION: {
                TagFragmentIon tagFragmentIon = (TagFragmentIon)ion;
                fragmentIonNumber = tagFragmentIon.getNumber();
                break;
            }
            default: {
                fragmentIonNumber = 0;
            }
        }
        String neutralLossesAsString = ion.getNeutralLossesAsString();
        String key = IonMatch.getMatchKey(ionTypeIndex, ionSubType, fragmentIonNumber, neutralLossesAsString, charge);
        return key;
    }

    public static String getMatchKey(int ionTypeIndex, int ionSubType, int fragmentIonNumber, String neutralLossesAsString, int charge) {
        StringBuilder stringBuilder = new StringBuilder(8);
        stringBuilder.append(ionTypeIndex).append("_").append(ionSubType).append("_").append(fragmentIonNumber).append("_").append(neutralLossesAsString).append("_").append(charge);
        return stringBuilder.toString();
    }

    public static String getPeakAnnotation(boolean html, Ion ion, int charge) {
        StringBuilder result = new StringBuilder();
        switch (ion.getType()) {
            case PEPTIDE_FRAGMENT_ION: {
                if (html) {
                    result.append("<html>");
                }
                result.append(ion.getSubTypeAsString());
                PeptideFragmentIon fragmentIon = (PeptideFragmentIon)ion;
                if (html) {
                    result.append("<sub>").append(fragmentIon.getNumber()).append("</sub>");
                } else {
                    result.append(fragmentIon.getNumber());
                }
                if (html) {
                    String neutralLoss = ion.getNeutralLossesAsString();
                    for (int i = 0; i < neutralLoss.length(); ++i) {
                        if (Character.isDigit(neutralLoss.charAt(i))) {
                            result.append("<sub>").append(neutralLoss.charAt(i)).append("</sub>");
                            continue;
                        }
                        result.append(neutralLoss.charAt(i));
                    }
                } else {
                    result.append(ion.getNeutralLossesAsString());
                }
                result.append(Charge.getChargeAsFormattedString(charge));
                if (html) {
                    result.append("</html>");
                }
                return result.toString();
            }
            case TAG_FRAGMENT_ION: {
                TagFragmentIon tagFragmentIon = (TagFragmentIon)ion;
                if (html) {
                    result.append("<html>");
                }
                result.append(ion.getSubTypeAsString());
                if (html) {
                    result.append("<sub>").append(tagFragmentIon.getSubNumber()).append("</sub>");
                } else {
                    result.append(tagFragmentIon.getSubNumber());
                }
                result.append(Charge.getChargeAsFormattedString(charge));
                if (html) {
                    String neutralLoss = ion.getNeutralLossesAsString();
                    for (int i = 0; i < neutralLoss.length(); ++i) {
                        if (Character.isDigit(neutralLoss.charAt(i))) {
                            result.append("<sub>").append(neutralLoss.charAt(i)).append("</sub>");
                            continue;
                        }
                        result.append(neutralLoss.charAt(i));
                    }
                } else {
                    result.append(ion.getNeutralLossesAsString());
                }
                if (html) {
                    result.append("</html>");
                }
                return result.toString();
            }
            case PRECURSOR_ION: {
                if (html) {
                    result.append("<html>");
                }
                result.append(ion.getSubTypeAsString()).append("-");
                result.append(Charge.getChargeAsFormattedString(charge));
                String neutralLoss = ion.getNeutralLossesAsString();
                if (html) {
                    for (int i = 0; i < neutralLoss.length(); ++i) {
                        if (Character.isDigit(neutralLoss.charAt(i))) {
                            result.append("<sub>").append(neutralLoss.charAt(i)).append("</sub>");
                            continue;
                        }
                        result.append(neutralLoss.charAt(i));
                    }
                } else {
                    result.append(neutralLoss);
                }
                if (html) {
                    result.append("</html>");
                }
                return result.toString();
            }
        }
        if (html) {
            result.append("<html>");
        }
        result.append(ion.getName());
        if (html) {
            result.append("</html>");
        }
        return result.toString();
    }

    public String getPeakAnnotation(boolean html) {
        return IonMatch.getPeakAnnotation(html, this.ion, this.charge);
    }

    public CvTerm getMZPrideCvTerm() {
        return new CvTerm("PRIDE", "PRIDE:0000188", "product ion m/z", Double.toString(this.peakMz));
    }

    public CvTerm getIntensityPrideCvTerm() {
        return new CvTerm("PRIDE", "PRIDE:0000189", "product ion intensity", Double.toString(this.peakIntensity));
    }

    public CvTerm getIonMassErrorPrideCvTerm(int minIsotope, int maxIsotope) {
        return new CvTerm("PRIDE", "PRIDE:0000190", "product ion mass error", Double.toString(this.getAbsoluteError(minIsotope, maxIsotope)));
    }

    public CvTerm getChargePrideCvTerm() {
        return new CvTerm("PRIDE", "PRIDE:0000204", "product ion charge", Integer.toString(this.charge));
    }

    public static enum MzErrorType {
        Absolute("Absolute", "Absolute error", "m/z"),
        RelativePpm("Relative (ppm)", "Relative error in ppm", "ppm"),
        Statistical("Statistical", "Probability to reach this error according to the error distribution", "%p");

        public final String name;
        public final String description;
        public final String unit;

        private MzErrorType(String name, String description, String unit) {
            this.name = name;
            this.description = description;
            this.unit = unit;
        }

        public static MzErrorType getMzErrorType(int index) {
            MzErrorType[] values = MzErrorType.values();
            if (index >= 0 && index < values.length) {
                return values[index];
            }
            return null;
        }
    }
}

