/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.matches;

import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.IdentificationMatch;
import java.util.Arrays;

public class PeptideMatch
extends IdentificationMatch {
    private Peptide peptide;
    private long key;
    private long[] spectrumMatchesKeys;

    @Override
    public long getKey() {
        return this.key;
    }

    public void setKey(long newKey) {
        this.key = newKey;
    }

    public PeptideMatch() {
    }

    public PeptideMatch(Peptide peptide, long matchKey, long spectrumMatchKey) {
        this.peptide = peptide;
        this.key = matchKey;
        this.spectrumMatchesKeys = new long[1];
        this.spectrumMatchesKeys[0] = spectrumMatchKey;
    }

    public Peptide getPeptide() {
        return this.peptide;
    }

    public void setPeptide(Peptide peptide) {
        this.peptide = peptide;
    }

    public long[] getSpectrumMatchesKeys() {
        return this.spectrumMatchesKeys;
    }

    public void setSpectrumMatchesKeys(long[] spectrumMatchesKeys) {
        this.spectrumMatchesKeys = spectrumMatchesKeys;
    }

    public void addSpectrumMatchKey(long spectrumMatchKey) {
        this.spectrumMatchesKeys = Arrays.copyOf(this.spectrumMatchesKeys, this.spectrumMatchesKeys.length + 1);
        this.spectrumMatchesKeys[this.spectrumMatchesKeys.length - 1] = spectrumMatchKey;
    }

    public int getSpectrumCount() {
        return this.spectrumMatchesKeys.length;
    }

    @Override
    public IdentificationMatch.MatchType getType() {
        return IdentificationMatch.MatchType.Peptide;
    }
}

