/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.matches;

import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.IdentificationMatch;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.personalization.ExperimentObject;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.LongStream;

public class ProteinMatch
extends IdentificationMatch {
    static final long serialVersionUID = -6061842447053092696L;
    private String[] accessions;
    private String leadingAccession;
    private long[] peptideMatchesKeys = new long[0];
    private long matchKey;
    private boolean decoy;
    private ModificationMatch[] variableModifications = null;

    public ProteinMatch() {
    }

    public ProteinMatch(String proteinAccession) {
        this.accessions = new String[1];
        this.accessions[0] = proteinAccession;
        this.setMatchKey();
        this.leadingAccession = proteinAccession;
    }

    public ProteinMatch(Peptide peptide, long peptideMatchKey) {
        this.accessions = peptide.getProteinMapping().navigableKeySet().toArray(new String[peptide.getProteinMapping().size()]);
        this.leadingAccession = this.accessions[0];
        this.peptideMatchesKeys = new long[1];
        this.peptideMatchesKeys[0] = peptideMatchKey;
        this.setMatchKey();
    }

    public void setAccessions(String[] newAccessions) {
        this.accessions = newAccessions;
        this.leadingAccession = this.accessions[0];
        this.setMatchKey();
    }

    public String[] getAccessions() {
        return this.accessions;
    }

    public String getLeadingAccession() {
        return this.leadingAccession;
    }

    public void setLeadingAccession(String leadingAccession) {
        this.leadingAccession = leadingAccession;
    }

    public boolean isDecoy() {
        return this.decoy;
    }

    public void setDecoy(boolean decoy) {
        this.decoy = decoy;
    }

    public long[] getPeptideMatchesKeys() {
        return this.peptideMatchesKeys;
    }

    public void addPeptideMatchKey(long peptideMatchKey) {
        this.peptideMatchesKeys = Arrays.copyOf(this.peptideMatchesKeys, this.peptideMatchesKeys.length + 1);
        this.peptideMatchesKeys[this.peptideMatchesKeys.length - 1] = peptideMatchKey;
    }

    public void addPeptideMatchKeys(long[] newKeys) {
        this.peptideMatchesKeys = LongStream.concat(Arrays.stream(this.peptideMatchesKeys), Arrays.stream(newKeys)).distinct().toArray();
    }

    public void setPeptideMatchesKeys(long[] peptideMatchKeys) {
        this.peptideMatchesKeys = peptideMatchKeys;
    }

    public int getPeptideCount() {
        return this.peptideMatchesKeys.length;
    }

    @Override
    public long getKey() {
        return this.matchKey;
    }

    private void setMatchKey() {
        this.matchKey = ExperimentObject.asLong(Arrays.stream(this.accessions).collect(Collectors.joining()));
    }

    public static long getProteinMatchKey(Peptide peptide) {
        return ExperimentObject.asLong(peptide.getProteinMapping().navigableKeySet().stream().collect(Collectors.joining()));
    }

    public int getNProteins() {
        return this.accessions.length;
    }

    public boolean contains(String aProtein) {
        return Arrays.stream(this.accessions).anyMatch(accession -> accession.equals(aProtein));
    }

    public boolean containsPeptide(long peptideKey) {
        return Arrays.stream(this.peptideMatchesKeys).anyMatch(key -> key == peptideKey);
    }

    public ModificationMatch[] getVariableModifications() {
        return this.variableModifications == null ? ModificationMatch.NO_MOD : this.variableModifications;
    }

    public void setVariableModifications(ModificationMatch[] variableModifications) {
        this.variableModifications = variableModifications;
    }

    @Override
    public IdentificationMatch.MatchType getType() {
        return IdentificationMatch.MatchType.Protein;
    }
}

