/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.matches;

import com.compomics.util.experiment.identification.IdentificationMatch;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.identification.spectrum_assumptions.TagAssumption;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.io.IoUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeMap;
import java.util.stream.Stream;

public class SpectrumMatch
extends IdentificationMatch {
    private long key;
    private String spectrumFile;
    private String spectrumtitle;
    private HashMap<Integer, TreeMap<Double, ArrayList<PeptideAssumption>>> peptideAssumptionsMap = new HashMap(0);
    private PeptideAssumption bestPeptideAssumption;
    private HashMap<Integer, TreeMap<Double, ArrayList<TagAssumption>>> tagAssumptionsMap = new HashMap(0);
    private TagAssumption bestTagAssumption;

    public SpectrumMatch() {
    }

    public void setPeptideAssumptionMap(HashMap<Integer, TreeMap<Double, ArrayList<PeptideAssumption>>> peptideAssumptionsMap) {
        this.peptideAssumptionsMap = peptideAssumptionsMap;
    }

    public void setTagAssumptionMap(HashMap<Integer, TreeMap<Double, ArrayList<TagAssumption>>> tagAssumptionsMap) {
        this.tagAssumptionsMap = tagAssumptionsMap;
    }

    public SpectrumMatch(String spectrumFile, String spectrumTitle) {
        this.spectrumFile = IoUtil.removeExtension(spectrumFile);
        this.spectrumtitle = spectrumTitle;
        this.key = SpectrumMatch.getKey(this.spectrumFile, spectrumTitle);
    }

    public static long getKey(String spectrumFile, String spectrumTitle) {
        return ExperimentObject.asLong(String.join((CharSequence)"", IoUtil.removeExtension(spectrumFile), spectrumTitle));
    }

    public PeptideAssumption getBestPeptideAssumption() {
        return this.bestPeptideAssumption;
    }

    public void setBestPeptideAssumption(PeptideAssumption bestPeptideAssumption) {
        this.bestPeptideAssumption = bestPeptideAssumption;
    }

    public TagAssumption getBestTagAssumption() {
        return this.bestTagAssumption;
    }

    public void setBestTagAssumption(TagAssumption bestTagAssumption) {
        this.bestTagAssumption = bestTagAssumption;
    }

    public String getSpectrumFile() {
        return this.spectrumFile;
    }

    public void setSpectrumFile(String spectrumFile) {
        this.spectrumFile = IoUtil.removeExtension(spectrumFile);
    }

    public String getSpectrumTitle() {
        return this.spectrumtitle;
    }

    public void setSpectrumTitle(String spectrumTitle) {
        this.spectrumtitle = spectrumTitle;
        this.key = SpectrumMatch.getKey(this.spectrumFile, spectrumTitle);
    }

    @Override
    public long getKey() {
        return this.key;
    }

    public HashSet<Integer> getAdvocates() {
        HashSet<Integer> result = new HashSet<Integer>(0);
        if (this.peptideAssumptionsMap != null) {
            result.addAll(this.peptideAssumptionsMap.keySet());
        }
        if (this.tagAssumptionsMap != null) {
            result.addAll(this.tagAssumptionsMap.keySet());
        }
        return result;
    }

    public TreeMap<Double, ArrayList<PeptideAssumption>> getAllPeptideAssumptions(int advocateId) {
        return this.peptideAssumptionsMap.get(advocateId);
    }

    public TreeMap<Double, ArrayList<TagAssumption>> getAllTagAssumptions(int advocateId) {
        return this.tagAssumptionsMap.get(advocateId);
    }

    public Stream<PeptideAssumption> getAllPeptideAssumptions() {
        return this.peptideAssumptionsMap.values().stream().flatMap(algorithmMap -> algorithmMap.values().stream()).flatMap(assumptionsList -> assumptionsList.stream());
    }

    public Stream<TagAssumption> getAllTagAssumptions() {
        return this.tagAssumptionsMap.values().stream().flatMap(algorithmMap -> algorithmMap.values().stream()).flatMap(assumptionsList -> assumptionsList.stream());
    }

    public HashMap<Integer, TreeMap<Double, ArrayList<PeptideAssumption>>> getPeptideAssumptionsMap() {
        return this.peptideAssumptionsMap;
    }

    public HashMap<Integer, TreeMap<Double, ArrayList<TagAssumption>>> getTagAssumptionsMap() {
        return this.tagAssumptionsMap;
    }

    public void addPeptideAssumption(int advocateId, PeptideAssumption peptideAssumption) {
        Double score;
        ArrayList<PeptideAssumption> assumptionList;
        TreeMap<Double, ArrayList<PeptideAssumption>> advocateMap = this.peptideAssumptionsMap.get(advocateId);
        if (advocateMap == null) {
            advocateMap = new TreeMap();
            this.peptideAssumptionsMap.put(advocateId, advocateMap);
        }
        if ((assumptionList = advocateMap.get(score = Double.valueOf(peptideAssumption.getScore()))) == null) {
            assumptionList = new ArrayList(1);
            advocateMap.put(score, assumptionList);
        }
        assumptionList.add(peptideAssumption);
    }

    public void addTagAssumption(int advocateId, TagAssumption tagAssumption) {
        double score;
        ArrayList<TagAssumption> assumptionList;
        TreeMap<Double, ArrayList<TagAssumption>> advocateMap = this.tagAssumptionsMap.get(advocateId);
        if (advocateMap == null) {
            advocateMap = new TreeMap();
            this.tagAssumptionsMap.put(advocateId, advocateMap);
        }
        if ((assumptionList = advocateMap.get(score = tagAssumption.getScore())) == null) {
            assumptionList = new ArrayList(1);
            advocateMap.put(score, assumptionList);
        }
        assumptionList.add(tagAssumption);
    }

    @Override
    public IdentificationMatch.MatchType getType() {
        return IdentificationMatch.MatchType.Spectrum;
    }

    public void removePeptideAssumption(PeptideAssumption peptideAssumption) {
        int se = peptideAssumption.getAdvocate();
        TreeMap<Double, ArrayList<PeptideAssumption>> algorithmMap = this.peptideAssumptionsMap.get(se);
        ArrayList<PeptideAssumption> assumptionsList = algorithmMap.get(peptideAssumption.getScore());
        assumptionsList.remove(peptideAssumption);
        if (assumptionsList.isEmpty()) {
            algorithmMap.remove(peptideAssumption.getScore());
        }
        if (algorithmMap.isEmpty()) {
            this.peptideAssumptionsMap.remove(se);
        }
    }

    public void removeTagAssumption(TagAssumption tagAssumption) {
        int se = tagAssumption.getAdvocate();
        TreeMap<Double, ArrayList<TagAssumption>> algorithmMap = this.tagAssumptionsMap.get(se);
        ArrayList<TagAssumption> assumptionsList = algorithmMap.get(tagAssumption.getScore());
        assumptionsList.remove(tagAssumption);
        if (assumptionsList.isEmpty()) {
            algorithmMap.remove(tagAssumption.getScore());
        }
        if (algorithmMap.isEmpty()) {
            this.tagAssumptionsMap.remove(se);
        }
    }

    public boolean hasPeptideAssumption() {
        return this.peptideAssumptionsMap.values().stream().flatMap(algorithmMap -> algorithmMap.values().stream()).anyMatch(assumptionsList -> !assumptionsList.isEmpty());
    }

    public boolean hasTagAssumption() {
        return this.tagAssumptionsMap.values().stream().flatMap(algorithmMap -> algorithmMap.values().stream()).anyMatch(assumptionsList -> !assumptionsList.isEmpty());
    }

    public boolean hasPeptideAssumption(int advocateId) {
        TreeMap<Double, ArrayList<PeptideAssumption>> algorithmIds = this.peptideAssumptionsMap.get(advocateId);
        return algorithmIds == null ? false : algorithmIds.values().stream().anyMatch(assumptions -> !assumptions.isEmpty());
    }

    public boolean hasTagAssumption(int advocateId) {
        TreeMap<Double, ArrayList<TagAssumption>> algorithmIds = this.tagAssumptionsMap.get(advocateId);
        return algorithmIds == null ? false : algorithmIds.values().stream().anyMatch(assumptions -> !assumptions.isEmpty());
    }
}

