/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.matches_iterators;

import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.waiting.WaitingHandler;
import java.util.ArrayList;
import java.util.concurrent.Semaphore;

public abstract class MatchesIterator {
    private Identification identification = null;
    private long[] keys = null;
    private int index = 0;
    private int num = 0;
    private WaitingHandler waitingHandler;
    private boolean displayProgress;
    private ArrayList<Long> longKeys = null;
    private final Semaphore nextMutex = new Semaphore(1);

    public MatchesIterator(Class className, Identification identification, WaitingHandler waitingHandler, boolean displayProgress) {
        this(null, className, identification, waitingHandler, displayProgress, null);
    }

    public MatchesIterator(long[] keys, Class className, Identification identification, WaitingHandler waitingHandler, boolean displayProgress, String filters) {
        if (keys != null) {
            this.num = keys.length;
            this.keys = keys;
        } else {
            this.longKeys = new ArrayList<Long>(identification.getClassObjects(className, filters));
            this.num = this.longKeys.size();
        }
        this.index = 0;
        this.identification = identification;
        this.waitingHandler = waitingHandler;
        this.displayProgress = displayProgress;
    }

    public Object nextObject() {
        if (this.waitingHandler != null && this.waitingHandler.isRunCanceled()) {
            return null;
        }
        Object obj = null;
        int currentIndex = this.getIndex();
        if (currentIndex < this.num) {
            obj = this.keys == null ? this.identification.retrieveObject(this.longKeys.get(currentIndex)) : this.identification.retrieveObject(this.keys[currentIndex]);
        }
        return obj;
    }

    private int getIndex() {
        try {
            this.nextMutex.acquire();
            int currentIndex = this.index++;
            this.nextMutex.release();
            return currentIndex;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

