/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.modification.peptide_mapping.performance;

import com.compomics.util.experiment.identification.modification.peptide_mapping.ModificationPeptideMapping;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;

public class PerformanceBenchmarkRunnable
implements Runnable {
    private final Random random = new Random(29122022L);
    public static final int SEED = 29122022;
    public static final int PEPTIDE_LENGTH = 30;
    public int failedPeptides = 0;
    private ArrayList<HashMap[]> inputs = new ArrayList();

    public PerformanceBenchmarkRunnable(int nPeptides, Integer nMods, Integer nPossible, Integer nOccupied) {
        this.inputs = new ArrayList(nPeptides);
        for (int i = 0; i < nPeptides; ++i) {
            HashMap[] methodInput = this.getMethodInput(nMods, nPossible, nOccupied);
            this.inputs.add(methodInput);
        }
    }

    @Override
    public void run() {
        try {
            for (HashMap[] methodInput : this.inputs) {
                HashMap modificationToPossibleSiteMap = methodInput[0];
                HashMap modificationOccurrenceMap = methodInput[1];
                HashMap modificationToSiteToScore = methodInput[2];
                try {
                    ModificationPeptideMapping.mapModifications(modificationToPossibleSiteMap, modificationOccurrenceMap, modificationToSiteToScore);
                }
                catch (Exception e) {
                    ++this.failedPeptides;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private HashMap[] getMethodInput(Integer nMods, Integer nPossible, Integer nOccupied) {
        if (nMods == null) {
            nMods = this.random.nextInt(10) + 1;
        }
        HashMap<Double, int[]> modificationToPossibleSiteMap = new HashMap<Double, int[]>(nMods);
        HashMap<Double, Integer> modificationOccurrenceMap = new HashMap<Double, Integer>(nMods);
        HashMap modificationToSiteToScore = new HashMap(nMods);
        for (int modIndex = 0; modIndex < nMods; ++modIndex) {
            int nModPossible;
            double modMass = modIndex;
            int n = nModPossible = nPossible == null ? this.random.nextInt(6) + 1 : nPossible;
            if (nModPossible > 30) {
                throw new IllegalArgumentException("nModPossible > PEPTIDE_LENGTH");
            }
            int nModOccupied = nOccupied == null ? this.random.nextInt(nModPossible) + 1 : nOccupied;
            modificationOccurrenceMap.put(modMass, nModOccupied);
            int[] possibleSites = new int[nModPossible];
            HashSet<Integer> sitesTaken = new HashSet<Integer>(nModPossible);
            for (int i = 0; i < nModPossible; ++i) {
                int site = this.random.nextInt(30);
                while (sitesTaken.contains(site)) {
                    site = this.random.nextInt(30);
                }
                possibleSites[i] = site;
                sitesTaken.add(site);
            }
            modificationToPossibleSiteMap.put(modMass, possibleSites);
            HashMap<Integer, Double> siteToScore = new HashMap<Integer, Double>(nModPossible);
            for (int site : possibleSites) {
                siteToScore.put(site, this.random.nextDouble());
            }
            modificationToSiteToScore.put(modMass, siteToScore);
        }
        return new HashMap[]{modificationToPossibleSiteMap, modificationOccurrenceMap, modificationToSiteToScore};
    }
}

