/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.modification.search_engine_mapping;

import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationProvider;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.modification.peptide_mapping.ModificationPeptideMapping;
import com.compomics.util.experiment.identification.modification.search_engine_mapping.ModificationMassMapper;
import com.compomics.util.experiment.identification.modification.search_engine_mapping.ModificationNameMapper;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.io.identification.IdfileReader;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;

public class ModificationLocalizationMapper {
    public static void modificationLocalization(Peptide peptide, IdentificationParameters identificationParameters, IdfileReader idfileReader, ModificationProvider modificationProvider, SequenceProvider sequenceProvider) {
        HashMap possibleSites;
        ModificationMatch[] originalModifications;
        SearchParameters searchParameters = identificationParameters.getSearchParameters();
        SequenceMatchingParameters modificationSequenceMatchingParameters = identificationParameters.getModificationLocalizationParameters().getSequenceMatchingParameters();
        HashMap<Double, Integer> modificationOccurrenceMap = new HashMap<Double, Integer>(1);
        HashMap<Double, HashMap<Integer, Double>> modificationToSiteToScore = new HashMap<Double, HashMap<Integer, Double>>(1);
        HashMap<Double, HashMap> possibleModificationToPossibleSiteToName = new HashMap<Double, HashMap>(1);
        double maxDistance = peptide.getSequence().length();
        for (ModificationMatch modificationMatch : originalModifications = peptide.getVariableModifications()) {
            HashMap<Integer, HashSet<String>> tempNames;
            HashMap<Integer, Double> siteToScore;
            int modSite = modificationMatch.getSite();
            double searchEngineMass = ModificationMassMapper.getMass(modificationMatch.getModification(), idfileReader, searchParameters, modificationProvider);
            Integer occurrence = modificationOccurrenceMap.get(searchEngineMass);
            if (occurrence == null) {
                modificationOccurrenceMap.put(searchEngineMass, 1);
            } else {
                modificationOccurrenceMap.put(searchEngineMass, occurrence + 1);
            }
            possibleSites = (HashMap)possibleModificationToPossibleSiteToName.get(searchEngineMass);
            if (possibleSites == null) {
                possibleSites = new HashMap(1);
                possibleModificationToPossibleSiteToName.put(searchEngineMass, possibleSites);
            }
            if ((siteToScore = modificationToSiteToScore.get(searchEngineMass)) == null) {
                siteToScore = new HashMap(1);
                modificationToSiteToScore.put(searchEngineMass, siteToScore);
            }
            if ((tempNames = ModificationNameMapper.getPossibleModificationNames(peptide, modificationMatch, idfileReader, searchParameters, modificationSequenceMatchingParameters, sequenceProvider, modificationProvider)).isEmpty()) {
                throw new IllegalArgumentException("Could not map modification " + modificationMatch.getModification() + " on peptide " + peptide.getSequence() + ".");
            }
            for (Map.Entry<Integer, HashSet<String>> entry : tempNames.entrySet()) {
                int possibleSite = entry.getKey();
                for (String string : entry.getValue()) {
                    TreeSet<String> possibleModificationNames = (TreeSet<String>)possibleSites.get(possibleSite);
                    if (possibleModificationNames == null) {
                        possibleModificationNames = new TreeSet<String>();
                        possibleSites.put(possibleSite, possibleModificationNames);
                    }
                    possibleModificationNames.add(string);
                }
                double score = 1.0 - (double)((possibleSite - modSite) * (possibleSite - modSite)) / (maxDistance * maxDistance);
                siteToScore.put(possibleSite, score);
            }
        }
        HashMap<Double, int[]> modificationToPossibleSiteMap = new HashMap<Double, int[]>(possibleModificationToPossibleSiteToName.size());
        for (Map.Entry entry : possibleModificationToPossibleSiteToName.entrySet()) {
            int[] sites = ((HashMap)entry.getValue()).keySet().stream().mapToInt(a -> a).toArray();
            modificationToPossibleSiteMap.put((Double)entry.getKey(), sites);
        }
        HashMap<Double, TreeSet<Integer>> matchedSiteByModification = ModificationPeptideMapping.mapModifications(modificationToPossibleSiteMap, modificationOccurrenceMap, modificationToSiteToScore);
        ModificationMatch[] newModifications = new ModificationMatch[originalModifications.length];
        int modificationI = 0;
        for (Map.Entry<Double, TreeSet<Integer>> entry : matchedSiteByModification.entrySet()) {
            double searchEngineMass = entry.getKey();
            possibleSites = (HashMap)possibleModificationToPossibleSiteToName.get(searchEngineMass);
            for (int site : entry.getValue()) {
                ModificationMatch modificationMatch;
                TreeSet possibleNames = (TreeSet)possibleSites.get(site);
                String bestName = null;
                double massDifference = Double.NaN;
                for (String possibleName : possibleNames) {
                    Modification modification = modificationProvider.getModification(possibleName);
                    double currentMassDifference = Math.abs(modification.getMass() - searchEngineMass);
                    if (bestName != null && !(currentMassDifference < massDifference)) continue;
                    bestName = possibleName;
                    massDifference = currentMassDifference;
                }
                newModifications[modificationI] = modificationMatch = new ModificationMatch(bestName, site);
                ++modificationI;
            }
        }
        if (modificationI < originalModifications.length) {
            throw new IllegalArgumentException("Could map only " + modificationI + " in " + originalModifications.length + ".");
        }
        peptide.setVariableModifications(newModifications);
    }
}

