/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.protein_inference;

import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.PeptideVariantMatches;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class PeptideProteinMapping {
    private final String proteinAccession;
    private final String peptideSequence;
    private final int index;
    private final ModificationMatch[] modificationMatches;
    private final PeptideVariantMatches peptideVariantMatches;
    public int fmIndexPosition = 0;

    public PeptideProteinMapping() {
        this.proteinAccession = "";
        this.peptideSequence = "";
        this.index = 0;
        this.modificationMatches = null;
        this.peptideVariantMatches = null;
    }

    public PeptideProteinMapping(String proteinAccession, String peptideSequence, int index, ModificationMatch[] modificationMatches, PeptideVariantMatches peptideVariantMatches) {
        this.proteinAccession = proteinAccession;
        this.peptideSequence = peptideSequence;
        this.index = index;
        this.modificationMatches = modificationMatches;
        this.peptideVariantMatches = peptideVariantMatches;
    }

    public PeptideProteinMapping(String proteinAccession, String peptideSequence, int index) {
        this(proteinAccession, peptideSequence, index, null, null);
    }

    public PeptideProteinMapping(String proteinAccession, String peptideSequence, int index, ModificationMatch[] modificationMatches) {
        this(proteinAccession, peptideSequence, index, modificationMatches, null);
    }

    public String getProteinAccession() {
        return this.proteinAccession;
    }

    public String getPeptideSequence() {
        return this.peptideSequence;
    }

    public int getIndex() {
        return this.index;
    }

    public ModificationMatch[] getVariableModifications() {
        return this.modificationMatches;
    }

    public PeptideVariantMatches getPeptideVariantMatches() {
        return this.peptideVariantMatches;
    }

    public static HashMap<String, HashMap<String, int[]>> getPeptideProteinIndexesMap(ArrayList<PeptideProteinMapping> peptideProteinMappings) {
        return peptideProteinMappings.stream().collect(Collectors.groupingBy(PeptideProteinMapping::getPeptideSequence)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().collect(Collectors.groupingBy(PeptideProteinMapping::getProteinAccession)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry2 -> ((List)entry2.getValue()).stream().collect(Collectors.toCollection(HashSet::new)).stream().mapToInt(peptideProteinMapping -> peptideProteinMapping.getIndex()).sorted().toArray(), (a, b) -> {
            throw new IllegalStateException("Duplicate key in groupingBy.");
        }, HashMap::new)), (a, b) -> {
            throw new IllegalStateException("Duplicate key in groupingBy.");
        }, HashMap::new));
    }

    public static HashMap<String, HashSet<String>> getPeptideProteinMap(ArrayList<PeptideProteinMapping> peptideProteinMappings) {
        return peptideProteinMappings.stream().collect(Collectors.groupingBy(PeptideProteinMapping::getPeptideSequence)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().map(peptideProteinMapping -> peptideProteinMapping.getProteinAccession()).collect(Collectors.toCollection(HashSet::new)), (a, b) -> {
            throw new IllegalStateException("Duplicate key in groupingBy.");
        }, HashMap::new));
    }

    public static HashMap<String, HashMap<Integer, PeptideVariantMatches>> getVariantMatches(ArrayList<PeptideProteinMapping> peptideProteinMappings) {
        HashMap<String, HashMap<Integer, PeptideVariantMatches>> result = new HashMap<String, HashMap<Integer, PeptideVariantMatches>>(0);
        for (PeptideProteinMapping peptideProteinMapping : peptideProteinMappings) {
            if (peptideProteinMapping.getPeptideVariantMatches() == null) continue;
            String proteinAccession = peptideProteinMapping.getProteinAccession();
            HashMap<Integer, PeptideVariantMatches> variantIndex = result.get(proteinAccession);
            if (variantIndex == null) {
                variantIndex = new HashMap(1);
                result.put(proteinAccession, variantIndex);
            }
            int peptideIndex = peptideProteinMapping.getIndex();
            variantIndex.put(peptideIndex, peptideProteinMapping.getPeptideVariantMatches());
        }
        return result.isEmpty() ? null : result;
    }

    public static Collection<Peptide> getPeptides(ArrayList<PeptideProteinMapping> peptideProteinMappings, SequenceMatchingParameters sequenceMatchingPreferences) {
        HashMap<Long, Peptide> peptidesMap = new HashMap<Long, Peptide>(peptideProteinMappings.size());
        HashMap proteinsMap = new HashMap(peptideProteinMappings.size());
        HashMap variantsMap = new HashMap(peptideProteinMappings.size());
        for (PeptideProteinMapping peptideProteinMapping : peptideProteinMappings) {
            Peptide tempPeptide = new Peptide(peptideProteinMapping.getPeptideSequence(), peptideProteinMapping.getVariableModifications());
            long peptideKey = tempPeptide.getMatchingKey(sequenceMatchingPreferences);
            Peptide peptide = (Peptide)peptidesMap.get(peptideKey);
            String proteinAccession = peptideProteinMapping.getProteinAccession();
            int n = peptideProteinMapping.getIndex();
            if (peptide == null) {
                peptidesMap.put(peptideKey, tempPeptide);
                HashSet<Integer> peptideIndexes = new HashSet<Integer>(1);
                peptideIndexes.add(n);
                HashMap<Object, HashSet<Integer>> proteinMapping = new HashMap<Object, HashSet<Integer>>(1);
                proteinMapping.put(proteinAccession, peptideIndexes);
                proteinsMap.put(peptideKey, proteinMapping);
                if (peptideProteinMapping.getPeptideVariantMatches() == null) continue;
                HashMap<Integer, PeptideVariantMatches> variantIndex = new HashMap<Integer, PeptideVariantMatches>(1);
                variantIndex.put(n, peptideProteinMapping.getPeptideVariantMatches());
                HashMap<Object, HashMap<Integer, PeptideVariantMatches>> proteinVariantMap = new HashMap<Object, HashMap<Integer, PeptideVariantMatches>>(1);
                proteinVariantMap.put(proteinAccession, variantIndex);
                variantsMap.put(peptideKey, proteinVariantMap);
                continue;
            }
            HashMap proteinMapping = (HashMap)proteinsMap.get(peptideKey);
            HashSet<Integer> peptideIndexes = (HashSet<Integer>)proteinMapping.get(proteinAccession);
            if (peptideIndexes == null) {
                peptideIndexes = new HashSet<Integer>(1);
                proteinMapping.put(proteinAccession, peptideIndexes);
            }
            peptideIndexes.add(n);
            if (peptideProteinMapping.getPeptideVariantMatches() == null) continue;
            HashMap proteinVariantMap = (HashMap)variantsMap.get(peptideKey);
            if (proteinVariantMap == null) {
                proteinVariantMap = new HashMap();
            }
            HashMap<Integer, PeptideVariantMatches> variantIndex = null;
            if (proteinAccession != null) {
                variantIndex = (HashMap<Integer, PeptideVariantMatches>)proteinVariantMap.get(proteinAccession);
            }
            if (variantIndex == null) {
                variantIndex = new HashMap<Integer, PeptideVariantMatches>(1);
                proteinVariantMap.put(proteinAccession, variantIndex);
            }
            variantIndex.put(n, peptideProteinMapping.getPeptideVariantMatches());
        }
        Iterator<PeptideProteinMapping> iterator = peptidesMap.keySet().iterator();
        while (iterator.hasNext()) {
            long peptideKey = (Long)((Object)iterator.next());
            Peptide peptide = (Peptide)peptidesMap.get(peptideKey);
            HashMap proteinMapping = (HashMap)proteinsMap.get(peptideKey);
            TreeMap<String, int[]> proteinMappingArray = new TreeMap<String, int[]>();
            for (Map.Entry entry : proteinMapping.entrySet()) {
                int[] i = ((HashSet)entry.getValue()).stream().mapToInt(Integer::intValue).sorted().toArray();
                proteinMappingArray.put((String)entry.getKey(), i);
            }
            peptide.setProteinMapping(proteinMappingArray);
            HashMap variantMapping = (HashMap)variantsMap.get(peptideKey);
            peptide.setVariantMatches(variantMapping);
        }
        return peptidesMap.values();
    }
}

