/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.protein_inference.fm_index;

import java.io.Serializable;

public class Rank
implements Serializable {
    private static final long serialVersionUID = 832090205423902L;
    public final int length;
    private final long[] bitfield;
    private final int[] sums;
    private final byte[] sumsSecondLevel;
    private static final int BIT_SHIFT = 6;
    private static final int BIT_MASK = 63;

    public Rank() {
        this.length = 0;
        this.bitfield = null;
        this.sums = null;
        this.sumsSecondLevel = null;
    }

    public Rank(byte[] text, long[] aAlphabet) {
        this.length = text.length;
        int field_len = (this.length >>> 6) + 1;
        this.bitfield = new long[field_len];
        this.sums = new int[(this.length >>> 8) + 1];
        this.sums[0] = 0;
        this.sumsSecondLevel = new byte[field_len];
        this.sumsSecondLevel[0] = 0;
        for (int i = 0; i < this.length; ++i) {
            int cell = i >>> 6;
            int pos = i & 0x3F;
            if (pos == 0) {
                this.bitfield[cell] = 0L;
            }
            long bit = aAlphabet[text[i] >>> 6] >>> (text[i] & 0x3F) & 1L;
            int n = cell;
            this.bitfield[n] = this.bitfield[n] | bit << pos;
            if (pos == 0 && i != 0) {
                this.sumsSecondLevel[cell] = (i & 0xFF) == 0 ? (byte)0 : (byte)(this.sumsSecondLevel[cell - 1] + (byte)Long.bitCount(this.bitfield[cell - 1]));
            }
            if ((i & 0xFF) != 0 || i == 0) continue;
            this.sums[i >>> 8] = this.sums[(i >>> 8) - 1] + (this.sumsSecondLevel[cell - 1] & 0xFF) + Long.bitCount(this.bitfield[cell - 1]);
        }
    }

    public Rank(long[] originalBitfield, int length) {
        this.length = length;
        int field_len = (length >>> 6) + 1;
        this.bitfield = originalBitfield;
        this.sums = new int[(length >>> 8) + 1];
        this.sums[0] = 0;
        this.sumsSecondLevel = new byte[field_len];
        this.sumsSecondLevel[0] = 0;
        for (int i = 0; i < length; ++i) {
            int cell = i >>> 6;
            int pos = i & 0x3F;
            if (pos == 0 && i != 0) {
                this.sumsSecondLevel[cell] = (i & 0xFF) == 0 ? (byte)0 : (byte)(this.sumsSecondLevel[cell - 1] + (byte)Long.bitCount(this.bitfield[cell - 1]));
            }
            if ((i & 0xFF) != 0 || i == 0) continue;
            this.sums[i >>> 8] = this.sums[(i >>> 8) - 1] + (this.sumsSecondLevel[cell - 1] & 0xFF) + Long.bitCount(this.bitfield[cell - 1]);
        }
    }

    public int getRank(int index, boolean zeros) {
        if (index < 0) {
            return 0;
        }
        int cell = index >>> 6;
        int pos = index & 0x3F;
        long active_ones = this.bitfield[cell] << 63 - pos;
        int count_ones = (this.sumsSecondLevel[cell] & 0xFF) + this.sums[index >>> 8] + Long.bitCount(active_ones);
        return zeros ? index + 1 - count_ones : count_ones;
    }

    public final int getRankOne(int index) {
        if (index < 0) {
            return 0;
        }
        int cell = index >>> 6;
        int pos = index & 0x3F;
        long active_ones = this.bitfield[cell] << 63 - pos;
        int count_ones = (this.sumsSecondLevel[cell] & 0xFF) + this.sums[index >>> 8] + Long.bitCount(active_ones);
        return count_ones;
    }

    public int getRankZero(int index) {
        if (index < 0) {
            return 0;
        }
        int cell = index >>> 6;
        int pos = index & 0x3F;
        long active_ones = this.bitfield[cell] << 63 - pos;
        int count_ones = (this.sumsSecondLevel[cell] & 0xFF) + this.sums[index >>> 8] + Long.bitCount(active_ones);
        return index + 1 - count_ones;
    }

    public boolean isOne(int index) {
        if (index < 0 || this.length <= index) {
            return false;
        }
        int cell = index >>> 6;
        int pos = index & 0x3F;
        return (this.bitfield[cell] >>> pos & 1L) == 1L;
    }

    public int getSelect(int index) {
        if (index < 1 || this.getRankOne(this.length - 1) < index) {
            return -1;
        }
        int l = 0;
        int r = this.length - 1;
        while (l <= r) {
            int m = l + r >> 1;
            if (this.getRankOne(m) < index) {
                l = m + 1;
                continue;
            }
            r = m - 1;
        }
        if (0 < l && this.getRankOne(l - 1) == index) {
            return l - 1;
        }
        if (this.getRankOne(l) == index) {
            return l;
        }
        if (l < this.length - 1 && this.getRankOne(l + 1) == index) {
            return l + 1;
        }
        return -1;
    }

    public int isOneInt(int index) {
        int cell = index >>> 6;
        int pos = index & 0x3F;
        return (int)(this.bitfield[cell] >>> pos & 1L);
    }

    public int getAllocatedBytes() {
        return (this.bitfield.length << 3) + (this.sums.length << 2) + this.sumsSecondLevel.length;
    }
}

