/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.psm_scoring.psm_scores;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.ions.Ion;
import com.compomics.util.experiment.biology.ions.impl.PeptideFragmentIon;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.peptide_fragmentation.PeptideFragmentationModel;
import com.compomics.util.experiment.identification.spectrum_annotation.AnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.SpecificAnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.spectrum_annotators.PeptideSpectrumAnnotator;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.mass_spectrometry.spectra.Spectrum;
import com.compomics.util.math.BasicMathFunctions;
import com.compomics.util.math.HistogramUtils;
import com.compomics.util.math.statistics.linear_regression.LinearRegression;
import com.compomics.util.math.statistics.linear_regression.RegressionStatistics;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.math.util.FastMath;

public class HyperScore {
    private PeptideFragmentationModel peptideFragmentationModel;
    private HashMap<Double, Integer> as = new HashMap();
    private HashMap<Double, Integer> bs = new HashMap();

    public HyperScore(PeptideFragmentationModel peptideFragmentationModel) {
        this.peptideFragmentationModel = peptideFragmentationModel;
    }

    public HyperScore() {
        this(PeptideFragmentationModel.uniform);
    }

    public double getScore(Peptide peptide, String spectrumFile, String spectrumTitle, Spectrum spectrum, AnnotationParameters annotationSettings, SpecificAnnotationParameters specificAnnotationSettings, PeptideSpectrumAnnotator peptideSpectrumAnnotator, ModificationParameters modificationParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters modificationSequenceMatchingParameters) {
        ArrayList ionMatches = Lists.newArrayList((Object[])peptideSpectrumAnnotator.getSpectrumAnnotation(annotationSettings, specificAnnotationSettings, spectrumFile, spectrumTitle, spectrum, peptide, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters));
        return this.getScore(peptide, specificAnnotationSettings.getPrecursorCharge(), spectrum, ionMatches);
    }

    public double getScore(Peptide peptide, int charge, Spectrum spectrum, ArrayList<IonMatch> ionMatches) {
        boolean peakMatched = false;
        Double coveredIntensity = 0.0;
        HashSet<Double> coveredMz = new HashSet<Double>(2);
        for (IonMatch ionMatch : ionMatches) {
            PeptideFragmentIon peptideFragmentIon;
            Ion ion = ionMatch.ion;
            if (!coveredMz.contains(ionMatch.peakMz)) {
                coveredIntensity = coveredIntensity + ionMatch.peakIntensity;
                coveredMz.add(ionMatch.peakMz);
            }
            if (ion.getType() != Ion.IonType.PEPTIDE_FRAGMENT_ION || (peptideFragmentIon = (PeptideFragmentIon)ion).hasNeutralLosses() || peptideFragmentIon.getNumber() < 2) continue;
            peakMatched = true;
        }
        if (!peakMatched) {
            return 0.0;
        }
        Double consideredIntensity = spectrum.getTotalIntensity() - coveredIntensity;
        double xCorr = 0.0;
        HashSet<Integer> ionsForward = new HashSet<Integer>(1);
        HashSet<Integer> ionsRewind = new HashSet<Integer>(1);
        HashSet<Double> accountedFor = new HashSet<Double>(ionMatches.size());
        for (IonMatch ionMatch : ionMatches) {
            PeptideFragmentIon peptideFragmentIon;
            int number;
            double mz = ionMatch.peakMz;
            Ion ion = ionMatch.ion;
            if (ion.getType() != Ion.IonType.PEPTIDE_FRAGMENT_ION || ion.hasNeutralLosses() || accountedFor.contains(mz) || (number = (peptideFragmentIon = (PeptideFragmentIon)ion).getNumber()) <= 1) continue;
            accountedFor.add(mz);
            double x0I = ionMatch.peakIntensity / consideredIntensity;
            xCorr += x0I;
            if (ion.getType() != Ion.IonType.PEPTIDE_FRAGMENT_ION || ion.hasNeutralLosses()) continue;
            if (ion.getSubType() == 3 || ion.getSubType() == 4 || ion.getSubType() == 5) {
                ionsForward.add(number);
                continue;
            }
            if (ion.getSubType() != 0 && ion.getSubType() != 1 && ion.getSubType() != 2) continue;
            ionsRewind.add(number);
        }
        int nForward = ionsForward.size() / Math.max(charge - 1, 1);
        int nRewind = ionsRewind.size() / Math.max(charge - 1, 1);
        nForward = nForward > 20 ? 20 : nForward;
        nRewind = nRewind > 20 ? 20 : nRewind;
        double forwardFactorial = BasicMathFunctions.factorialDouble(nForward);
        double rewindFactorial = BasicMathFunctions.factorialDouble(nRewind);
        return xCorr * forwardFactorial * rewindFactorial;
    }

    public HashMap<Double, Double> getEValueMap(ArrayList<Double> hyperScores) {
        return this.getEValueMap(hyperScores, true);
    }

    public HashMap<Double, Double> getEValueMap(ArrayList<Double> hyperScores, boolean useCache) {
        Integer highestBin;
        HashMap<Integer, Integer> histogram = new HashMap<Integer, Integer>();
        Double maxScore = 0.0;
        Double minScore = Double.MAX_VALUE;
        for (Double score : hyperScores) {
            Integer intValue = score.intValue();
            if (intValue <= 0) continue;
            Integer nScores = (Integer)histogram.get(intValue);
            if (nScores == null) {
                nScores = 1;
            } else {
                Integer n = nScores;
                nScores = nScores + 1;
            }
            histogram.put(intValue, nScores);
            if (score > maxScore) {
                maxScore = score;
            }
            if (!(score < minScore)) continue;
            minScore = score;
        }
        Integer lowestBin = minScore.intValue();
        Integer secondEmptybin = highestBin = Integer.valueOf(maxScore.intValue());
        Integer firstEmptybin = highestBin;
        boolean emptyBin = false;
        Integer bin = lowestBin;
        while (bin <= highestBin) {
            if (!histogram.containsKey(bin)) {
                if (!emptyBin) {
                    emptyBin = true;
                    firstEmptybin = bin;
                } else {
                    secondEmptybin = bin;
                    break;
                }
            }
            Integer n = bin;
            bin = bin + 1;
        }
        ArrayList bins = new ArrayList(histogram.keySet());
        for (Integer bin2 : bins) {
            if (bin2 > secondEmptybin) {
                histogram.remove(bin2);
                continue;
            }
            if (bin2 <= firstEmptybin) continue;
            histogram.put(bin2, 1);
        }
        double[] ab = this.getInterpolationValues(histogram, useCache);
        if (ab == null) {
            return null;
        }
        return this.getInterpolation(hyperScores, ab[0], ab[1]);
    }

    public double[] getInterpolationValues(int[] scores, boolean useCache) {
        HashMap<Integer, Integer> scoreHistogram = new HashMap<Integer, Integer>();
        int maxScore = 0;
        int minScore = Integer.MAX_VALUE;
        for (int score : scores) {
            if (score <= 0) continue;
            Integer nScores = (Integer)scoreHistogram.get(score);
            if (nScores == null) {
                nScores = 1;
            } else {
                Integer n = nScores;
                nScores = nScores + 1;
            }
            scoreHistogram.put(score, nScores);
            if (score > maxScore) {
                maxScore = score;
            }
            if (score >= minScore) continue;
            minScore = score;
        }
        Integer secondEmptybin = maxScore;
        Integer firstEmptybin = maxScore;
        boolean emptyBin = false;
        for (int bin = minScore; bin <= maxScore; ++bin) {
            if (scoreHistogram.containsKey(bin)) continue;
            if (!emptyBin) {
                emptyBin = true;
                firstEmptybin = bin;
                continue;
            }
            secondEmptybin = bin;
            break;
        }
        ArrayList bins = new ArrayList(scoreHistogram.keySet());
        for (Integer bin : bins) {
            if (bin > secondEmptybin) {
                scoreHistogram.remove(bin);
                continue;
            }
            if (bin <= firstEmptybin) continue;
            scoreHistogram.put(bin, 1);
        }
        return this.getInterpolationValues(scoreHistogram, useCache);
    }

    public double[] getInterpolationValues(HashMap<Integer, Integer> scoreHistogram, boolean useCache) {
        ArrayList<Integer> bins = new ArrayList<Integer>(scoreHistogram.keySet());
        Collections.sort(bins, Collections.reverseOrder());
        ArrayList<Double> evalueFunctionX = new ArrayList<Double>(scoreHistogram.size());
        ArrayList<Double> evalueFunctionY = new ArrayList<Double>(scoreHistogram.size());
        Integer currentSum = 0;
        for (Integer bin : bins) {
            Integer nInBin = scoreHistogram.get(bin);
            if (nInBin != null) {
                currentSum = currentSum + nInBin;
            }
            if (currentSum <= 0) continue;
            Double xValue = (double)bin;
            xValue = FastMath.log10((double)xValue);
            evalueFunctionX.add(xValue);
            Double yValue = (double)currentSum;
            yValue = FastMath.log10((double)yValue);
            evalueFunctionY.add(yValue);
        }
        if (evalueFunctionX.size() <= 1) {
            return null;
        }
        RegressionStatistics regressionStatistics = LinearRegression.getSimpleLinearRegression(evalueFunctionX, evalueFunctionY);
        if (useCache) {
            Double roundedA = Util.roundDouble(regressionStatistics.a, 2);
            Double roundedB = Util.roundDouble(regressionStatistics.b, 2);
            Integer nA = this.as.get(roundedA);
            if (nA == null) {
                this.as.put(roundedA, 1);
            } else {
                this.as.put(roundedA, nA + 1);
            }
            Integer nB = this.bs.get(roundedB);
            if (nB == null) {
                this.bs.put(roundedB, 1);
            } else {
                this.bs.put(roundedB, nB + 1);
            }
        }
        return new double[]{regressionStatistics.a, regressionStatistics.b};
    }

    public HashMap<Double, Double> getInterpolation(ArrayList<Double> hyperScores, Double a, Double b) {
        HashMap<Double, Double> result = new HashMap<Double, Double>();
        for (Double hyperScore : hyperScores) {
            if (result.containsKey(hyperScore)) continue;
            if (hyperScore > 0.0) {
                double logScore = FastMath.log10((double)hyperScore);
                double eValue = HyperScore.getInterpolation(logScore, a, b);
                result.put(hyperScore, eValue);
                continue;
            }
            Double eValue = hyperScores.size();
            result.put(hyperScore, eValue);
        }
        return result;
    }

    public static double getInterpolation(double logScore, double a, double b) {
        return b + a * logScore;
    }

    public Double getMendianA() {
        if (this.as.isEmpty()) {
            return null;
        }
        return HistogramUtils.getMedianValue(this.as);
    }

    public Double getMendianB() {
        if (this.bs.isEmpty()) {
            return null;
        }
        return HistogramUtils.getMedianValue(this.bs);
    }

    public HashMap<Double, Integer> getAs() {
        return this.as;
    }

    public HashMap<Double, Integer> getBs() {
        return this.bs;
    }
}

