/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.spectrum_annotation;

import com.compomics.util.experiment.biology.ions.Ion;
import com.compomics.util.experiment.biology.ions.impl.PeptideFragmentIon;
import com.compomics.util.experiment.biology.ions.impl.TagFragmentIon;
import com.compomics.util.experiment.identification.matches.IonMatch;
import java.util.HashMap;

public class IonMatchKeysCache {
    private final HashMap<Integer, HashMap<Integer, HashMap<Integer, HashMap<String, HashMap<Integer, String>>>>> ionKeysCache = new HashMap(8);

    public String getMatchKey(Ion ion, int charge) {
        String key;
        HashMap<Integer, String> ionNeutralLossesMap;
        HashMap<String, HashMap<Integer, String>> ionNumberMap;
        HashMap<Integer, HashMap<String, HashMap<Integer, String>>> ionSubTypeMap;
        int fragmentIonNumber;
        Ion.IonType ionType = ion.getType();
        int ionTypeIndex = ionType.index;
        int ionSubType = ion.getSubType();
        if (ionType == Ion.IonType.PEPTIDE_FRAGMENT_ION) {
            PeptideFragmentIon fragmentIon = (PeptideFragmentIon)ion;
            fragmentIonNumber = fragmentIon.getNumber();
        } else if (ionType == Ion.IonType.TAG_FRAGMENT_ION) {
            TagFragmentIon tagFragmentIon = (TagFragmentIon)ion;
            fragmentIonNumber = tagFragmentIon.getNumber();
        } else {
            fragmentIonNumber = 0;
        }
        String neutralLossesAsString = ion.getNeutralLossesAsString();
        HashMap<Integer, HashMap<Integer, HashMap<String, HashMap<Integer, String>>>> ionTypeMap = this.ionKeysCache.get(ionTypeIndex);
        if (ionTypeMap == null) {
            ionTypeMap = new HashMap(8);
            this.ionKeysCache.put(ionTypeIndex, ionTypeMap);
        }
        if ((ionSubTypeMap = ionTypeMap.get(ionSubType)) == null) {
            ionSubTypeMap = new HashMap(2);
            ionTypeMap.put(ionSubType, ionSubTypeMap);
        }
        if ((ionNumberMap = ionSubTypeMap.get(fragmentIonNumber)) == null) {
            ionNumberMap = new HashMap(8);
            ionSubTypeMap.put(fragmentIonNumber, ionNumberMap);
        }
        if ((ionNeutralLossesMap = ionNumberMap.get(neutralLossesAsString)) == null) {
            ionNeutralLossesMap = new HashMap(4);
            ionNumberMap.put(neutralLossesAsString, ionNeutralLossesMap);
        }
        if ((key = ionNeutralLossesMap.get(charge)) == null) {
            key = IonMatch.getMatchKey(ionTypeIndex, ionSubType, fragmentIonNumber, neutralLossesAsString, charge);
            ionNeutralLossesMap.put(charge, key);
        }
        return key;
    }
}

