/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.spectrum_annotation.spectrum_annotators;

import com.compomics.util.experiment.biology.ions.Ion;
import com.compomics.util.experiment.biology.ions.IonFactory;
import com.compomics.util.experiment.biology.ions.NeutralLoss;
import com.compomics.util.experiment.biology.ions.impl.PeptideFragmentIon;
import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.spectrum_annotation.AnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.NeutralLossesMap;
import com.compomics.util.experiment.identification.spectrum_annotation.SpecificAnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.SpectrumAnnotator;
import com.compomics.util.experiment.identification.utils.ModificationUtils;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.mass_spectrometry.spectra.Spectrum;
import com.compomics.util.experiment.mass_spectrometry.spectra.SpectrumUtil;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class PeptideSpectrumAnnotator
extends SpectrumAnnotator {
    private Peptide peptide;

    public void setPeptide(Peptide peptide, int precursorCharge, ModificationParameters modificationParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters modificationsSequenceMatchingParameters, SpecificAnnotationParameters specificAnnotationSettings) {
        this.setPeptide(peptide, modificationParameters, sequenceProvider, modificationsSequenceMatchingParameters, null, precursorCharge, specificAnnotationSettings);
    }

    public void setPeptide(Peptide peptide, ModificationParameters modificationParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters modificationsSequenceMatchingParameters, HashMap<Integer, HashMap<Integer, ArrayList<Ion>>> possibleFragmentIons, int precursorCharge, SpecificAnnotationParameters specificAnnotationSettings) {
        if (specificAnnotationSettings != null && this.specificAnnotationSettings == null || specificAnnotationSettings == null && this.specificAnnotationSettings != null || specificAnnotationSettings != null && this.specificAnnotationSettings != null && specificAnnotationSettings != this.specificAnnotationSettings || this.peptide == null || this.peptide.getKey() != peptide.getKey() || !this.peptide.sameModificationsAs(peptide) || this.precursorCharge != precursorCharge) {
            this.peptide = peptide;
            this.precursorCharge = precursorCharge;
            this.defaultPrecursorCharges = IntStream.rangeClosed(1, precursorCharge).mapToObj(a -> a).collect(Collectors.toCollection(HashSet::new));
            this.theoreticalFragmentIons = possibleFragmentIons == null ? this.fragmentFactory.getFragmentIons(peptide, specificAnnotationSettings, modificationParameters, sequenceProvider, modificationsSequenceMatchingParameters) : possibleFragmentIons;
            if (this.massShift != 0.0 || this.massShiftNTerm != 0.0 || this.massShiftCTerm != 0.0) {
                this.updateMassShifts();
            }
        }
    }

    public ArrayList<IonMatch> matchPeak(Peptide peptide, ModificationParameters modificationParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters modificationsSequenceMatchingParameters, SpecificAnnotationParameters specificAnnotationSettings, double peakMz, double peakIntensity) {
        this.setPeptide(peptide, specificAnnotationSettings.getPrecursorCharge(), modificationParameters, sequenceProvider, modificationsSequenceMatchingParameters, specificAnnotationSettings);
        return this.matchPeak(specificAnnotationSettings, peakMz, peakIntensity);
    }

    public IonMatch[] getSpectrumAnnotation(AnnotationParameters annotationSettings, SpecificAnnotationParameters specificAnnotationSettings, String spectrumFile, String spectrumTitle, Spectrum spectrum, Peptide peptide, ModificationParameters modificationParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters modificationsSequenceMatchingParameters) {
        return (IonMatch[])this.getSpectrumAnnotationStream(annotationSettings, specificAnnotationSettings, spectrumFile, spectrumTitle, spectrum, peptide, modificationParameters, sequenceProvider, modificationsSequenceMatchingParameters, true).toArray(IonMatch[]::new);
    }

    public Stream<IonMatch> getSpectrumAnnotationStream(AnnotationParameters annotationSettings, SpecificAnnotationParameters specificAnnotationSettings, String spectrumFile, String spectrumTitle, Spectrum spectrum, Peptide peptide, ModificationParameters modificationParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters modificationsSequenceMatchingParameters) {
        return this.getSpectrumAnnotationStream(annotationSettings, specificAnnotationSettings, spectrumFile, spectrumTitle, spectrum, peptide, modificationParameters, sequenceProvider, modificationsSequenceMatchingParameters, true);
    }

    public Stream<IonMatch> getSpectrumAnnotationStream(AnnotationParameters annotationSettings, SpecificAnnotationParameters specificAnnotationSettings, String spectrumFile, String spectrumTitle, Spectrum spectrum, Peptide peptide, ModificationParameters modificationParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters modificationsSequenceMatchingParameters, boolean useIntensityFilter) {
        return this.getSpectrumAnnotationStream(annotationSettings, specificAnnotationSettings, spectrumFile, spectrumTitle, spectrum, peptide, modificationParameters, sequenceProvider, modificationsSequenceMatchingParameters, null, useIntensityFilter);
    }

    public IonMatch[] getSpectrumAnnotation(AnnotationParameters annotationSettings, SpecificAnnotationParameters specificAnnotationSettings, String spectrumFile, String spectrumTitle, Spectrum spectrum, Peptide peptide, ModificationParameters modificationParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters modificationsSequenceMatchingParameters, boolean useIntensityFilter) {
        return (IonMatch[])this.getSpectrumAnnotationStream(annotationSettings, specificAnnotationSettings, spectrumFile, spectrumTitle, spectrum, peptide, modificationParameters, sequenceProvider, modificationsSequenceMatchingParameters, null, useIntensityFilter).toArray(IonMatch[]::new);
    }

    public IonMatch[] getSpectrumAnnotation(AnnotationParameters annotationSettings, SpecificAnnotationParameters specificAnnotationSettings, String spectrumFile, String spectrumTitle, Spectrum spectrum, Peptide peptide, ModificationParameters modificationParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters modificationsSequenceMatchingParameters, HashMap<Integer, HashMap<Integer, ArrayList<Ion>>> possiblePeptideFragments, boolean useIntensityFilter) {
        return (IonMatch[])this.getSpectrumAnnotationStream(annotationSettings, specificAnnotationSettings, spectrumFile, spectrumTitle, spectrum, peptide, modificationParameters, sequenceProvider, modificationsSequenceMatchingParameters, possiblePeptideFragments, useIntensityFilter).toArray(IonMatch[]::new);
    }

    public Stream<IonMatch> getSpectrumAnnotationStream(AnnotationParameters annotationSettings, SpecificAnnotationParameters specificAnnotationSettings, String spectrumFile, String spectrumTitle, Spectrum spectrum, Peptide peptide, ModificationParameters modificationParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters modificationsSequenceMatchingParameters, HashMap<Integer, HashMap<Integer, ArrayList<Ion>>> possiblePeptideFragments, boolean useIntensityFilter) {
        this.setMassTolerance(specificAnnotationSettings.getFragmentIonAccuracy(), specificAnnotationSettings.isFragmentIonPpm(), annotationSettings.getTiesResolution());
        if (spectrum != null) {
            double spectrumIntensityLimit = useIntensityFilter ? SpectrumUtil.getIntensityLimit(spectrum, annotationSettings.getIntensityThresholdType(), annotationSettings.getAnnotationIntensityLimit()) : 0.0;
            this.setSpectrum(spectrumFile, spectrumTitle, spectrum, spectrumIntensityLimit);
        }
        this.setPeptide(peptide, modificationParameters, sequenceProvider, modificationsSequenceMatchingParameters, possiblePeptideFragments, specificAnnotationSettings.getPrecursorCharge(), specificAnnotationSettings);
        HashMap<Ion.IonType, HashSet<Integer>> selectedIonTypes = specificAnnotationSettings.getIonTypes();
        return selectedIonTypes.entrySet().stream().filter(entry1 -> this.theoreticalFragmentIons.containsKey(((Ion.IonType)((Object)((Object)entry1.getKey()))).index)).flatMap(entry1 -> ((HashMap)this.theoreticalFragmentIons.get(((Ion.IonType)((Object)((Object)entry1.getKey()))).index)).entrySet().stream().filter(entry2 -> ((HashSet)entry1.getValue()).contains(entry2.getKey())).flatMap(entry2 -> ((ArrayList)entry2.getValue()).stream()).filter(ion -> this.lossesValidated(specificAnnotationSettings.getNeutralLossesMap(), (Ion)ion)).flatMap(ion -> this.getPossibleCharges(ion.getType(), specificAnnotationSettings).stream().filter(charge -> this.chargeValidated((Ion)ion, (int)charge, this.precursorCharge)).map(charge -> this.matchInSpectrum(spectrum.mz, spectrum.intensity, (Ion)ion, (int)charge)).filter(ionMatch -> ionMatch != null)));
    }

    private HashSet<Integer> getPossibleCharges(Ion.IonType ionType, SpecificAnnotationParameters specificAnnotationSettings) {
        return ionType == Ion.IonType.PRECURSOR_ION ? this.defaultPrecursorCharges : specificAnnotationSettings.getSelectedCharges();
    }

    public Map<Integer, ArrayList<IonMatch>> getCoveredAminoAcids(AnnotationParameters annotationSettings, SpecificAnnotationParameters specificAnnotationSettings, String spectrumFile, String spectrumTitle, Spectrum spectrum, Peptide peptide, ModificationParameters modificationParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters modificationsSequenceMatchingParameters, boolean useIntensityFilter) {
        return this.getSpectrumAnnotationStream(annotationSettings, specificAnnotationSettings, spectrumFile, spectrumTitle, spectrum, peptide, modificationParameters, sequenceProvider, modificationsSequenceMatchingParameters).filter(ionMatch -> ionMatch.ion.getType() == Ion.IonType.PEPTIDE_FRAGMENT_ION).collect(Collectors.groupingBy(ionMatch -> ((PeptideFragmentIon)ionMatch.ion).getAaNumber(peptide.getSequence().length()), Collectors.toCollection(ArrayList::new)));
    }

    public HashMap<Integer, ArrayList<Ion>> getExpectedIons(SpecificAnnotationParameters specificAnnotationSettings, Peptide peptide, ModificationParameters modificationParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters modificationsSequenceMatchingParameters) {
        return this.getExpectedIons(specificAnnotationSettings, peptide, modificationParameters, sequenceProvider, modificationsSequenceMatchingParameters, null);
    }

    public HashMap<Integer, ArrayList<Ion>> getExpectedIons(SpecificAnnotationParameters specificAnnotationSettings, Peptide peptide, ModificationParameters modificationParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters modificationsSequenceMatchingParameters, HashMap<Integer, HashMap<Integer, ArrayList<Ion>>> possibleFragmentIons) {
        this.setPeptide(peptide, modificationParameters, sequenceProvider, modificationsSequenceMatchingParameters, possibleFragmentIons, specificAnnotationSettings.getPrecursorCharge(), specificAnnotationSettings);
        return this.getExpectedIons(specificAnnotationSettings);
    }

    @Override
    public IonMatch[] getCurrentAnnotation(String spectrumFile, String spectrumTitle, Spectrum spectrum, AnnotationParameters annotationSettings, SpecificAnnotationParameters specificAnnotationSettings, ModificationParameters modificationParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters modificationsSequenceMatchingParameters, boolean useIntensityFilter) {
        return this.getSpectrumAnnotation(annotationSettings, specificAnnotationSettings, spectrumFile, spectrumTitle, spectrum, this.peptide, modificationParameters, sequenceProvider, modificationsSequenceMatchingParameters, useIntensityFilter);
    }

    public static NeutralLossesMap getDefaultLosses(Peptide peptide, ModificationParameters modificationParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters modificationsSequenceMatchingParameters) {
        ModificationMatch[] modificationMatches;
        ModificationFactory modificationFactory = ModificationFactory.getInstance();
        NeutralLossesMap neutralLossesMap = new NeutralLossesMap();
        String sequence = peptide.getSequence();
        int aaMin = sequence.length();
        int aaMax = 0;
        for (String nlName : IonFactory.getDefaultNeutralLosses()) {
            NeutralLoss neutralLoss = NeutralLoss.getNeutralLoss(nlName);
            char[] aas = neutralLoss.aminoAcids;
            if (aas == null) continue;
            for (char aa : aas) {
                int firstIndex = sequence.indexOf(aa);
                if (firstIndex == -1) continue;
                aaMin = Math.min(firstIndex, aaMin);
                aaMax = Math.max(sequence.lastIndexOf(aa), aaMax);
            }
            if (aaMin >= sequence.length()) continue;
            neutralLossesMap.addNeutralLoss(neutralLoss, aaMin + 1, sequence.length() - aaMax);
        }
        String[] fixedModifications = peptide.getFixedModifications(modificationParameters, sequenceProvider, modificationsSequenceMatchingParameters);
        for (int i = 0; i < fixedModifications.length; ++i) {
            String modName = fixedModifications[i];
            int site = ModificationUtils.getSite(i, fixedModifications.length);
            if (modName == null) continue;
            Modification modification = modificationFactory.getModification(modName);
            aaMin = site;
            aaMax = sequence.length() - site + 1;
            for (NeutralLoss neutralLoss : modification.getNeutralLosses()) {
                neutralLossesMap.addNeutralLoss(neutralLoss, aaMin, aaMax);
            }
        }
        for (ModificationMatch modMatch : modificationMatches = peptide.getVariableModifications()) {
            int site = ModificationUtils.getSite(modMatch.getSite(), fixedModifications.length);
            String modName = modMatch.getModification();
            Modification modification = modificationFactory.getModification(modName);
            aaMin = site;
            aaMax = sequence.length() - site + 1;
            for (NeutralLoss neutralLoss : modification.getNeutralLosses()) {
                neutralLossesMap.addNeutralLoss(neutralLoss, aaMin, aaMax);
            }
        }
        return neutralLossesMap;
    }

    public Peptide getCurrentlyLoadedPeptide() {
        return this.peptide;
    }
}

