/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.spectrum_annotation.spectrum_annotators;

import com.compomics.util.experiment.biology.aminoacids.sequence.AminoAcidSequence;
import com.compomics.util.experiment.biology.ions.Ion;
import com.compomics.util.experiment.biology.ions.NeutralLoss;
import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.identification.amino_acid_tags.MassGap;
import com.compomics.util.experiment.identification.amino_acid_tags.Tag;
import com.compomics.util.experiment.identification.amino_acid_tags.TagComponent;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.spectrum_annotation.AnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.NeutralLossesMap;
import com.compomics.util.experiment.identification.spectrum_annotation.SpecificAnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.SpectrumAnnotator;
import com.compomics.util.experiment.identification.utils.ModificationUtils;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.mass_spectrometry.spectra.Spectrum;
import com.compomics.util.experiment.mass_spectrometry.spectra.SpectrumUtil;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class TagSpectrumAnnotator
extends SpectrumAnnotator {
    private Tag tag;

    public Tag getTag() {
        return this.tag;
    }

    public void setTag(Tag newTag, ModificationParameters modificationParameters, SequenceMatchingParameters modificationsSequenceMatchingParameters, int precursorCharge) {
        if (this.tag == null || !this.tag.isSameAs(newTag, SequenceMatchingParameters.DEFAULT_STRING_MATCHING) || this.precursorCharge != precursorCharge) {
            this.tag = newTag;
            this.precursorCharge = precursorCharge;
            this.theoreticalFragmentIons = this.fragmentFactory.getFragmentIons(newTag, modificationParameters, modificationsSequenceMatchingParameters);
            if (this.massShift != 0.0 || this.massShiftNTerm != 0.0 || this.massShiftCTerm != 0.0) {
                this.updateMassShifts();
            }
        }
    }

    public static NeutralLossesMap getDefaultLosses(Tag tag, ModificationParameters modificationParameters, SequenceMatchingParameters modificationsSequenceMatchingParameters) {
        int index;
        int i;
        AminoAcidSequence aminoAcidSequence;
        int tagLength;
        ModificationFactory modificationFactory = ModificationFactory.getInstance();
        NeutralLossesMap neutralLossesMap = new NeutralLossesMap();
        int aaMin = tagLength = tag.getLengthInAminoAcid();
        int aaMax = 0;
        int offset = 0;
        for (TagComponent component : tag.getContent()) {
            if (component instanceof AminoAcidSequence) {
                aminoAcidSequence = (AminoAcidSequence)component;
                for (i = 0; i < aminoAcidSequence.length(); ++i) {
                    if (aminoAcidSequence.charAt(i) != 'D' && aminoAcidSequence.charAt(i) != 'E' && aminoAcidSequence.charAt(i) != 'S' && aminoAcidSequence.charAt(i) != 'T') continue;
                    index = i + offset;
                    aaMin = Math.min(index, aaMin);
                    aaMax = Math.max(index, aaMax);
                }
                offset += aminoAcidSequence.length();
                continue;
            }
            if (component instanceof MassGap) {
                ++offset;
                continue;
            }
            throw new UnsupportedOperationException("Spectrum annotator not implemented for " + component.getClass() + ".");
        }
        if (aaMin < tagLength) {
            neutralLossesMap.addNeutralLoss(NeutralLoss.H2O, aaMin + 1, tagLength - aaMax);
        }
        aaMin = tagLength;
        aaMax = 0;
        offset = 0;
        for (TagComponent component : tag.getContent()) {
            if (component instanceof AminoAcidSequence) {
                aminoAcidSequence = (AminoAcidSequence)component;
                for (i = 0; i < aminoAcidSequence.length(); ++i) {
                    if (aminoAcidSequence.charAt(i) != 'K' && aminoAcidSequence.charAt(i) != 'N' && aminoAcidSequence.charAt(i) != 'Q' && aminoAcidSequence.charAt(i) != 'R') continue;
                    index = i + offset;
                    aaMin = Math.min(index, aaMin);
                    aaMax = Math.max(index, aaMax);
                }
                offset += aminoAcidSequence.length();
                continue;
            }
            if (component instanceof MassGap) {
                ++offset;
                continue;
            }
            throw new UnsupportedOperationException("Spectrum annotator not implemented for " + component.getClass() + ".");
        }
        if (aaMin < tagLength) {
            neutralLossesMap.addNeutralLoss(NeutralLoss.NH3, aaMin + 1, tagLength - aaMax);
        }
        ArrayList<TagComponent> tagComponents = tag.getContent();
        offset = 0;
        for (int i2 = 0; i2 < tagComponents.size(); ++i2) {
            TagComponent component = tagComponents.get(i2);
            if (component instanceof AminoAcidSequence) {
                AminoAcidSequence aminoAcidSequence2 = (AminoAcidSequence)component;
                String[] fixedModifications = aminoAcidSequence2.getFixedModifications(i2 == 0, i2 == tagComponents.size() - 1, modificationParameters, modificationsSequenceMatchingParameters);
                String[] variableModifications = aminoAcidSequence2.getIndexedVariableModifications();
                for (int j = 0; j <= aminoAcidSequence2.length() + 1; ++j) {
                    String variableModification;
                    String fixedModification = fixedModifications[j];
                    if (fixedModification != null) {
                        Modification modification = modificationFactory.getModification(fixedModification);
                        int site = ModificationUtils.getSite(j, aminoAcidSequence2.length());
                        for (NeutralLoss neutralLoss : modification.getNeutralLosses()) {
                            neutralLossesMap.addNeutralLoss(neutralLoss, site, tag.getLengthInAminoAcid() - site + 1);
                        }
                    }
                    if ((variableModification = variableModifications[j]) == null) continue;
                    Modification modification = modificationFactory.getModification(variableModification);
                    int site = ModificationUtils.getSite(j, aminoAcidSequence2.length());
                    for (NeutralLoss neutralLoss : modification.getNeutralLosses()) {
                        neutralLossesMap.addNeutralLoss(neutralLoss, site, tag.getLengthInAminoAcid() - site + 1);
                    }
                }
                offset += aminoAcidSequence2.length();
                continue;
            }
            ++offset;
        }
        return neutralLossesMap;
    }

    public IonMatch[] getSpectrumAnnotation(AnnotationParameters annotationSettings, ModificationParameters modificationParameters, SequenceMatchingParameters modificationsSequenceMatchingParameters, SpecificAnnotationParameters specificAnnotationSettings, String spectrumFile, String spectrumTitle, Spectrum spectrum, Tag tag) {
        return this.getSpectrumAnnotation(annotationSettings, modificationParameters, modificationsSequenceMatchingParameters, specificAnnotationSettings, spectrumFile, spectrumTitle, spectrum, tag, true);
    }

    public IonMatch[] getSpectrumAnnotation(AnnotationParameters annotationSettings, ModificationParameters modificationParameters, SequenceMatchingParameters modificationsSequenceMatchingParameters, SpecificAnnotationParameters specificAnnotationSettings, String spectrumFile, String spectrumTitle, Spectrum spectrum, Tag tag, boolean useIntensityFilter) {
        ArrayList<IonMatch> annotationList = new ArrayList<IonMatch>(0);
        this.setMassTolerance(specificAnnotationSettings.getFragmentIonAccuracy(), specificAnnotationSettings.isFragmentIonPpm(), annotationSettings.getTiesResolution());
        if (spectrum != null) {
            double intensityLimit = useIntensityFilter ? SpectrumUtil.getIntensityLimit(spectrum, annotationSettings.getIntensityThresholdType(), annotationSettings.getAnnotationIntensityLimit()) : 0.0;
            this.setSpectrum(spectrumFile, spectrumTitle, spectrum, intensityLimit);
        }
        this.setTag(tag, modificationParameters, modificationsSequenceMatchingParameters, specificAnnotationSettings.getPrecursorCharge());
        HashSet<Integer> precursorCharges = IntStream.rangeClosed(1, this.precursorCharge).mapToObj(a -> a).collect(Collectors.toCollection(HashSet::new));
        HashMap<Ion.IonType, HashSet<Integer>> ionTypes = specificAnnotationSettings.getIonTypes();
        if (this.theoreticalFragmentIons != null) {
            for (Ion.IonType ionType : ionTypes.keySet()) {
                HashMap ionMap = (HashMap)this.theoreticalFragmentIons.get(ionType.index);
                if (ionMap == null) continue;
                HashSet<Integer> subtypes = ionTypes.get((Object)ionType);
                for (int subType : subtypes) {
                    ArrayList ions = (ArrayList)ionMap.get(subType);
                    if (ions == null) continue;
                    for (Ion ion : ions) {
                        if (!this.lossesValidated(specificAnnotationSettings.getNeutralLossesMap(), ion)) continue;
                        HashSet<Integer> tempCharges = ionType == Ion.IonType.PRECURSOR_ION ? precursorCharges : specificAnnotationSettings.getSelectedCharges();
                        for (int charge : tempCharges) {
                            IonMatch ionMatch;
                            if (!this.chargeValidated(ion, charge, this.precursorCharge) || (ionMatch = this.matchInSpectrum(spectrum.mz, spectrum.intensity, ion, charge)) == null) continue;
                            annotationList.add(ionMatch);
                        }
                    }
                }
            }
        }
        return annotationList.toArray(new IonMatch[annotationList.size()]);
    }

    @Override
    public IonMatch[] getCurrentAnnotation(String spectrumFile, String spectrumTitle, Spectrum spectrum, AnnotationParameters annotationSettings, SpecificAnnotationParameters specificAnnotationSettings, ModificationParameters modificationParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters modificationsSequenceMatchingParameters, boolean useIntensityFilter) {
        return this.getSpectrumAnnotation(annotationSettings, modificationParameters, modificationsSequenceMatchingParameters, specificAnnotationSettings, spectrumFile, spectrumTitle, spectrum, this.tag, useIntensityFilter);
    }
}

