/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.utils;

import com.compomics.util.experiment.biology.aminoacids.AminoAcid;
import com.compomics.util.experiment.biology.enzymes.Enzyme;
import com.compomics.util.experiment.io.biology.protein.FastaParameters;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.mass_spectrometry.utils.StandardMasses;
import java.util.ArrayList;
import java.util.Arrays;

public class ProteinUtils {
    public static boolean isDecoy(String accession, FastaParameters fastaParameters) {
        if (!fastaParameters.isTargetDecoy()) {
            return false;
        }
        String fastaFlag = fastaParameters.getDecoyFlag();
        if (fastaFlag == null || fastaFlag.length() > accession.length()) {
            return false;
        }
        String subString = fastaParameters.isDecoySuffix() ? accession.substring(accession.length() - fastaFlag.length()) : accession.substring(0, fastaFlag.length());
        return subString.equals(fastaFlag);
    }

    public static boolean isDecoy(String accession, SequenceProvider sequenceProvider) {
        return sequenceProvider.getDecoyAccessions().contains(accession);
    }

    public static int[] getObservableAminoAcids(String sequence, ArrayList<Enzyme> enzymes, double pepMaxLength) {
        int lastCleavage = -1;
        int[] observableAas = new int[sequence.length()];
        for (int i = 0; i < sequence.length() - 1; ++i) {
            char charati = sequence.charAt(i);
            char charatiPlusOne = sequence.charAt(i + 1);
            if (!enzymes.stream().anyMatch(enzyme -> enzyme.isCleavageSite(charati, charatiPlusOne))) continue;
            if ((double)(i - lastCleavage) <= pepMaxLength) {
                for (int k = lastCleavage + 1; k < i; ++k) {
                    observableAas[k] = 1;
                }
            }
            lastCleavage = i;
        }
        if ((double)(sequence.length() - 1 - lastCleavage) <= pepMaxLength) {
            for (int k = lastCleavage + 1; k < sequence.length(); ++k) {
                observableAas[k] = 1;
            }
        }
        return observableAas;
    }

    public static int getObservableLength(String sequence, ArrayList<Enzyme> enzymes, double pepMaxLength) {
        int[] observalbeAas = ProteinUtils.getObservableAminoAcids(sequence, enzymes, pepMaxLength);
        return Arrays.stream(observalbeAas).sum();
    }

    public static int getNCleavageSites(String sequence, ArrayList<Enzyme> enzymes) {
        int nCleavageSites = 0;
        for (int i = 0; i < sequence.length() - 1; ++i) {
            char charati = sequence.charAt(i);
            char charatiPlusOne = sequence.charAt(i + 1);
            if (!enzymes.stream().anyMatch(enzyme -> enzyme.isCleavageSite(charati, charatiPlusOne))) continue;
            ++nCleavageSites;
        }
        return nCleavageSites;
    }

    public static double computeMolecularWeight(String sequence) {
        double mass = StandardMasses.h2o.mass;
        mass += sequence.chars().mapToDouble(aa -> AminoAcid.getAminoAcid((char)aa).getMonoisotopicMass()).sum();
        return mass /= 1000.0;
    }
}

