/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.validation;

import java.util.HashMap;
import javax.swing.ImageIcon;

public enum MatchValidationLevel {
    none(-1, "No Validation"),
    not_validated(0, "Not Validated"),
    doubtful(1, "Doubtful"),
    confident(2, "Confident");

    private final int index;
    private final String name;

    private MatchValidationLevel(int index, String name) {
        this.index = index;
        this.name = name;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public boolean isValidated() {
        return this == doubtful || this == confident;
    }

    public String toString() {
        return this.getName();
    }

    public static HashMap<Integer, ImageIcon> getIconMap(Class tempClass) {
        HashMap<Integer, ImageIcon> icons = new HashMap<Integer, ImageIcon>();
        icons.put(none.getIndex(), new ImageIcon(tempClass.getResource("/icons/warning2-new.png")));
        icons.put(confident.getIndex(), new ImageIcon(tempClass.getResource("/icons/accept-new.png")));
        icons.put(not_validated.getIndex(), new ImageIcon(tempClass.getResource("/icons/error-new.png")));
        icons.put(doubtful.getIndex(), new ImageIcon(tempClass.getResource("/icons/warning-new.png")));
        return icons;
    }

    public static MatchValidationLevel[] getValidationLevels() {
        MatchValidationLevel[] result = new MatchValidationLevel[]{confident, doubtful, not_validated, none};
        return result;
    }

    public static int[] getValidationLevelIndexes() {
        int[] indexes = new int[]{none.getIndex(), not_validated.getIndex(), doubtful.getIndex(), confident.getIndex()};
        return indexes;
    }

    public static HashMap<Integer, String> getTooltipMap() {
        HashMap<Integer, String> tooltips = new HashMap<Integer, String>();
        for (MatchValidationLevel matchValidationLevel : MatchValidationLevel.getValidationLevels()) {
            tooltips.put(matchValidationLevel.getIndex(), matchValidationLevel.getName());
        }
        return tooltips;
    }

    public static String[] getValidationLevelsNames() {
        MatchValidationLevel[] possibilities = MatchValidationLevel.getValidationLevels();
        String[] result = new String[possibilities.length];
        for (int i = 0; i < possibilities.length; ++i) {
            result[i] = possibilities[i].getName();
        }
        return result;
    }

    public static MatchValidationLevel getMatchValidationLevel(String name) {
        for (MatchValidationLevel matchValidationLevel : MatchValidationLevel.getValidationLevels()) {
            if (!matchValidationLevel.getName().equals(name)) continue;
            return matchValidationLevel;
        }
        throw new IllegalArgumentException("No match validation level found for name " + name + ".");
    }

    public static MatchValidationLevel getMatchValidationLevel(int index) {
        for (MatchValidationLevel matchValidationLevel : MatchValidationLevel.getValidationLevels()) {
            if (matchValidationLevel.getIndex() != index) continue;
            return matchValidationLevel;
        }
        throw new IllegalArgumentException("No match validation level found for index " + index + ".");
    }

    private MatchValidationLevel() {
        this.index = 0;
        this.name = "";
    }
}

