/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.biology.protein;

import com.compomics.util.experiment.io.biology.protein.Header;
import com.compomics.util.experiment.io.biology.protein.iterators.HeaderIterator;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.waiting.WaitingHandler;
import java.io.File;
import java.io.IOException;

public class FastaParameters
extends ExperimentObject {
    public static final String[] DECOY_FLAGS = new String[]{"decoy", "random", "reversed", "rev"};
    public static final char[] DECOY_SEPARATORS = new char[]{'-', '.', '_'};
    private boolean targetDecoy = true;
    private String decoyFlag = "_REVERSED";
    private boolean decoySuffix = true;
    private String targetDecoyFileNameTag = "_concatenated_target_decoy";

    public boolean isTargetDecoy() {
        return this.targetDecoy;
    }

    public void setTargetDecoy(boolean targetDecoy) {
        this.targetDecoy = targetDecoy;
    }

    public String getDecoyFlag() {
        return this.decoyFlag;
    }

    public void setDecoyFlag(String decoyFlag) {
        this.decoyFlag = decoyFlag;
    }

    public boolean isDecoySuffix() {
        return this.decoySuffix;
    }

    public void setDecoySuffix(boolean decoySuffix) {
        this.decoySuffix = decoySuffix;
    }

    public String getTargetDecoyFileNameSuffix() {
        return this.targetDecoyFileNameTag;
    }

    public void setTargetDecoyFileNameSuffix(String targetDecoyFileNameSuffix) {
        this.targetDecoyFileNameTag = targetDecoyFileNameSuffix;
    }

    public boolean isSameAs(FastaParameters fastaParameters) {
        if (this.targetDecoy != fastaParameters.isTargetDecoy()) {
            return false;
        }
        if (this.decoyFlag != null && fastaParameters.getDecoyFlag() == null || this.decoyFlag == null && fastaParameters.getDecoyFlag() != null || this.decoyFlag != null && fastaParameters.getDecoyFlag() != null && !this.decoyFlag.equals(fastaParameters.getDecoyFlag())) {
            return false;
        }
        if (this.decoySuffix != fastaParameters.isDecoySuffix()) {
            return false;
        }
        return !(this.targetDecoyFileNameTag != null && fastaParameters.getTargetDecoyFileNameSuffix() == null || this.targetDecoyFileNameTag == null && fastaParameters.getTargetDecoyFileNameSuffix() != null) && (this.targetDecoyFileNameTag == null || fastaParameters.getTargetDecoyFileNameSuffix() == null || this.targetDecoyFileNameTag.equals(fastaParameters.getTargetDecoyFileNameSuffix()));
    }

    public static FastaParameters inferParameters(String fastaFilePath, WaitingHandler waitingHandler) throws IOException {
        String fastaHeader;
        FastaParameters fastaParameters = new FastaParameters();
        fastaParameters.setTargetDecoy(false);
        File fastaFile = new File(fastaFilePath);
        HeaderIterator headerIterator = new HeaderIterator(fastaFile);
        int i = 0;
        int offset = 0;
        int offSetIncrease = 100;
        while ((fastaHeader = headerIterator.getNextHeader(waitingHandler)) != null) {
            if (i > offset && i < offset + 10) {
                Header header = Header.parseFromFASTA(fastaHeader);
                String accession = header.getAccessionOrRest();
                String accessionLowerCase = accession.toLowerCase();
                for (String decoyFlagLowerCase : DECOY_FLAGS) {
                    int startIndex;
                    if (accession.length() <= decoyFlagLowerCase.length()) continue;
                    String subString = accessionLowerCase.substring(0, decoyFlagLowerCase.length());
                    if (subString.equals(decoyFlagLowerCase)) {
                        String decoyFlag = accession.substring(0, decoyFlagLowerCase.length());
                        for (char sep : DECOY_SEPARATORS) {
                            if (accession.charAt(decoyFlagLowerCase.length()) != sep) continue;
                            decoyFlag = decoyFlag + sep;
                            fastaParameters.setDecoySuffix(false);
                            fastaParameters.setDecoyFlag(decoyFlag);
                            headerIterator.close();
                            fastaParameters.setTargetDecoy(true);
                            return fastaParameters;
                        }
                    }
                    if (!(subString = accessionLowerCase.substring(startIndex = accession.length() - decoyFlagLowerCase.length())).equals(decoyFlagLowerCase)) continue;
                    String decoyFlag = accession.substring(startIndex);
                    for (char sep : DECOY_SEPARATORS) {
                        if (accession.charAt(startIndex - 1) != sep) continue;
                        decoyFlag = sep + decoyFlag;
                        fastaParameters.setDecoySuffix(true);
                        fastaParameters.setDecoyFlag(decoyFlag);
                        headerIterator.close();
                        fastaParameters.setTargetDecoy(true);
                        return fastaParameters;
                    }
                }
            } else if (i == offset + 10) {
                if (i > 10 * offSetIncrease) {
                    offSetIncrease *= 10;
                }
                offset += offSetIncrease;
            }
            ++i;
            if (waitingHandler == null || !waitingHandler.isRunCanceled()) continue;
            return null;
        }
        return fastaParameters;
    }

    public boolean equals(FastaParameters fastaParameters) {
        if (!this.decoyFlag.equals(fastaParameters.getDecoyFlag())) {
            return false;
        }
        if (this.decoySuffix != fastaParameters.isDecoySuffix()) {
            return false;
        }
        return this.targetDecoyFileNameTag.equals(fastaParameters.getTargetDecoyFileNameSuffix());
    }

    public String getShortDescription() {
        String newLine = System.getProperty("line.separator");
        StringBuilder output = new StringBuilder();
        output.append("Decoy Type: ");
        if (this.decoySuffix) {
            output.append("Suffix");
        } else {
            output.append("Prefix");
        }
        output.append(", ").append("Decoy Tag: ").append(this.decoyFlag).append(".").append(newLine);
        return output.toString();
    }
}

