/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.biology.protein;

import java.util.Arrays;

public enum ProteinDatabase {
    UniProt("UniProtKB", "14681372"),
    EnsemblGenomes("Ensembl Genomes", "26578574"),
    SGD("Saccharomyces Genome Database (SGD)", "9399804"),
    Arabidopsis_thaliana_TAIR("The Arabidopsis Information Resource (TAIR)", "12519987"),
    PSB_Arabidopsis_thaliana("PSB Arabidopsis thaliana", null),
    Drosophile("Drosophile", null),
    Flybase("Flybase", null),
    NCBI_old("NCBI Reference Sequences (RefSeq)", "22121212"),
    NCBI_new("NCBI Reference Sequences (RefSeq)", "22121212"),
    M_Tuberculosis("TBDatabase (TBDB)", "18835847"),
    H_Invitation("H_Invitation", null),
    Halobacterium("Halobacterium", null),
    H_Influenza("H_Influenza", null),
    C_Trachomatis("C_Trachomatis", null),
    GenomeTranslation("Genome Translation", null),
    Listeria("Listeria", null),
    GAFFA("GAFFA", null),
    UPS("Universal Proteomic Standard (UPS)", null),
    Generic_Header("Generic Header", null),
    IPI("International Protein Index (IPI)", "15221759"),
    Generic_Split_Header("Generic Split Header", null),
    NextProt("neXtProt", "22139911"),
    UniRef("UniRef", null),
    Unknown("Unknown", null);

    public final String fullName;
    public final String pmid;

    private ProteinDatabase(String fullName, String pmid) {
        this.fullName = fullName;
        this.pmid = pmid;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getPmid() {
        return this.pmid;
    }

    public ProteinDatabase getProteinDatabase(String fullName) {
        return Arrays.stream(ProteinDatabase.values()).filter(database -> database.getFullName().equals(fullName)).findAny().orElse(null);
    }

    private ProteinDatabase() {
        this.fullName = "";
        this.pmid = "";
    }
}

