/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.biology.protein.iterators;

import com.compomics.util.experiment.biology.aminoacids.AminoAcid;
import com.compomics.util.experiment.biology.proteins.Protein;
import com.compomics.util.experiment.io.biology.protein.Header;
import com.compomics.util.experiment.io.biology.protein.ProteinIterator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.Semaphore;
import org.apache.commons.io.input.CountingInputStream;

public class FastaIterator
implements ProteinIterator {
    private final Semaphore bufferingMutex = new Semaphore(1);
    public static final char FORBIDDEN_CHARACTER = '*';
    private final BufferedReader br;
    private final boolean sanityCheck;
    private Header nextHeader = null;
    private Header lastHeader = null;
    private boolean endOfFileReached = false;
    private final long fileLength;
    private final CountingInputStream countingInputStream;

    public FastaIterator(File fastaFile) throws FileNotFoundException {
        this(fastaFile, false);
    }

    public FastaIterator(File fastaFile, boolean sanityCheck) throws FileNotFoundException {
        try {
            FileInputStream fileStream = new FileInputStream(fastaFile);
            this.countingInputStream = new CountingInputStream((InputStream)fileStream);
            InputStreamReader reader = new InputStreamReader((InputStream)this.countingInputStream, "UTF-8");
            this.br = new BufferedReader(reader);
            this.fileLength = fastaFile.length();
            this.sanityCheck = sanityCheck;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public double getProgressInPercent() {
        return 100.0 * (double)this.countingInputStream.getByteCount() / (double)this.fileLength;
    }

    @Override
    public Protein getNextProtein() {
        try {
            String line;
            this.bufferingMutex.acquire();
            if (this.endOfFileReached) {
                return null;
            }
            Header header = this.nextHeader;
            StringBuilder sequenceBuilder = new StringBuilder();
            while ((line = this.br.readLine()) != null) {
                if ((line = line.trim()).length() <= 0) continue;
                if (line.charAt(0) == '>') {
                    this.nextHeader = Header.parseFromFASTA(line);
                    if (header != null) break;
                    header = this.nextHeader;
                    continue;
                }
                sequenceBuilder.append(line);
            }
            if (line == null) {
                this.br.close();
                this.endOfFileReached = true;
            }
            this.bufferingMutex.release();
            String sequence = sequenceBuilder.toString();
            if (this.sanityCheck) {
                sequence = this.getCleanedSequence(sequence);
            }
            if (sequence.length() > 0) {
                if (header == null) {
                    throw new RuntimeException("No header information found in the fasta file.");
                }
                this.lastHeader = header;
                return new Protein(header.getAccessionOrRest(), sequence);
            }
            if (header == null) {
                return null;
            }
            throw new IllegalArgumentException("No sequence found for protein accession " + header.getAccessionOrRest() + ".");
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred in the FASTA file\n\n" + e);
        }
    }

    private String getCleanedSequence(String sequence) {
        char[] lineAsCharArray = sequence.toCharArray();
        StringBuilder cleanedSequence = new StringBuilder(sequence.length());
        for (int i = 0; i < lineAsCharArray.length; ++i) {
            char charAtI = lineAsCharArray[i];
            if (charAtI == '*') continue;
            char upperCase = Character.toUpperCase(charAtI);
            AminoAcid.getAminoAcid(upperCase);
            cleanedSequence.append(upperCase);
        }
        return cleanedSequence.toString();
    }

    public Header getLastHeader() {
        return this.lastHeader;
    }

    public void close() {
        try {
            this.br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

