/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.biology.protein.iterators;

import com.compomics.util.io.flat.SimpleFileReader;
import com.compomics.util.waiting.WaitingHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.concurrent.Semaphore;

public class HeaderIterator {
    private final Semaphore bufferingMutex = new Semaphore(1);
    private final SimpleFileReader simpleFileReader;
    private boolean endOfFileReached = false;

    public HeaderIterator(File fastaFile) throws FileNotFoundException {
        this.simpleFileReader = SimpleFileReader.getFileReader(fastaFile);
    }

    public String getNextHeader(WaitingHandler waitingHandler) {
        try {
            String line;
            this.bufferingMutex.acquire();
            if (this.endOfFileReached) {
                return null;
            }
            while ((line = this.simpleFileReader.readLine()) != null) {
                if (waitingHandler != null) {
                    double progress = this.simpleFileReader.getProgressInPercent();
                    waitingHandler.setSecondaryProgressCounter((int)progress);
                }
                if ((line = line.trim()).length() > 0 && line.charAt(0) == '>') {
                    this.bufferingMutex.release();
                    return line;
                }
                if (waitingHandler == null || !waitingHandler.isRunCanceled()) continue;
                return null;
            }
            this.simpleFileReader.close();
            this.endOfFileReached = true;
            this.bufferingMutex.release();
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        try {
            this.simpleFileReader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

