/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.identification;

import com.compomics.util.experiment.io.identification.IdfileReader;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.ServiceLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IdfileReaderFactory {
    static Logger logger = LogManager.getLogger(IdfileReaderFactory.class);
    private static IdfileReaderFactory singleton = null;
    private static final HashMap<String, Class> idFileReaders = new HashMap();

    private IdfileReaderFactory() {
    }

    public static IdfileReaderFactory getInstance() {
        if (singleton == null) {
            singleton = new IdfileReaderFactory();
        }
        return singleton;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Class registerIdFileReader(Class aReader, String aExtension) {
        Class result = null;
        if (!IdfileReader.class.isAssignableFrom(aReader)) throw new IllegalArgumentException("Was expecting an implementation of '" + IdfileReader.class.getCanonicalName() + "', but got class '" + aReader.getCanonicalName() + "'.");
        try {
            aReader.getConstructor(File.class);
            result = idFileReaders.put(aExtension, aReader);
            logger.info("Registered IdfileReader implementation '" + aReader.getCanonicalName() + "' for extension '" + aExtension + "'.");
            if (result == null) return result;
            logger.warn("Overwrite occurred for extension '" + aExtension + "'; replaced old IdfileReader '" + result.getCanonicalName() + "' with new IdfileReader '" + aReader.getCanonicalName() + "'!");
            return result;
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalArgumentException("Unable to find required constructor with single java.io.File parameter in IdfileReader implementation '" + aReader.getCanonicalName() + ".");
        }
    }

    public IdfileReader getFileReader(File aFile) {
        IdfileReader result = null;
        String name = aFile.getName().toLowerCase();
        for (String key : idFileReaders.keySet()) {
            String extension = key.toLowerCase();
            String gzippedExtension = extension + ".gz";
            if (!name.endsWith(extension) && !name.endsWith(gzippedExtension)) continue;
            Class idfileReaderClass = idFileReaders.get(key);
            try {
                result = (IdfileReader)idfileReaderClass.getConstructor(File.class).newInstance(aFile);
                break;
            }
            catch (NoSuchMethodException nsme) {
                logger.error("Unable to find required constructor with single java.io.File parameter in IdfileReader implementation '" + idfileReaderClass.getCanonicalName() + "', matching query extension '" + extension + "'!", (Throwable)nsme);
                nsme.printStackTrace();
            }
            catch (IllegalAccessException iae) {
                logger.error("Required public constructor with single java.io.File parameter in IdfileReader implementation '" + idfileReaderClass.getCanonicalName() + "', matching query extension '" + extension + "' has incorrect access modifier!", (Throwable)iae);
                iae.printStackTrace();
            }
            catch (InvocationTargetException ite) {
                if (ite.getCause() instanceof OutOfMemoryError) {
                    ite.printStackTrace();
                    throw (OutOfMemoryError)ite.getCause();
                }
                logger.error("Required constructor with single java.io.File parameter in IdfileReader implementation '" + idfileReaderClass.getCanonicalName() + "', matching query extension '" + extension + "' threw an exception!", (Throwable)ite);
                ite.printStackTrace();
            }
            catch (InstantiationException ie) {
                logger.error("Required constructor with single java.io.File parameter in IdfileReader implementation '" + idfileReaderClass.getCanonicalName() + "', matching query extension '" + extension + "' inaccessible; probably abstract class?!", (Throwable)ie);
                ie.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    static {
        ServiceLoader<IdfileReader> ifdrServiceLoader = ServiceLoader.load(IdfileReader.class);
        for (IdfileReader idfileReader : ifdrServiceLoader) {
            logger.info("Found IdfileReader '" + idfileReader.getClass().getCanonicalName() + "' in Java service loader.");
            IdfileReaderFactory.registerIdFileReader(idfileReader.getClass(), idfileReader.getExtension());
        }
    }
}

