/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.identification.idfilereaders;

import com.compomics.util.experiment.biology.aminoacids.sequence.AminoAcidSequence;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.io.identification.IdfileReader;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.io.flat.SimpleFileReader;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.waiting.WaitingHandler;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;

public class MascotIdfileReader
implements IdfileReader {
    private ArrayList<String> varMods = new ArrayList();
    private String softwareVersion;
    private ArrayList<Integer> charges = new ArrayList();
    private ArrayList<Integer> matches = new ArrayList();
    private String fileName = null;
    private HashMap<Integer, SpectrumMatch> allMatches = new HashMap();

    public MascotIdfileReader() {
    }

    public MascotIdfileReader(File inputFile) throws UnsupportedEncodingException {
        this(inputFile, null);
    }

    public MascotIdfileReader(File inputFile, WaitingHandler waitingHandler) throws UnsupportedEncodingException {
        this.varMods.add("dummy");
        this.charges.add(-100000);
        this.matches.add(-1);
        try (SimpleFileReader reader = SimpleFileReader.getFileReader(inputFile);){
            String boundary;
            String line = reader.readLine();
            line = reader.readLine();
            int boundaryStart = line.indexOf("boundary=");
            if (boundaryStart >= 0) {
                boundary = line.substring(line.indexOf("=", boundaryStart) + 1);
            } else {
                throw new IllegalArgumentException("File format not parsable, no boundary provided.");
            }
            while (!((line = reader.readLine()) == null || line.length() > 2 && line.substring(0, 2).equals("--") && line.substring(2).equals(boundary))) {
            }
            while ((line = reader.readLine()) != null) {
                int nameIndex = line.indexOf("name=\"");
                if (nameIndex < 0) {
                    throw new IllegalArgumentException("File format not parsable.");
                }
                String state = line.substring(line.indexOf("=\"", nameIndex) + 2, line.indexOf("\"", nameIndex + 6));
                if (state.startsWith("query")) {
                    this.parseQuery(reader, boundary, state);
                } else {
                    switch (state) {
                        case "masses": {
                            this.parseMasses(reader, boundary);
                            break;
                        }
                        case "peptides": {
                            this.parsePeptides(reader, boundary, inputFile.getName());
                            break;
                        }
                        case "summary": {
                            this.parseSummary(reader, boundary);
                            break;
                        }
                        case "parameters": {
                            this.parseParameters(reader, boundary);
                            break;
                        }
                        case "header": {
                            this.parseHeader(reader, boundary);
                            break;
                        }
                        case "index": 
                        case "enzyme": 
                        case "unimod": 
                        case "proteins": {
                            this.parse(reader, boundary);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("File format not parsable name '" + state + "'.");
                        }
                    }
                }
                if (waitingHandler == null || !waitingHandler.isRunCanceled()) continue;
                break;
            }
        }
    }

    @Override
    public String getExtension() {
        return ".dat";
    }

    @Override
    public ArrayList<SpectrumMatch> getAllSpectrumMatches(SpectrumProvider spectrumProvider, WaitingHandler waitingHandler, SearchParameters searchParameters) throws IOException, SQLException, ClassNotFoundException, InterruptedException, JAXBException {
        return this.getAllSpectrumMatches(spectrumProvider, waitingHandler, searchParameters, null, false);
    }

    @Override
    public ArrayList<SpectrumMatch> getAllSpectrumMatches(SpectrumProvider spectrumProvider, WaitingHandler waitingHandler, SearchParameters searchParameters, SequenceMatchingParameters sequenceMatchingPreferences, boolean expandAaCombinations) throws IOException, IllegalArgumentException, SQLException, ClassNotFoundException, InterruptedException, JAXBException {
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(false);
            waitingHandler.setMaxSecondaryProgressCounter(this.allMatches.size());
        }
        if (expandAaCombinations) {
            for (SpectrumMatch currentMatch : this.allMatches.values()) {
                block1: for (PeptideAssumption currentAssumption : currentMatch.getAllPeptideAssumptions().collect(Collectors.toList())) {
                    Peptide peptide = currentAssumption.getPeptide();
                    String peptideSequence = peptide.getSequence();
                    ModificationMatch[] previousModificationMatches = peptide.getVariableModifications();
                    if (!AminoAcidSequence.hasCombination(peptideSequence)) continue;
                    for (StringBuilder expandedSequence : AminoAcidSequence.getCombinations(peptide.getSequence())) {
                        String newSequence = expandedSequence.toString();
                        if (newSequence.equals(peptideSequence)) continue;
                        ModificationMatch[] newModificationMatches = (ModificationMatch[])Arrays.stream(previousModificationMatches).map(modificationMatch -> modificationMatch.clone()).toArray(ModificationMatch[]::new);
                        Peptide newPeptide = new Peptide(newSequence, newModificationMatches);
                        PeptideAssumption newAssumption = new PeptideAssumption(newPeptide, currentAssumption.getRank(), currentAssumption.getAdvocate(), currentAssumption.getIdentificationCharge(), currentAssumption.getRawScore(), currentAssumption.getScore(), currentAssumption.getIdentificationFile());
                        currentMatch.addPeptideAssumption(Advocate.mascot.getIndex(), newAssumption);
                        if (waitingHandler == null) continue;
                        if (waitingHandler.isRunCanceled()) continue block1;
                        waitingHandler.increaseSecondaryProgressCounter();
                    }
                }
            }
        }
        return new ArrayList<SpectrumMatch>(this.allMatches.values());
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public HashMap<String, ArrayList<String>> getSoftwareVersions() {
        HashMap<String, ArrayList<String>> result = new HashMap<String, ArrayList<String>>();
        ArrayList<String> versions = new ArrayList<String>();
        versions.add(this.softwareVersion);
        result.put("Mascot", versions);
        return result;
    }

    @Override
    public boolean hasDeNovoTags() {
        return false;
    }

    private void parseMasses(SimpleFileReader reader, String boundary) {
        String line;
        String mass = "";
        int theCase = 0;
        while (!((line = reader.readLine()) == null || line.length() > 2 && line.substring(0, 2).equals("--") && line.substring(2).equals(boundary))) {
            String[] parts;
            if (line.length() < 2 || (parts = line.split("=")).length != 2) continue;
            switch (theCase) {
                case 0: {
                    if (parts[0].startsWith("delta")) {
                        this.varMods.add(parts[1].split(",")[0]);
                        break;
                    }
                    if (!parts[0].startsWith("FixedMod")) break;
                    mass = parts[1].split(",")[0];
                    theCase = 1;
                    break;
                }
                case 1: {
                    if (!parts[0].startsWith("FixedModResidues")) {
                        throw new IllegalArgumentException("File format not parsable.");
                    }
                    theCase = 0;
                }
            }
        }
    }

    private void parseQuery(SimpleFileReader reader, String boundary, String state) throws UnsupportedEncodingException {
        String line;
        while (!((line = reader.readLine()) == null || line.length() > 2 && line.substring(0, 2).equals("--") && line.substring(2).equals(boundary))) {
            String[] parts;
            if (line.length() < 2 || (parts = line.split("=")).length != 2 || !"title".equals(parts[0])) continue;
            int specNum = Integer.parseInt(state.substring(5, state.length()));
            String spectrumTitle = URLDecoder.decode(parts[1].trim(), "UTF-8");
            SpectrumMatch spectrumMatch = this.allMatches.get(specNum);
            if (spectrumMatch == null) continue;
            spectrumMatch.setSpectrumTitle(spectrumTitle);
        }
    }

    private void parseHeader(SimpleFileReader reader, String boundary) {
        String line;
        while (!((line = reader.readLine()) == null || line.length() > 2 && line.substring(0, 2).equals("--") && line.substring(2).equals(boundary))) {
            String[] parts;
            if (line.length() < 2 || (parts = line.split("=")).length != 2 || !"version".equals(parts[0])) continue;
            this.softwareVersion = parts[1];
        }
    }

    private void parseParameters(SimpleFileReader reader, String boundary) {
        String line;
        while (!((line = reader.readLine()) == null || line.length() > 2 && line.substring(0, 2).equals("--") && line.substring(2).equals(boundary))) {
            String[] parts;
            if (line.length() < 2 || (parts = line.split("=")).length != 2 || !"FILE".equals(parts[0])) continue;
            File f = new File(parts[1].replaceAll("\\\\", "/"));
            this.fileName = f.getName();
        }
    }

    private void parsePeptides(SimpleFileReader reader, String boundary, String sourceFile) {
        String line;
        if (this.fileName == null) {
            throw new IllegalArgumentException("File format not parsable.");
        }
        while (!((line = reader.readLine()) == null || line.length() > 2 && line.substring(0, 2).equals("--") && line.substring(2).equals(boundary))) {
            int rank;
            String[] pre;
            String[] parts;
            if (line.length() < 2 || (parts = line.split("=")).length < 2 || (pre = parts[0].split("_")).length != 2) continue;
            int spectrumNumber = Integer.parseInt(pre[0].substring(1, pre[0].length()));
            String[] content = parts[1].split(";")[0].split(",");
            if (content.length != 11) continue;
            String peptideSequence = content[4];
            String varModSequence = content[6];
            ArrayList<ModificationMatch> foundModifications = new ArrayList<ModificationMatch>(1);
            for (int pos = 1; pos < varModSequence.length() - 1; ++pos) {
                char vC = varModSequence.charAt(pos);
                if (vC == '0' || vC == 'X') continue;
                foundModifications.add(new ModificationMatch(this.varMods.get(vC - 48) + "@" + peptideSequence.charAt(pos - 1), pos));
            }
            double ionScore = Double.parseDouble(content[7]);
            int specCharge = this.charges.get(spectrumNumber);
            double lThreshold = 10.0 * Math.log(this.matches.get(spectrumNumber).intValue()) / Math.log(10.0);
            double expectancy = 0.05 * Math.pow(10.0, (lThreshold - ionScore) / 10.0);
            SpectrumMatch currentMatch = this.allMatches.get(spectrumNumber);
            if (currentMatch == null) {
                currentMatch = new SpectrumMatch(this.fileName, Integer.toString(spectrumNumber));
                this.allMatches.put(spectrumNumber, currentMatch);
                rank = 1;
            } else {
                TreeMap<Double, ArrayList<PeptideAssumption>> assump = this.allMatches.get(spectrumNumber).getAllPeptideAssumptions(Advocate.mascot.getIndex());
                rank = assump.containsKey(expectancy) ? assump.get(expectancy).get(0).getRank() : (int)this.allMatches.get(spectrumNumber).getAllPeptideAssumptions().count() + 1;
            }
            Peptide peptide = new Peptide(peptideSequence, foundModifications.toArray(new ModificationMatch[foundModifications.size()]));
            PeptideAssumption currentAssumption = new PeptideAssumption(peptide, rank, Advocate.mascot.getIndex(), specCharge, ionScore, expectancy, sourceFile);
            currentMatch.addPeptideAssumption(Advocate.mascot.getIndex(), currentAssumption);
        }
    }

    private void parseSummary(SimpleFileReader reader, String boundary) {
        String line;
        while (!((line = reader.readLine()) == null || line.length() > 2 && line.substring(0, 2).equals("--") && line.substring(2).equals(boundary))) {
            if (line.length() < 2) continue;
            String[] parts = line.split("=");
            if (parts[0].startsWith("qexp")) {
                int sign = parts[1].charAt(parts[1].length() - 1) == '+' ? 1 : -1;
                String chrg = parts[1].split(",")[1];
                chrg = chrg.substring(0, chrg.length() - 1);
                this.charges.add(sign * Integer.parseInt(chrg));
                continue;
            }
            if (!parts[0].startsWith("qmatch")) continue;
            this.matches.add(Integer.parseInt(parts[1]));
        }
    }

    private void parse(SimpleFileReader reader, String boundary) {
        int lineLength;
        String line;
        while (!((line = reader.readLine()) == null || (lineLength = line.length()) > 2 && line.substring(0, 2).equals("--") && line.substring(2).equals(boundary))) {
        }
    }
}

