/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.identification.idfilereaders;

import com.compomics.util.experiment.biology.aminoacids.AminoAcid;
import com.compomics.util.experiment.biology.aminoacids.sequence.AminoAcidSequence;
import com.compomics.util.experiment.biology.atoms.Atom;
import com.compomics.util.experiment.biology.ions.impl.ElementaryIon;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.amino_acid_tags.Tag;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.spectrum_assumptions.TagAssumption;
import com.compomics.util.experiment.io.identification.IdfileReader;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.experiment.refinement_parameters.PepnovoAssumptionDetails;
import com.compomics.util.io.IoUtil;
import com.compomics.util.io.flat.SimpleFileReader;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.parameters.identification.tool_specific.PepnovoParameters;
import com.compomics.util.waiting.WaitingHandler;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBException;

public class PepNovoIdfileReader
extends ExperimentObject
implements IdfileReader {
    private File identificationFile;
    public static final String DEFAULT_HEADER = "#Index\tRnkScr\tPnvScr\tN-Gap\tC-Gap\t[M+H]\tCharge\tSequence";
    public final double cTermCorrection = Atom.O.getMonoisotopicMass() + 2.0 * Atom.H.getMonoisotopicMass() + ElementaryIon.proton.getTheoreticMass();
    public final double nTermCorrection = 0.0;

    public PepNovoIdfileReader() {
    }

    public PepNovoIdfileReader(File identificationFile) {
        this.identificationFile = identificationFile;
    }

    @Override
    public ArrayList<SpectrumMatch> getAllSpectrumMatches(SpectrumProvider spectrumProvider, WaitingHandler waitingHandler, SearchParameters searchParameters) throws IOException, SQLException, ClassNotFoundException, InterruptedException, JAXBException {
        return this.getAllSpectrumMatches(spectrumProvider, waitingHandler, searchParameters, null, false);
    }

    @Override
    public ArrayList<SpectrumMatch> getAllSpectrumMatches(SpectrumProvider spectrumProvider, WaitingHandler waitingHandler, SearchParameters searchParameters, SequenceMatchingParameters sequenceMatchingPreferences, boolean expandAaCombinations) throws IOException, SQLException, ClassNotFoundException, InterruptedException, JAXBException {
        if (this.identificationFile == null) {
            throw new IllegalStateException("The identification file was not set. Please use the appropriate constructor.");
        }
        String fileName = IoUtil.getFileName(this.identificationFile);
        String mgfFileName = PepNovoIdfileReader.getMgfFileName(fileName);
        ArrayList<SpectrumMatch> spectrumMatches = new ArrayList<SpectrumMatch>();
        try (SimpleFileReader reader = SimpleFileReader.getFileReader(this.identificationFile);){
            String line;
            SpectrumMatch currentMatch = null;
            int rank = 1;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith(">>")) {
                    if (currentMatch != null) {
                        spectrumMatches.add(currentMatch);
                        rank = 1;
                    }
                    String[] temp = line.split("\\s+");
                    StringBuilder sb = new StringBuilder(line.length());
                    sb.append(temp[3]);
                    for (int i = 4; i < temp.length; ++i) {
                        sb.append(" ").append(temp[i]);
                    }
                    String formatted = sb.toString();
                    int endIndex = formatted.lastIndexOf("#Problem");
                    if (endIndex == -1) {
                        endIndex = formatted.lastIndexOf("(SQS");
                    }
                    if (endIndex > -1) {
                        String spectrumTitle = formatted.substring(0, endIndex).trim();
                        String decodedTitle = URLDecoder.decode(spectrumTitle, "UTF-8");
                        currentMatch = new SpectrumMatch(mgfFileName, decodedTitle);
                        while ((line = reader.readLine()).startsWith("# No") || line.startsWith("# Charge") || line.startsWith("#Problem") || line.startsWith("# too")) {
                        }
                        if (line.equals(DEFAULT_HEADER)) continue;
                        throw new IllegalArgumentException("Unrecognized table format. Expected: \"#Index\tRnkScr\tPnvScr\tN-Gap\tC-Gap\t[M+H]\tCharge\tSequence\", found:\"" + line + "\".");
                    }
                    currentMatch = null;
                    continue;
                }
                if (line.length() <= 0 || line.charAt(0) == '#' || currentMatch == null) continue;
                currentMatch.addTagAssumption(Advocate.pepnovo.getIndex(), this.getAssumptionFromLine(line, rank));
                ++rank;
            }
        }
        return spectrumMatches;
    }

    public static String getMgfFileName(String fileName) {
        if (fileName.endsWith(".out.gz")) {
            return fileName.substring(0, fileName.length() - 7);
        }
        if (fileName.endsWith(".out")) {
            return fileName.substring(0, fileName.length() - 4);
        }
        throw new IllegalArgumentException("Unexpected file extension. Expected: .out or .out.gz. File name: " + fileName + ".");
    }

    @Override
    public String getExtension() {
        return ".out";
    }

    @Override
    public void close() throws IOException {
    }

    private TagAssumption getAssumptionFromLine(String line, int rank) {
        String[] lineComponents = line.trim().split("\t");
        Double rankScore = Double.valueOf(lineComponents[1]);
        Double pepNovoScore = Double.valueOf(lineComponents[2]);
        Double nGap = Double.valueOf(lineComponents[3]);
        Double cGap = Double.valueOf(lineComponents[4]);
        if (cGap > 0.0 && cGap < this.cTermCorrection) {
            throw new IllegalArgumentException("Incompatible c-term gap " + cGap);
        }
        if (cGap > 0.0) {
            cGap = cGap - this.cTermCorrection;
        }
        Double mH = Double.valueOf(lineComponents[5]);
        Integer charge = Integer.valueOf(lineComponents[6]);
        String pepNovoSequence = lineComponents[7];
        String sequence = "";
        ArrayList<Object> modificationMatches = new ArrayList<Object>();
        String modificationMass = "";
        String currentAA = "";
        int currentPtmLocation = 0;
        boolean nTermPtm = false;
        boolean cTermPtm = false;
        String ptmTag = "";
        for (int i = 0; i < pepNovoSequence.length(); ++i) {
            String aa = pepNovoSequence.charAt(i) + "";
            if (aa.equals("^") || aa.equals("$")) {
                ptmTag = aa;
                if (aa.equals("^")) {
                    nTermPtm = true;
                    continue;
                }
                cTermPtm = true;
                continue;
            }
            if (aa.equals("+") || aa.equals("-")) {
                modificationMass = modificationMass + aa;
                continue;
            }
            try {
                Integer.valueOf(aa);
                modificationMass = modificationMass + aa;
                continue;
            }
            catch (Exception exception) {
                AminoAcid aminoAcid;
                if (!modificationMass.equals("")) {
                    String pepNovoPtmTag = "";
                    pepNovoPtmTag = nTermPtm || cTermPtm ? pepNovoPtmTag + ptmTag : pepNovoPtmTag + currentAA;
                    pepNovoPtmTag = pepNovoPtmTag + modificationMass;
                    ModificationMatch modMatch = new ModificationMatch(pepNovoPtmTag, currentPtmLocation);
                    modMatch.setConfident(true);
                    modificationMatches.add(modMatch);
                    modificationMass = "";
                    nTermPtm = false;
                }
                if ((aminoAcid = AminoAcid.getAminoAcid(aa)) == null) {
                    throw new IllegalArgumentException("Attempting to parse " + aa + " as amino acid in " + pepNovoSequence + ".");
                }
                sequence = sequence + aa;
                currentAA = aa;
                ++currentPtmLocation;
            }
        }
        if (!modificationMass.equals("")) {
            String pepNovoPtmTag = "";
            pepNovoPtmTag = nTermPtm || cTermPtm ? pepNovoPtmTag + ptmTag : pepNovoPtmTag + currentAA;
            pepNovoPtmTag = pepNovoPtmTag + modificationMass;
            ModificationMatch modMatch = new ModificationMatch(pepNovoPtmTag, currentPtmLocation);
            modificationMatches.add(modMatch);
        }
        AminoAcidSequence aminoAcidSequence = new AminoAcidSequence(sequence);
        for (ModificationMatch modificationMatch : modificationMatches) {
            aminoAcidSequence.addVariableModification(modificationMatch);
        }
        Tag tag = new Tag(nGap, aminoAcidSequence, cGap);
        TagAssumption tagAssumption = new TagAssumption(Advocate.pepnovo.getIndex(), rank, tag, charge, pepNovoScore, pepNovoScore);
        PepnovoAssumptionDetails pepnovoAssumptionDetails = new PepnovoAssumptionDetails();
        pepnovoAssumptionDetails.setRankScore(rankScore);
        pepnovoAssumptionDetails.setMH(mH);
        tagAssumption.addUrParam(pepnovoAssumptionDetails);
        return tagAssumption;
    }

    public static String getPTM(PepnovoParameters pepnovoParameters, String pepNovoModification) {
        Map<String, String> invertedPtmMap = pepnovoParameters.getPepNovoPtmMap();
        if (invertedPtmMap == null) {
            throw new IllegalArgumentException("Unsupported de novo search result. Please reprocess the data.");
        }
        String utilitesPtmName = invertedPtmMap.get(pepNovoModification);
        if (utilitesPtmName != null) {
            return utilitesPtmName;
        }
        throw new IllegalArgumentException("An error occurred while parsing the modification " + pepNovoModification + ".");
    }

    @Override
    public HashMap<String, ArrayList<String>> getSoftwareVersions() {
        HashMap<String, ArrayList<String>> result = new HashMap<String, ArrayList<String>>(1);
        ArrayList<String> versions = new ArrayList<String>(1);
        versions.add("3.1 (beta)");
        result.put("PepNovo+", versions);
        return result;
    }

    @Override
    public boolean hasDeNovoTags() {
        return true;
    }
}

