/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.identification.idfilereaders;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.aminoacids.sequence.AminoAcidSequence;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.io.identification.IdfileReader;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.io.IoUtil;
import com.compomics.util.io.flat.SimpleFileReader;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.waiting.WaitingHandler;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.xml.bind.JAXBException;

public class SageIdfileReader
implements IdfileReader {
    private String softwareName = "Sage";
    private String softwareVersion = null;
    private File sageTsvFile;
    private ModificationFactory modificationFactory = ModificationFactory.getInstance();
    public static final double MOD_MASS_TOLERANCE = 0.01;

    public SageIdfileReader() {
    }

    public SageIdfileReader(File sageTsvFile) throws IOException {
        this(sageTsvFile, null);
    }

    public SageIdfileReader(File sageTsvFile, WaitingHandler waitingHandler) throws IOException {
        this.sageTsvFile = sageTsvFile;
    }

    @Override
    public String getExtension() {
        return ".sage.tsv";
    }

    @Override
    public ArrayList<SpectrumMatch> getAllSpectrumMatches(SpectrumProvider spectrumProvider, WaitingHandler waitingHandler, SearchParameters searchParameters) throws IOException, IllegalArgumentException, SQLException, ClassNotFoundException, InterruptedException, JAXBException {
        return this.getAllSpectrumMatches(spectrumProvider, waitingHandler, searchParameters, null, true);
    }

    @Override
    public ArrayList<SpectrumMatch> getAllSpectrumMatches(SpectrumProvider spectrumProvider, WaitingHandler waitingHandler, SearchParameters searchParameters, SequenceMatchingParameters sequenceMatchingPreferences, boolean expandAaCombinations) throws IOException, IllegalArgumentException, SQLException, ClassNotFoundException, InterruptedException, JAXBException {
        ArrayList<SpectrumMatch> result = new ArrayList<SpectrumMatch>();
        try (SimpleFileReader reader = SimpleFileReader.getFileReader(this.sageTsvFile);){
            String line;
            String headerString = reader.readLine();
            String[] headers = headerString.split("\t");
            int peptideSequenceIndex = -1;
            int chargeIndex = -1;
            int posteriorErrorIndex = -1;
            int sageDiscriminantScore = -1;
            int rankIndex = -1;
            int spectrumTitleIndex = -1;
            int spectrumFileIndex = -1;
            int ms1_intensityIndex = -1;
            for (int i = 0; i < headers.length; ++i) {
                String header = headers[i];
                if (header.equalsIgnoreCase("peptide")) {
                    peptideSequenceIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("charge")) {
                    chargeIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("posterior_error")) {
                    posteriorErrorIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("sage_discriminant_score")) {
                    sageDiscriminantScore = i;
                    continue;
                }
                if (header.equalsIgnoreCase("rank")) {
                    rankIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("scannr")) {
                    spectrumTitleIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("filename")) {
                    spectrumFileIndex = i;
                    continue;
                }
                if (!header.equalsIgnoreCase("ms1_intensity")) continue;
                ms1_intensityIndex = i;
            }
            if (peptideSequenceIndex == -1 || chargeIndex == -1 || posteriorErrorIndex == -1 || rankIndex == -1 || spectrumTitleIndex == -1 || spectrumFileIndex == -1) {
                throw new IllegalArgumentException("Mandatory columns are missing in the Sage tsv file. Please check the file!");
            }
            String currentSpectrumTitle = null;
            SpectrumMatch currentMatch = null;
            while ((line = reader.readLine()) != null) {
                String peptideSequence;
                String[] elements = line.split("\t");
                if (line.trim().isEmpty()) continue;
                String spectrumTitle = elements[spectrumTitleIndex].trim();
                String modifiedPeptideSequence = elements[peptideSequenceIndex].toUpperCase();
                String scoreAsText = elements[posteriorErrorIndex];
                double rawScore = Util.readDoubleAsString(scoreAsText);
                int rank = Integer.parseInt(elements[rankIndex]);
                int charge = Integer.parseInt(elements[chargeIndex]);
                String fileName = elements[spectrumFileIndex];
                spectrumTitle = URLDecoder.decode(spectrumTitle, "utf-8");
                if (currentMatch == null || currentSpectrumTitle != null && !currentSpectrumTitle.equalsIgnoreCase(spectrumTitle)) {
                    if (currentMatch != null) {
                        result.add(currentMatch);
                    }
                    currentMatch = new SpectrumMatch(fileName, spectrumTitle);
                    currentSpectrumTitle = spectrumTitle;
                }
                ArrayList<ModificationMatch> utilitiesModifications = new ArrayList<ModificationMatch>(1);
                StringBuilder peptideSequenceBuilder = new StringBuilder();
                if (modifiedPeptideSequence.lastIndexOf("[") == -1) {
                    peptideSequence = modifiedPeptideSequence;
                } else {
                    for (int i = 0; i < modifiedPeptideSequence.length(); ++i) {
                        if (modifiedPeptideSequence.charAt(i) == '[') {
                            int endingBracketIndex = modifiedPeptideSequence.indexOf(93, i + 1);
                            String modMassAsString = modifiedPeptideSequence.substring(i + 1, endingBracketIndex);
                            double modMass = Double.parseDouble(modMassAsString);
                            boolean variable = true;
                            for (String tempModName : searchParameters.getModificationParameters().getFixedModifications()) {
                                this.modificationFactory.getModification(tempModName).getMass();
                                if (!(Math.abs(modMass - this.modificationFactory.getModification(tempModName).getMass()) < 0.01)) continue;
                                variable = false;
                            }
                            if (variable) {
                                char modResidue;
                                int modSite;
                                if (i == 0) {
                                    modSite = 1;
                                    modResidue = modifiedPeptideSequence.charAt(endingBracketIndex + 2);
                                } else if (endingBracketIndex + 1 == modifiedPeptideSequence.length()) {
                                    modSite = peptideSequenceBuilder.length();
                                    modResidue = peptideSequenceBuilder.charAt(modSite - 1);
                                } else {
                                    modSite = peptideSequenceBuilder.length();
                                    modResidue = modifiedPeptideSequence.charAt(i - 1);
                                }
                                utilitiesModifications.add(new ModificationMatch(modMass + "@" + modResidue, modSite));
                            }
                            i = endingBracketIndex;
                            continue;
                        }
                        if (modifiedPeptideSequence.charAt(i) == '-') continue;
                        peptideSequenceBuilder.append(modifiedPeptideSequence.charAt(i));
                    }
                    peptideSequence = peptideSequenceBuilder.toString();
                }
                Peptide peptide = new Peptide(peptideSequence, utilitiesModifications.toArray(new ModificationMatch[utilitiesModifications.size()]), true);
                PeptideAssumption peptideAssumption = new PeptideAssumption(peptide, rank, Advocate.sage.getIndex(), charge, rawScore, rawScore, IoUtil.getFileName(this.sageTsvFile));
                if (expandAaCombinations && AminoAcidSequence.hasCombination(peptideSequence)) {
                    ModificationMatch[] previousModificationMatches = peptide.getVariableModifications();
                    for (StringBuilder expandedSequence : AminoAcidSequence.getCombinations(peptide.getSequence())) {
                        ModificationMatch[] newModificationMatches = (ModificationMatch[])Arrays.stream(previousModificationMatches).map(modificationMatch -> modificationMatch.clone()).toArray(ModificationMatch[]::new);
                        Peptide newPeptide = new Peptide(expandedSequence.toString(), newModificationMatches, true);
                        PeptideAssumption newAssumption = new PeptideAssumption(newPeptide, peptideAssumption.getRank(), peptideAssumption.getAdvocate(), peptideAssumption.getIdentificationCharge(), peptideAssumption.getRawScore(), peptideAssumption.getScore(), peptideAssumption.getIdentificationFile());
                        currentMatch.addPeptideAssumption(Advocate.sage.getIndex(), newAssumption);
                    }
                } else {
                    currentMatch.addPeptideAssumption(Advocate.sage.getIndex(), peptideAssumption);
                }
                if (waitingHandler == null || !waitingHandler.isRunCanceled()) continue;
                break;
            }
            if (currentMatch != null) {
                result.add(currentMatch);
            }
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        this.sageTsvFile = null;
    }

    @Override
    public HashMap<String, ArrayList<String>> getSoftwareVersions() {
        HashMap<String, ArrayList<String>> result = new HashMap<String, ArrayList<String>>();
        ArrayList<String> versions = new ArrayList<String>();
        versions.add(this.softwareVersion);
        result.put(this.softwareName, versions);
        return result;
    }

    @Override
    public boolean hasDeNovoTags() {
        return false;
    }
}

