/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.mass_spectrometry;

import com.compomics.util.experiment.io.mass_spectrometry.MsFileIterator;
import com.compomics.util.experiment.io.mass_spectrometry.cms.CmsFileReader;
import com.compomics.util.experiment.io.mass_spectrometry.cms.CmsFileWriter;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.mass_spectrometry.spectra.Precursor;
import com.compomics.util.experiment.mass_spectrometry.spectra.Spectrum;
import com.compomics.util.io.IoUtil;
import com.compomics.util.waiting.WaitingHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.stream.Stream;

public class MsFileHandler
implements SpectrumProvider {
    private final HashMap<String, String> filePathMap = new HashMap();
    private final HashMap<String, String> cmsFilePathMap = new HashMap();
    private final HashMap<String, CmsFileReader> cmsFileReaderMap = new HashMap();
    private String[] orderedFileNamesWithoutExtensions = new String[0];

    public void register(File msFile, WaitingHandler waitingHandler) throws IOException {
        this.register(msFile, null, waitingHandler);
    }

    public void register(File msFile, File cmsFolder, WaitingHandler waitingHandler) throws IOException {
        CmsFileReader reader;
        File cmsFile;
        String spectrumFileNameWithoutExtension;
        block9: {
            if (!(msFile = IoUtil.existsExtensionNotCaseSensitive(msFile)).exists()) {
                throw new FileNotFoundException("MS file " + msFile + " not found.");
            }
            spectrumFileNameWithoutExtension = IoUtil.removeExtension(msFile.getName());
            this.orderedFileNamesWithoutExtensions = (String[])Stream.concat(Arrays.stream(this.orderedFileNamesWithoutExtensions), Stream.of(spectrumFileNameWithoutExtension)).distinct().sorted().toArray(String[]::new);
            String cmsFilePath = MsFileHandler.getCmsFilePath(msFile, cmsFolder);
            this.filePathMap.put(spectrumFileNameWithoutExtension, msFile.getAbsolutePath());
            this.cmsFilePathMap.put(spectrumFileNameWithoutExtension, cmsFilePath);
            cmsFile = new File(cmsFilePath);
            reader = null;
            if (cmsFile.exists()) {
                try {
                    reader = new CmsFileReader(cmsFile, waitingHandler);
                }
                catch (Exception e) {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (cmsFile.delete()) break block9;
                    throw new IOException("File " + cmsFile + " could not be read as cms file or deleted. Please move or delete the file manually.");
                }
            }
        }
        if (reader == null && msFile.exists()) {
            this.writeCmsFile(msFile, cmsFile, waitingHandler);
            reader = new CmsFileReader(cmsFile, waitingHandler);
        }
        if (reader != null) {
            this.cmsFileReaderMap.put(spectrumFileNameWithoutExtension, reader);
        }
    }

    public static String getCmsFilePath(File msFile, File cmsFolder) {
        String fileName = msFile.getName();
        if (fileName.endsWith(".cms")) {
            return msFile.getAbsolutePath();
        }
        String newName = IoUtil.removeExtension(fileName) + ".cms";
        File folder = cmsFolder == null ? msFile.getParentFile() : cmsFolder;
        File cmsFile = new File(folder, newName);
        return cmsFile.getAbsolutePath();
    }

    private void writeCmsFile(File msFile, File cmsFile, WaitingHandler waitingHandler) throws IOException {
        try (MsFileIterator iterator = MsFileIterator.getMsFileIterator(msFile, waitingHandler);
             CmsFileWriter writer = new CmsFileWriter(cmsFile);){
            String spectrumTitle;
            while ((spectrumTitle = iterator.next()) != null) {
                Spectrum spectrum = iterator.getSpectrum();
                writer.addSpectrum(spectrumTitle, spectrum);
            }
        }
    }

    public CmsFileReader getReader(String fileNameWithoutExtension) {
        return this.cmsFileReaderMap.get(fileNameWithoutExtension);
    }

    @Override
    public Spectrum getSpectrum(String fileNameWithoutExtension, String spectrumTitle) {
        CmsFileReader reader = this.cmsFileReaderMap.get(fileNameWithoutExtension);
        return reader == null ? null : reader.getSpectrum(spectrumTitle);
    }

    @Override
    public Precursor getPrecursor(String fileNameWithoutExtension, String spectrumTitle) {
        CmsFileReader reader = this.cmsFileReaderMap.get(fileNameWithoutExtension);
        return reader == null ? null : reader.getPrecursor(spectrumTitle);
    }

    @Override
    public double getPrecursorMz(String fileNameWithoutExtension, String spectrumTitle) {
        CmsFileReader reader = this.cmsFileReaderMap.get(fileNameWithoutExtension);
        return reader == null ? Double.NaN : reader.getPrecursorMz(spectrumTitle);
    }

    @Override
    public double getPrecursorRt(String fileNameWithoutExtension, String spectrumTitle) {
        CmsFileReader reader = this.cmsFileReaderMap.get(fileNameWithoutExtension);
        return reader == null ? Double.NaN : reader.getPrecursorRt(spectrumTitle);
    }

    @Override
    public int getSpectrumLevel(String fileNameWithoutExtension, String spectrumTitle) {
        CmsFileReader reader = this.cmsFileReaderMap.get(fileNameWithoutExtension);
        return reader == null ? 2 : reader.getSpectrumLevel(spectrumTitle);
    }

    @Override
    public double[][] getPeaks(String fileNameWithoutExtension, String spectrumTitle) {
        CmsFileReader reader = this.cmsFileReaderMap.get(fileNameWithoutExtension);
        if (reader != null) {
            return reader.getPeaks(spectrumTitle);
        }
        return null;
    }

    @Override
    public double getMinPrecMz(String fileNameWithoutExtension) {
        CmsFileReader reader = this.cmsFileReaderMap.get(fileNameWithoutExtension);
        if (reader != null) {
            return reader.getMinPrecMz();
        }
        return Double.NaN;
    }

    @Override
    public double getMaxPrecMz(String fileNameWithoutExtension) {
        CmsFileReader reader = this.cmsFileReaderMap.get(fileNameWithoutExtension);
        if (reader != null) {
            return reader.getMaxPrecMz();
        }
        return Double.NaN;
    }

    @Override
    public double getMaxPrecInt(String fileNameWithoutExtension) {
        CmsFileReader reader = this.cmsFileReaderMap.get(fileNameWithoutExtension);
        if (reader != null) {
            return reader.getMaxPrecInt();
        }
        return Double.NaN;
    }

    @Override
    public double getMaxPrecRT(String fileNameWithoutExtension) {
        CmsFileReader reader = this.cmsFileReaderMap.get(fileNameWithoutExtension);
        if (reader != null) {
            return reader.getMaxPrecRT();
        }
        return Double.NaN;
    }

    @Override
    public double getMinPrecMz() {
        return this.cmsFileReaderMap.values().stream().mapToDouble(reader -> reader.getMinPrecMz()).min().orElse(Double.NaN);
    }

    @Override
    public double getMaxPrecMz() {
        return this.cmsFileReaderMap.values().stream().mapToDouble(reader -> reader.getMaxPrecMz()).max().orElse(Double.NaN);
    }

    @Override
    public double getMaxPrecInt() {
        return this.cmsFileReaderMap.values().stream().mapToDouble(reader -> reader.getMaxPrecInt()).max().orElse(Double.NaN);
    }

    @Override
    public double getMaxPrecRT() {
        return this.cmsFileReaderMap.values().stream().mapToDouble(reader -> reader.getMaxPrecRT()).max().orElse(Double.NaN);
    }

    @Override
    public String[] getOrderedFileNamesWithoutExtensions() {
        return this.orderedFileNamesWithoutExtensions;
    }

    @Override
    public HashMap<String, String> getFilePaths() {
        return this.filePathMap;
    }

    @Override
    public HashMap<String, String> getCmsFilePaths() {
        return this.cmsFilePathMap;
    }

    @Override
    public void close() {
        this.cmsFileReaderMap.values().forEach(reader -> reader.close());
    }

    @Override
    public String[] getSpectrumTitles(String fileName) {
        CmsFileReader reader = this.cmsFileReaderMap.get(IoUtil.getFileName(fileName));
        return reader == null ? null : reader.titles;
    }

    @Override
    public ArrayList<String> getPostcursorSpectrumTitles(String fileNameWithoutExtension, String spectrumTitle) {
        CmsFileReader reader = this.cmsFileReaderMap.get(fileNameWithoutExtension);
        return reader == null ? null : reader.getPostcursorSpectrumTitles(fileNameWithoutExtension, spectrumTitle);
    }
}

