/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.mass_spectrometry;

import com.compomics.util.experiment.io.mass_spectrometry.cms.CmsFileIterator;
import com.compomics.util.experiment.io.mass_spectrometry.mgf.MgfFileIterator;
import com.compomics.util.experiment.io.mass_spectrometry.mgf.MgfFileUtils;
import com.compomics.util.experiment.io.mass_spectrometry.mzml.MzmlFileIterator;
import com.compomics.util.experiment.io.mass_spectrometry.mzml.MzmlFileUtils;
import com.compomics.util.experiment.mass_spectrometry.spectra.Spectrum;
import com.compomics.util.waiting.WaitingHandler;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Stream;

public interface MsFileIterator
extends AutoCloseable {
    public String next();

    public Spectrum getSpectrum();

    @Override
    public void close();

    public static MsFileIterator getMsFileIterator(File file, WaitingHandler waitingHandler) throws IOException {
        String fileName = file.getName();
        if (Arrays.stream(MgfFileUtils.EXTENSIONS).anyMatch(extension -> fileName.toLowerCase().endsWith((String)extension))) {
            return new MgfFileIterator(file, waitingHandler);
        }
        if (Arrays.stream(MzmlFileUtils.EXTENSIONS).anyMatch(extension -> fileName.toLowerCase().endsWith((String)extension))) {
            return new MzmlFileIterator(file, waitingHandler);
        }
        if (fileName.toLowerCase().endsWith(".cms")) {
            return new CmsFileIterator(file, waitingHandler);
        }
        String supportedExtensions = String.join((CharSequence)",", MsFileIterator.getSupportedExtensions());
        throw new UnsupportedOperationException("Mass spectrometry file extension for file " + file.getName() + " not recognized. Supported: " + supportedExtensions);
    }

    public static String[] getSupportedExtensions() {
        String[] cmsExtensions = new String[]{".cms"};
        return (String[])Stream.concat(Stream.concat(Arrays.stream(MgfFileUtils.EXTENSIONS), Arrays.stream(MzmlFileUtils.EXTENSIONS)), Arrays.stream(cmsExtensions)).toArray(String[]::new);
    }
}

