/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.mass_spectrometry.apl;

import com.compomics.util.experiment.mass_spectrometry.FragmentationMethod;
import com.compomics.util.experiment.mass_spectrometry.spectra.Precursor;
import com.compomics.util.experiment.mass_spectrometry.spectra.Spectrum;
import com.compomics.util.io.flat.SimpleFileWriter;
import java.io.File;
import java.util.stream.IntStream;

public class AplFileWriter
implements AutoCloseable {
    private final SimpleFileWriter writer;

    public AplFileWriter() {
        this.writer = null;
    }

    public AplFileWriter(File destinationFile) {
        this.writer = new SimpleFileWriter(destinationFile, false);
    }

    public void writeSpectrum(String spectrumTitle, Spectrum spectrum, FragmentationMethod fragmentationMethod, int charge) {
        this.writer.writeLine("peaklist start");
        Precursor precursor = spectrum.getPrecursor();
        this.writer.writeLine(String.join((CharSequence)"", "mz=", Double.toString(precursor.mz)));
        this.writer.writeLine(String.join((CharSequence)"", "fragmentation=", fragmentationMethod.name));
        this.writer.writeLine(String.join((CharSequence)"", "charge=", Integer.toString(charge)));
        this.writer.writeLine(String.join((CharSequence)"", "header=", spectrumTitle));
        IntStream.range(0, spectrum.getNPeaks()).forEach(i -> this.writer.writeLine(String.join((CharSequence)"\t", Double.toString(spectrum.mz[i]), Double.toString(spectrum.intensity[i]))));
        this.writer.writeLine("peaklist end");
        this.writer.newLine();
    }

    @Override
    public void close() {
        this.writer.close();
    }
}

