/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.mass_spectrometry.cms;

import com.compomics.util.experiment.io.mass_spectrometry.cms.CmsFileUtils;
import com.compomics.util.experiment.io.mass_spectrometry.cms.CmsFileWriter;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.mass_spectrometry.spectra.Precursor;
import com.compomics.util.experiment.mass_spectrometry.spectra.Spectrum;
import com.compomics.util.io.IoUtil;
import com.compomics.util.io.compression.ZstdUtils;
import com.compomics.util.threading.SimpleSemaphore;
import com.compomics.util.waiting.WaitingHandler;
import io.airlift.compress.zstd.ZstdDecompressor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class CmsFileReader
implements SpectrumProvider {
    private final double minMz;
    private final double maxMz;
    private final double maxInt;
    private final double maxRt;
    public final String[] titles;
    private final HashMap<String, ArrayList<String>> postcursorMap;
    private final HashMap<String, Integer> indexMap;
    private final HashMap<String, Double> precrursorMzMap;
    private final SimpleSemaphore mutex = new SimpleSemaphore(1);
    private final RandomAccessFile raf;
    private final FileChannel fc;
    private final MappedByteBuffer mappedByteBuffer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsFileReader(File file, WaitingHandler waitingHandler) throws FileNotFoundException, IOException {
        this.raf = new RandomAccessFile(file, "r");
        try {
            byte[] fileMagicNumber = new byte[CmsFileUtils.MAGIC_NUMBER.length];
            this.raf.read(fileMagicNumber);
            if (!Arrays.equals(CmsFileUtils.MAGIC_NUMBER, fileMagicNumber)) {
                this.raf.close();
                throw new IOException("File format of " + file + " not supported.");
            }
            long footerPosition = this.raf.readLong();
            this.minMz = this.raf.readDouble();
            this.maxMz = this.raf.readDouble();
            this.maxInt = this.raf.readDouble();
            this.maxRt = this.raf.readDouble();
            this.raf.seek(footerPosition);
            int length = this.raf.readInt();
            int uncompressedLength = this.raf.readInt();
            byte[] compressedTitles = new byte[length];
            this.raf.read(compressedTitles);
            byte[] titlesByteArray = CmsFileReader.uncompress(compressedTitles, uncompressedLength);
            String titlesIndexString = new String(titlesByteArray, 0, titlesByteArray.length, "UTF-8");
            String[] titlesIndexStringSplit = titlesIndexString.split("\t");
            int nTitles = (titlesIndexStringSplit.length - 1) / 2;
            this.indexMap = new HashMap(nTitles);
            this.titles = new String[nTitles];
            for (int i = 0; i < nTitles; ++i) {
                String title = titlesIndexStringSplit[i];
                int index = Integer.parseInt(titlesIndexStringSplit[i + nTitles]);
                this.indexMap.put(title, index);
                this.titles[i] = title;
            }
            this.postcursorMap = new HashMap();
            String postcursorMapAsText = titlesIndexStringSplit[titlesIndexStringSplit.length - 1];
            if (!postcursorMapAsText.equalsIgnoreCase("null")) {
                String[] postcursorMapAsTextSplit;
                for (String temp : postcursorMapAsTextSplit = postcursorMapAsText.split(" # ")) {
                    String[] precusorAndList = temp.split(" \\{");
                    String precusorKey = precusorAndList[0];
                    String postcursors = precusorAndList[1].substring(0, precusorAndList[1].length() - 1);
                    String[] postcursorsSplit = postcursors.split(",");
                    if (!this.postcursorMap.containsKey(precusorKey)) {
                        this.postcursorMap.put(precusorKey, new ArrayList());
                    }
                    this.postcursorMap.get(precusorKey).addAll(Arrays.asList(postcursorsSplit));
                }
            }
            this.precrursorMzMap = new HashMap(nTitles);
            long size = footerPosition - (long)CmsFileWriter.HEADER_LENGTH;
            this.fc = this.raf.getChannel();
            this.mappedByteBuffer = this.fc.map(FileChannel.MapMode.READ_ONLY, CmsFileWriter.HEADER_LENGTH, size);
        }
        finally {
            this.raf.close();
        }
    }

    private Spectrum getSpectrum(int spectrumIndex) {
        this.mutex.acquire();
        this.mappedByteBuffer.position(spectrumIndex);
        double precursorMz = this.mappedByteBuffer.getDouble();
        double precursorRt = this.mappedByteBuffer.getDouble();
        double precursorIntensity = this.mappedByteBuffer.getDouble();
        int spectrumLevel = this.mappedByteBuffer.getInt();
        int compressedDataLength = this.mappedByteBuffer.getInt();
        int nPeaks = this.mappedByteBuffer.getInt();
        byte[] compressedSpectrum = new byte[compressedDataLength];
        this.mappedByteBuffer.get(compressedSpectrum);
        int nCharges = this.mappedByteBuffer.getInt();
        int[] charges = new int[nCharges];
        for (int i = 0; i < nCharges; ++i) {
            charges[i] = this.mappedByteBuffer.getInt();
        }
        this.mutex.release();
        double[] mz = new double[nPeaks];
        double[] intensity = new double[nPeaks];
        if (nPeaks > 0) {
            int uncompressedLength = nPeaks * 2 * 8;
            byte[] uncompressedSpectrum = CmsFileReader.uncompress(compressedSpectrum, uncompressedLength);
            ByteBuffer byteBuffer = ByteBuffer.wrap(uncompressedSpectrum);
            for (int i = 0; i < nPeaks; ++i) {
                mz[i] = byteBuffer.getDouble();
                intensity[i] = byteBuffer.getDouble();
            }
        }
        Precursor precursor = new Precursor(precursorRt, precursorMz, precursorIntensity, charges);
        return new Spectrum(precursor, mz, intensity, spectrumLevel);
    }

    public Spectrum getSpectrum(String spectrumTitle) {
        int index = this.indexMap.get(spectrumTitle);
        return this.getSpectrum(index);
    }

    public Precursor getPrecursor(String spectrumTitle) {
        int index = this.indexMap.get(spectrumTitle);
        this.mutex.acquire();
        this.mappedByteBuffer.position(index);
        double precursorMz = this.mappedByteBuffer.getDouble();
        double precursorRt = this.mappedByteBuffer.getDouble();
        double precursorIntensity = this.mappedByteBuffer.getDouble();
        this.mappedByteBuffer.getInt();
        int compressedDataLength = this.mappedByteBuffer.getInt();
        this.mappedByteBuffer.position(this.mappedByteBuffer.position() + compressedDataLength + 4);
        int nCharges = this.mappedByteBuffer.getInt();
        int[] charges = new int[nCharges];
        for (int i = 0; i < nCharges; ++i) {
            charges[i] = this.mappedByteBuffer.getInt();
        }
        this.mutex.release();
        Precursor precursor = new Precursor(precursorRt, precursorMz, precursorIntensity, charges);
        return precursor;
    }

    public double getPrecursorMz(String spectrumTitle) {
        Double precursorMz = this.precrursorMzMap.get(spectrumTitle);
        if (precursorMz == null) {
            int index = this.indexMap.get(spectrumTitle);
            this.mutex.acquire();
            this.mappedByteBuffer.position(index);
            precursorMz = this.mappedByteBuffer.getDouble();
            this.precrursorMzMap.put(spectrumTitle, precursorMz);
            this.mutex.release();
        }
        return precursorMz;
    }

    public double getPrecursorRt(String spectrumTitle) {
        int index = this.indexMap.get(spectrumTitle);
        this.mutex.acquire();
        this.mappedByteBuffer.position(index + 8);
        double precursorRt = this.mappedByteBuffer.getDouble();
        this.mutex.release();
        return precursorRt;
    }

    public int getSpectrumLevel(String spectrumTitle) {
        int index = this.indexMap.get(spectrumTitle);
        this.mutex.acquire();
        this.mappedByteBuffer.position(index + 24);
        int spectrumLevel = this.mappedByteBuffer.getInt();
        this.mutex.release();
        return spectrumLevel;
    }

    public double[][] getPeaks(String spectrumTitle) {
        int index = this.indexMap.get(spectrumTitle);
        this.mutex.acquire();
        this.mappedByteBuffer.position(index + 24);
        int compressedDataLength = this.mappedByteBuffer.getInt();
        int nPeaks = this.mappedByteBuffer.getInt();
        byte[] compressedSpectrum = new byte[compressedDataLength];
        this.mappedByteBuffer.get(compressedSpectrum);
        this.mutex.release();
        int uncompressedLength = nPeaks * 2 * 8;
        byte[] uncompressedSpectrum = CmsFileReader.uncompress(compressedSpectrum, uncompressedLength);
        ByteBuffer byteBuffer = ByteBuffer.wrap(uncompressedSpectrum);
        double[][] peaks = new double[nPeaks][2];
        for (int i = 0; i < nPeaks; ++i) {
            peaks[i][0] = byteBuffer.getDouble();
            peaks[i][1] = byteBuffer.getDouble();
        }
        return peaks;
    }

    public static byte[] uncompress(byte[] compressedByteArray, int uncompressedLength) {
        ZstdDecompressor decompressor = new ZstdDecompressor();
        byte[] uncompressedByteAray = ZstdUtils.zstdDecompress(decompressor, compressedByteArray, uncompressedLength);
        return uncompressedByteAray;
    }

    @Override
    public Spectrum getSpectrum(String fileName, String spectrumTitle) {
        return this.getSpectrum(spectrumTitle);
    }

    @Override
    public Precursor getPrecursor(String fileName, String spectrumTitle) {
        return this.getPrecursor(spectrumTitle);
    }

    @Override
    public double getPrecursorMz(String fileName, String spectrumTitle) {
        return this.getPrecursorMz(spectrumTitle);
    }

    @Override
    public double getPrecursorRt(String fileName, String spectrumTitle) {
        return this.getPrecursorRt(spectrumTitle);
    }

    @Override
    public int getSpectrumLevel(String fileName, String spectrumTitle) {
        return this.getSpectrumLevel(spectrumTitle);
    }

    @Override
    public double[][] getPeaks(String fileName, String spectrumTitle) {
        return this.getPeaks(spectrumTitle);
    }

    @Override
    public double getMinPrecMz(String fileName) {
        return this.minMz;
    }

    @Override
    public double getMaxPrecMz(String fileName) {
        return this.maxMz;
    }

    @Override
    public double getMaxPrecInt(String fileName) {
        return this.maxInt;
    }

    @Override
    public double getMaxPrecRT(String fileName) {
        return this.maxRt;
    }

    @Override
    public double getMinPrecMz() {
        return this.minMz;
    }

    @Override
    public double getMaxPrecMz() {
        return this.maxMz;
    }

    @Override
    public double getMaxPrecInt() {
        return this.maxInt;
    }

    @Override
    public double getMaxPrecRT() {
        return this.maxRt;
    }

    @Override
    public String[] getOrderedFileNamesWithoutExtensions() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public HashMap<String, String> getFilePaths() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public HashMap<String, String> getCmsFilePaths() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void close() {
        try {
            IoUtil.closeBuffer(this.mappedByteBuffer);
            this.raf.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String[] getSpectrumTitles(String fileName) {
        return this.titles;
    }

    @Override
    public ArrayList<String> getPostcursorSpectrumTitles(String fileNameWithoutExtension, String spectrumTitle) {
        if (this.postcursorMap == null || !this.postcursorMap.containsKey(spectrumTitle)) {
            return null;
        }
        return this.postcursorMap.get(spectrumTitle);
    }
}

