/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.mass_spectrometry.mzml;

import com.compomics.util.experiment.io.mass_spectrometry.MsFileIterator;
import com.compomics.util.experiment.io.mass_spectrometry.mzml.MSNumpress;
import com.compomics.util.experiment.mass_spectrometry.spectra.Precursor;
import com.compomics.util.experiment.mass_spectrometry.spectra.PrecursorParameter;
import com.compomics.util.experiment.mass_spectrometry.spectra.Spectrum;
import com.compomics.util.io.flat.SimpleFileReader;
import com.compomics.util.waiting.WaitingHandler;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.codec.binary.Base64;

public class MzmlFileIterator
implements MsFileIterator {
    private final SimpleFileReader reader;
    private final WaitingHandler waitingHandler;
    private Spectrum spectrum = null;
    private XMLStreamReader parser;

    public MzmlFileIterator(File mzmlFile, WaitingHandler waitingHandler) {
        this.reader = SimpleFileReader.getFileReader(mzmlFile);
        XMLInputFactory factory = XMLInputFactory.newInstance();
        try {
            this.parser = factory.createXMLStreamReader(this.reader.getReader());
            boolean spectrumListFound = false;
            while (this.parser.hasNext() && !spectrumListFound) {
                double progress = this.reader.getProgressInPercent();
                waitingHandler.setSecondaryProgressCounter((int)progress);
                this.parser.next();
                switch (this.parser.getEventType()) {
                    case 1: {
                        String element = this.parser.getLocalName();
                        if (!element.equalsIgnoreCase("spectrumList")) break;
                        spectrumListFound = true;
                        break;
                    }
                }
            }
            if (!spectrumListFound) {
                throw new IllegalArgumentException("Spectrum list not found when parsing mzML file!");
            }
        }
        catch (XMLStreamException ex) {
            ex.printStackTrace();
            throw new IllegalArgumentException("An exception was thrown when trying to create the mzML parser.");
        }
        this.waitingHandler = waitingHandler;
        waitingHandler.setSecondaryProgressCounterIndeterminate(false);
        waitingHandler.setMaxSecondaryProgressCounter(100);
    }

    @Override
    public String next() {
        this.spectrum = null;
        try {
            while (this.parser.hasNext()) {
                double progress = this.reader.getProgressInPercent();
                this.waitingHandler.setSecondaryProgressCounter((int)progress);
                this.parser.next();
                switch (this.parser.getEventType()) {
                    case 1: {
                        String element = this.parser.getLocalName();
                        if (!element.equalsIgnoreCase("spectrum")) break;
                        String id = this.parser.getAttributeValue("", "id");
                        this.parseSpectrum();
                        return id;
                    }
                }
            }
        }
        catch (XMLStreamException ex) {
            ex.printStackTrace();
            throw new IllegalArgumentException("An exception was thrown when trying to parse the mzML file.");
        }
        return null;
    }

    private void parseSpectrum() throws XMLStreamException {
        int spectrumLevel = -1;
        double retentionTimeInSeconds = -1.0;
        ArrayList<Integer> possibleChargesAsArray = new ArrayList<Integer>();
        double precursorMz = 0.0;
        double precursorIntensity = 0.0;
        ArrayList<String> precursorIdentifiers = new ArrayList<String>();
        double[] mzArray = new double[]{};
        double[] intensityArray = new double[]{};
        boolean mzArrayValues = true;
        Precision precision = Precision.FLOAT64BIT;
        String compression = "MS:1000574";
        block14: while (this.parser.hasNext()) {
            this.parser.next();
            switch (this.parser.getEventType()) {
                case 2: {
                    if (!"spectrum".equalsIgnoreCase(this.parser.getLocalName())) continue block14;
                    Precursor precursor = null;
                    if (spectrumLevel > 1) {
                        precursor = new Precursor(retentionTimeInSeconds, precursorMz, precursorIntensity, possibleChargesAsArray.stream().mapToInt(i -> i).toArray());
                    }
                    this.spectrum = new Spectrum(precursor, mzArray, intensityArray, spectrumLevel);
                    if (!precursorIdentifiers.isEmpty()) {
                        this.spectrum.addUrParam(new PrecursorParameter(precursorIdentifiers));
                    }
                    return;
                }
                case 1: {
                    switch (this.parser.getLocalName().toLowerCase()) {
                        case "precursor": {
                            if (this.parser.getAttributeValue("", "spectrumRef") == null) break;
                            String tempPrecursorId = this.parser.getAttributeValue("", "spectrumRef");
                            if (precursorIdentifiers.contains(tempPrecursorId)) continue block14;
                            precursorIdentifiers.add(tempPrecursorId);
                            break;
                        }
                        case "cvparam": {
                            if (this.parser.getAttributeValue("", "accession") == null) break;
                            String accession = this.parser.getAttributeValue("", "accession");
                            String value = this.parser.getAttributeValue("", "value");
                            if (accession.equalsIgnoreCase("MS:1000511")) {
                                spectrumLevel = Integer.parseInt(value);
                                break;
                            }
                            if (accession.equalsIgnoreCase("MS:1000016")) {
                                if (this.parser.getAttributeValue("", "unitName").equalsIgnoreCase("minute")) {
                                    retentionTimeInSeconds = Double.parseDouble(value) * 60.0;
                                    break;
                                }
                                if (!this.parser.getAttributeValue("", "unitName").equalsIgnoreCase("second")) continue block14;
                                retentionTimeInSeconds = Double.parseDouble(value);
                                break;
                            }
                            if (accession.equalsIgnoreCase("MS:1000041")) {
                                possibleChargesAsArray.add(Integer.valueOf(value));
                                break;
                            }
                            if (accession.equalsIgnoreCase("MS:1000744")) {
                                precursorMz = Double.parseDouble(value);
                                break;
                            }
                            if (accession.equalsIgnoreCase("MS:1000042")) {
                                precursorIntensity = Double.parseDouble(value);
                                break;
                            }
                            if (accession.equalsIgnoreCase("MS:1000514")) {
                                mzArrayValues = true;
                                break;
                            }
                            if (accession.equalsIgnoreCase("MS:1000515")) {
                                mzArrayValues = false;
                                break;
                            }
                            if (accession.equalsIgnoreCase("MS:1000521")) {
                                precision = Precision.FLOAT32BIT;
                                break;
                            }
                            if (accession.equalsIgnoreCase("MS:1000523")) {
                                precision = Precision.FLOAT64BIT;
                                break;
                            }
                            if (accession.equalsIgnoreCase("MS:1000519")) {
                                precision = Precision.INT32BIT;
                                break;
                            }
                            if (accession.equalsIgnoreCase("MS:1000522")) {
                                precision = Precision.INT64BIT;
                                break;
                            }
                            if (accession.equalsIgnoreCase("MS:1001479")) {
                                precision = Precision.NTSTRING;
                                break;
                            }
                            if (!accession.equalsIgnoreCase("MS:1000574") && !accession.equalsIgnoreCase("MS:1000576") && !accession.equalsIgnoreCase("MS:1002312") && !accession.equalsIgnoreCase("MS:1002314") && !accession.equalsIgnoreCase("MS:1002313")) continue block14;
                            compression = accession;
                            break;
                        }
                        case "binary": {
                            int i2;
                            Number[] tempNumbers;
                            String binaryAsText = this.parser.getElementText();
                            byte[] binaryDataArray = Base64.decodeBase64((byte[])binaryAsText.getBytes());
                            if (mzArrayValues) {
                                tempNumbers = this.getBinaryDataAsNumberArray(compression, precision, binaryDataArray);
                                mzArray = new double[tempNumbers.length];
                                for (i2 = 0; i2 < tempNumbers.length; ++i2) {
                                    mzArray[i2] = tempNumbers[i2].doubleValue();
                                }
                                continue block14;
                            }
                            tempNumbers = this.getBinaryDataAsNumberArray(compression, precision, binaryDataArray);
                            intensityArray = new double[tempNumbers.length];
                            for (i2 = 0; i2 < tempNumbers.length; ++i2) {
                                intensityArray[i2] = tempNumbers[i2].doubleValue();
                            }
                            continue block14;
                        }
                    }
                    continue block14;
                }
            }
        }
    }

    @Override
    public Spectrum getSpectrum() {
        return this.spectrum;
    }

    @Override
    public void close() {
        try {
            this.parser.close();
        }
        catch (XMLStreamException ex) {
            ex.printStackTrace();
            throw new IllegalArgumentException("An exception was thrown when closing the mzML parser.");
        }
        this.reader.close();
    }

    public boolean needsUncompressing(String compression) {
        return compression.equalsIgnoreCase("MS:1000574");
    }

    public Number[] getBinaryDataAsNumberArray(String compression, Precision precision, byte[] binary) {
        Number[] dataArray;
        byte[] data = this.needsUncompressing(compression) ? this.decompress(binary) : binary;
        if (compression.equalsIgnoreCase("MS:1002312") || compression.equalsIgnoreCase("MS:1002314") || compression.equalsIgnoreCase("MS:1002313")) {
            Number[] dataArray2 = MSNumpress.decode(compression, data);
            return dataArray2;
        }
        switch (precision.ordinal()) {
            case 1: {
                dataArray = this.convertData(data, Precision.FLOAT64BIT);
                break;
            }
            case 0: {
                dataArray = this.convertData(data, Precision.FLOAT32BIT);
                break;
            }
            case 3: {
                dataArray = this.convertData(data, Precision.INT64BIT);
                break;
            }
            case 2: {
                dataArray = this.convertData(data, Precision.INT32BIT);
                break;
            }
            case 4: {
                throw new IllegalArgumentException("Precision " + (Object)((Object)Precision.NTSTRING) + " is not supported in this method!");
            }
            default: {
                throw new IllegalStateException("Not supported Precision in BinaryDataArray: " + (Object)((Object)precision));
            }
        }
        return dataArray;
    }

    private Number[] convertData(byte[] data, Precision precision) {
        int step;
        switch (precision.ordinal()) {
            case 1: 
            case 3: {
                step = 8;
                break;
            }
            case 0: 
            case 2: {
                step = 4;
                break;
            }
            default: {
                step = -1;
            }
        }
        Number[] resultArray = new Number[data.length / step];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        for (int indexOut = 0; indexOut < data.length; indexOut += step) {
            Number num;
            switch (precision.ordinal()) {
                case 1: {
                    num = bb.getDouble(indexOut);
                    break;
                }
                case 3: {
                    num = bb.getLong(indexOut);
                    break;
                }
                case 0: {
                    num = Float.valueOf(bb.getFloat(indexOut));
                    break;
                }
                case 2: {
                    num = bb.getInt(indexOut);
                    break;
                }
                default: {
                    num = null;
                }
            }
            resultArray[indexOut / step] = num;
        }
        return resultArray;
    }

    private byte[] decompress(byte[] compressedData) {
        Inflater decompressor = new Inflater();
        decompressor.setInput(compressedData);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(compressedData.length);
        byte[] buf = new byte[1024];
        while (!decompressor.finished()) {
            try {
                int count = decompressor.inflate(buf);
                if (count == 0 && decompressor.needsInput()) break;
                bos.write(buf, 0, count);
            }
            catch (DataFormatException e) {
                throw new IllegalStateException("Encountered wrong data format while trying to decompress binary data!", e);
            }
        }
        try {
            bos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] decompressedData = bos.toByteArray();
        if (decompressedData == null) {
            throw new IllegalStateException("Decompression of binary data produced no result (null)!");
        }
        return decompressedData;
    }

    public static enum Precision {
        FLOAT32BIT,
        FLOAT64BIT,
        INT32BIT,
        INT64BIT,
        NTSTRING;

    }
}

