/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.temp;

import com.compomics.util.io.IoUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class TempFilesManager {
    private static final ArrayList<File> TEMP_FOLDERS_MAP = new ArrayList(0);

    public static void registerTempFolder(File tempFolder) {
        TEMP_FOLDERS_MAP.add(tempFolder);
    }

    public static void deleteTempFolders() throws IOException {
        ArrayList<String> exceptions = new ArrayList<String>();
        for (File tempFolder : TEMP_FOLDERS_MAP) {
            try {
                if (!tempFolder.exists()) continue;
                boolean bl = IoUtil.deleteDir(tempFolder);
            }
            catch (Exception e) {
                e.printStackTrace();
                exceptions.add(tempFolder.getAbsolutePath());
            }
        }
        if (!exceptions.isEmpty()) {
            String error = "An error occurred while attempting to delete the following temporary folder(s):\n";
            for (String filePath : exceptions) {
                error = error + filePath + "\n";
            }
            throw new IOException(error);
        }
    }
}

