/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.mass_spectrometry.spectra;

import com.compomics.util.experiment.biology.ions.impl.ElementaryIon;
import com.compomics.util.experiment.personalization.ExperimentObject;
import java.util.Comparator;

public class Peak
extends ExperimentObject {
    public final double mz;
    public final double intensity;
    public static final Comparator<Peak> AscendingIntensityComparator = new Comparator<Peak>(){

        @Override
        public int compare(Peak o1, Peak o2) {
            return o1.intensity < o2.intensity ? -1 : (o1.intensity == o2.intensity ? 0 : 1);
        }
    };
    public static final Comparator<Peak> DescendingIntensityComparator = new Comparator<Peak>(){

        @Override
        public int compare(Peak o1, Peak o2) {
            return o1.intensity > o2.intensity ? -1 : (o1.intensity == o2.intensity ? 0 : 1);
        }
    };
    public static final Comparator<Peak> AscendingMzComparator = new Comparator<Peak>(){

        @Override
        public int compare(Peak o1, Peak o2) {
            return o1.mz < o2.mz ? -1 : (o1.mz == o2.mz ? 0 : 1);
        }
    };

    public Peak() {
        this.mz = 0.0;
        this.intensity = 0.0;
    }

    public Peak(double mz, double intensity) {
        this.mz = mz;
        this.intensity = intensity;
    }

    public boolean isSameAs(Peak aPeak) {
        return this.mz == aPeak.mz && this.intensity == aPeak.intensity;
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + (int)(Double.doubleToLongBits(this.mz) ^ Double.doubleToLongBits(this.mz) >>> 32);
        hash = 97 * hash + (int)(Double.doubleToLongBits(this.intensity) ^ Double.doubleToLongBits(this.intensity) >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Peak other = (Peak)obj;
        if (Double.doubleToLongBits(this.mz) != Double.doubleToLongBits(other.mz)) {
            return false;
        }
        return Double.doubleToLongBits(this.intensity) == Double.doubleToLongBits(other.intensity);
    }

    public double getMass(int chargeValue) {
        return this.mz * (double)chargeValue - (double)chargeValue * ElementaryIon.proton.getTheoreticMass();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(15);
        sb.append('[');
        sb.append(this.mz);
        sb.append(',');
        sb.append(this.intensity);
        sb.append(']');
        return sb.toString();
    }
}

